/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.gui;

import ch.randelshofer.gui.Icon;
import ch.randelshofer.gui.ImageIconAWT;
import ch.randelshofer.gui.event.ChangeEvent;
import ch.randelshofer.gui.event.ChangeListener;
import ch.randelshofer.gui.event.EventListenerList;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class AbstractButton
extends Canvas
implements ItemSelectable,
MouseListener {
    private ChangeEvent changeEvent_;
    private Dimension preferredSize_;
    private Dimension minimumSize_;
    private boolean isEnabled_ = true;
    private boolean isPressed_;
    private boolean isSelected_;
    private boolean isArmed_;
    private EventListenerList listenerList_ = new EventListenerList();
    private String actionCommand_;
    private Icon selectedIcon_;
    private Icon unselectedIcon_;
    private ImageIconAWT enabledBgImage_;
    private ImageIconAWT pressedBgImage_;
    static /* synthetic */ Class class$ch$randelshofer$gui$event$ChangeListener;
    static /* synthetic */ Class class$java$awt$event$ActionListener;
    static /* synthetic */ Class class$java$awt$event$ItemListener;

    public AbstractButton() {
        this.addMouseListener(this);
    }

    public void setEnabled(boolean bl) {
        if (bl != this.isEnabled_) {
            this.isEnabled_ = bl;
            this.fireStateChanged();
            this.repaint();
        }
    }

    public boolean isEnabled() {
        return this.isEnabled_;
    }

    public void setPressed(boolean bl) {
        if (bl != this.isPressed_) {
            this.isPressed_ = bl;
            if (!bl) {
                this.fireActionPerformed(new ActionEvent(this, 1001, this.getActionCommand()));
            }
            this.fireStateChanged();
            this.repaint();
        }
    }

    public boolean isPressed() {
        return this.isPressed_;
    }

    public void setSelected(boolean bl) {
        if (bl != this.isSelected_) {
            this.isSelected_ = bl;
            this.fireItemStateChanged(new ItemEvent(this, 701, this, bl ? 1 : 2));
            this.fireStateChanged();
            this.repaint();
        }
    }

    public boolean isSelected() {
        return this.isSelected_;
    }

    public void setArmed(boolean bl) {
        if (bl != this.isArmed_) {
            this.isArmed_ = bl;
            this.fireStateChanged();
            this.repaint();
        }
    }

    public boolean isArmed() {
        return this.isArmed_;
    }

    public void setActionCommand(String string) {
        this.actionCommand_ = string;
    }

    public String getActionCommand() {
        return this.actionCommand_;
    }

    public void setSelectedIcon(Icon icon) {
        this.selectedIcon_ = icon;
    }

    public void setUnselectedIcon(Icon icon) {
        this.unselectedIcon_ = icon;
    }

    public void setEnabledBackgroundImage(Image image) {
        this.enabledBgImage_ = new ImageIconAWT(image);
    }

    public void setPressedBackgroundImage(Image image) {
        this.pressedBgImage_ = new ImageIconAWT(image);
    }

    public void setIcon(Icon icon) {
        this.setUnselectedIcon(icon);
    }

    public Icon getIcon() {
        return this.getUnselectedIcon();
    }

    public Icon getUnselectedIcon() {
        return this.unselectedIcon_;
    }

    public Icon getSelectedIcon() {
        return this.selectedIcon_;
    }

    public void paint(Graphics graphics) {
        Icon icon;
        Dimension dimension = this.getSize();
        int n = dimension.width;
        int n2 = dimension.height;
        if (this.enabledBgImage_ == null) {
            graphics.setColor(this.getForeground());
            graphics.drawRect(0, 0, n - 1, n2 - 1);
            if (!this.isEnabled_) {
                graphics.setColor(Color.lightGray);
                graphics.fillRect(1, 1, n - 1, n2 - 1);
            }
            if (this.isPressed_ && this.isArmed_) {
                graphics.setColor(Color.gray.darker());
                graphics.fillRect(1, 1, n - 3, n2 - 3);
                graphics.setColor(Color.darkGray);
                graphics.drawLine(1, 1, n - 2, 1);
                graphics.drawLine(1, 1, 1, n2 - 2);
                graphics.setColor(Color.gray);
                graphics.drawLine(2, n2 - 2, n - 2, n2 - 2);
                graphics.drawLine(n - 2, n2 - 2, n - 2, 2);
            } else {
                graphics.setColor(Color.lightGray);
                graphics.fillRect(1, 1, n - 2, n2 - 2);
                graphics.setColor(Color.white);
                graphics.drawLine(1, 1, n - 3, 1);
                graphics.drawLine(1, 1, 1, n2 - 3);
            }
        } else if (this.isPressed_ && this.isArmed_ && this.pressedBgImage_ != null) {
            this.pressedBgImage_.paintIcon(this, graphics, 0, 0);
        } else {
            this.enabledBgImage_.paintIcon(this, graphics, 0, 0);
        }
        Icon icon2 = icon = this.isSelected_ && this.selectedIcon_ != null ? this.selectedIcon_ : this.unselectedIcon_;
        if (icon != null) {
            int n3 = (n - icon.getIconWidth()) / 2;
            int n4 = (n2 - icon.getIconHeight()) / 2;
            icon.paintIcon(this, graphics, n3, n4);
        }
    }

    public Dimension getPreferredSize() {
        if (this.preferredSize_ == null) {
            Icon icon = this.getIcon();
            if (icon != null) {
                Dimension dimension = new Dimension(icon.getIconWidth() + 4, icon.getIconHeight() + 4);
                return dimension;
            }
            return super.getPreferredSize();
        }
        return this.preferredSize_;
    }

    public void setPreferredSize(Dimension dimension) {
        this.preferredSize_ = dimension;
    }

    public Dimension getMinimumSize() {
        if (this.minimumSize_ == null) {
            return super.getMinimumSize();
        }
        return this.minimumSize_;
    }

    public void setMinimumSize(Dimension dimension) {
        this.minimumSize_ = dimension;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList_.add(class$ch$randelshofer$gui$event$ChangeListener == null ? (class$ch$randelshofer$gui$event$ChangeListener = AbstractButton.class$("ch.randelshofer.gui.event.ChangeListener")) : class$ch$randelshofer$gui$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList_.remove(class$ch$randelshofer$gui$event$ChangeListener == null ? (class$ch$randelshofer$gui$event$ChangeListener = AbstractButton.class$("ch.randelshofer.gui.event.ChangeListener")) : class$ch$randelshofer$gui$event$ChangeListener, changeListener);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList_.add(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = AbstractButton.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listenerList_.remove(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = AbstractButton.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, actionListener);
    }

    public void addItemListener(ItemListener itemListener) {
        this.listenerList_.add(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = AbstractButton.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener, itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.listenerList_.remove(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = AbstractButton.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener, itemListener);
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = this.listenerList_.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$java$awt$event$ActionListener == null ? AbstractButton.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) continue;
            ((ActionListener)objectArray[i + 1]).actionPerformed(actionEvent);
        }
    }

    protected void fireItemStateChanged(ItemEvent itemEvent) {
        Object[] objectArray = this.listenerList_.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$java$awt$event$ItemListener == null ? AbstractButton.class$("java.awt.event.ItemListener") : class$java$awt$event$ItemListener)) continue;
            ((ItemListener)objectArray[i + 1]).itemStateChanged(itemEvent);
        }
    }

    protected void fireStateChanged() {
        Object[] objectArray = this.listenerList_.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != (class$ch$randelshofer$gui$event$ChangeListener == null ? AbstractButton.class$("ch.randelshofer.gui.event.ChangeListener") : class$ch$randelshofer$gui$event$ChangeListener)) continue;
            if (this.changeEvent_ == null) {
                this.changeEvent_ = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(this.changeEvent_);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.repaint();
        this.fireStateChanged();
    }

    public Object[] getSelectedObjects() {
        return null;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.setArmed(true);
        this.repaint();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.setArmed(false);
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.setArmed(true);
        this.setPressed(true);
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.setPressed(false);
        this.repaint();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

