/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.gui;

import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import java.util.Vector;

public class ImagePanelAWT
extends Canvas {
    public static final int IGNORE_PIXEL_ASPECT = 0;
    public static final int MULTIPLIED_PIXEL_ASPECT = 1;
    public static final int EXACT_PIXEL_ASPECT = 2;
    public static final int SCALE_TO_SIZE = 0;
    public static final int SCALE_TO_FIT = 1;
    public static final int SCALE_TO_ASPECT = 2;
    private Image image_;
    private double scaleX_ = 1.0;
    private double scaleY_ = 1.0;
    private int imageScalePolicy_ = 1;
    private int pixelAspectPolicy_ = 2;
    private boolean keepExactPixelAspect_ = false;
    private String[] messages;
    private PropertyChangeSupport propertyChangeSupport_ = new PropertyChangeSupport(this);
    private Image offImage_;
    private Dimension offDimension_;
    private Graphics offGraphics_;
    private static Method setRenderingHintMethod;
    private static final Object keyInterpolation;
    private static final Object valueInterpolationNearestNeighbor;
    static /* synthetic */ Class class$java$lang$Object;

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.image_ == null || this.image_.getWidth(this) == -1) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        } else {
            ImagePanelAWT.configure(graphics);
            int n = this.image_.getWidth(this);
            int n2 = this.image_.getHeight(this);
            double d = this.getPixelAspectX();
            double d2 = this.getPixelAspectY();
            switch (this.imageScalePolicy_) {
                case 1: {
                    this.setScaleFactor0((double)dimension.width / (double)n, (double)dimension.height / (double)n2);
                    try {
                        graphics.drawImage(this.image_, 0, 0, dimension.width, dimension.height, 0, 0, n, n2, this.getBackground(), this);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        graphics.drawImage(this.image_, 0, 0, dimension.width, dimension.height, this.getBackground(), this);
                    }
                    break;
                }
                case 2: {
                    double d3 = Math.min((double)dimension.width / ((double)n * d), (double)dimension.height / ((double)n2 * d2));
                    this.setScaleFactor0(d3, d3);
                    int n3 = (int)Math.ceil((double)n * d * d3);
                    int n4 = (int)Math.ceil((double)n2 * d2 * d3);
                    int n5 = (dimension.width - n3) / 2;
                    int n6 = (dimension.height - n4) / 2;
                    try {
                        graphics.drawImage(this.image_, n5, n6, n5 + n3, n6 + n4, 0, 0, n, n2, this.getBackground(), this);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        graphics.drawImage(this.image_, n5, n6, n3, n4, this.getBackground(), this);
                    }
                    if (dimension.width > n3) {
                        graphics.setColor(this.getForeground());
                        graphics.drawLine(n5 - 1, 0, n5 - 1, dimension.height - 1);
                        graphics.drawLine(n5 + n3, 0, n5 + n3, dimension.height - 1);
                        graphics.setColor(this.getBackground());
                        graphics.fillRect(0, 0, n5 - 1, dimension.height);
                        graphics.fillRect(n5 + n3 + 1, 0, dimension.width, dimension.height);
                        break;
                    }
                    if (dimension.height <= n4) break;
                    graphics.setColor(this.getForeground());
                    graphics.drawLine(0, n6 - 1, dimension.width - 1, n6 - 1);
                    graphics.drawLine(0, n6 + n4, dimension.width - 1, n6 + n4);
                    graphics.setColor(this.getBackground());
                    graphics.fillRect(0, 0, dimension.width, n6 - 2);
                    graphics.fillRect(0, n6 + n4 + 1, dimension.width, dimension.height);
                    break;
                }
                case 0: {
                    int n7 = (int)((double)n * d * this.getScaleFactorX());
                    int n8 = (int)((double)n2 * d2 * this.getScaleFactorY());
                    int n3 = (dimension.width - n7) / 2;
                    int n4 = (dimension.height - n8) / 2;
                    try {
                        graphics.drawImage(this.image_, n3, n4, n3 + n7, n4 + n8, 0, 0, n, n2, this.getBackground(), this);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        graphics.drawImage(this.image_, n3, n4, n7, n8, this.getBackground(), this);
                    }
                    graphics.setColor(this.getBackground());
                    if (dimension.width > n7) {
                        graphics.fillRect(0, 0, n3 - 1, dimension.height - 1);
                        graphics.fillRect(n3 + n7 + 1, 0, dimension.width - 1, dimension.height - 1);
                    }
                    if (dimension.height > n8) {
                        graphics.fillRect(0, 0, dimension.width - 1, n4 - 1);
                        graphics.fillRect(0, n4 + n8 + 1, dimension.width - 1, dimension.height - 1);
                    }
                    graphics.setColor(this.getForeground());
                    graphics.drawRect(n3 - 1, n4 - 1, n7 + 1, n8 + 1);
                    break;
                }
            }
        }
        String[] stringArray = this.messages;
        if (stringArray != null) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = fontMetrics.getAscent();
            int n9 = fontMetrics.getHeight();
            int n10 = 0;
            for (int i = 0; i < stringArray.length; ++i) {
                int n11 = fontMetrics.stringWidth(stringArray[i]);
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, n10, n11, n9);
                graphics.setColor(this.getForeground());
                graphics.drawString(stringArray[i], 0, n10 + n);
                n10 += n9;
            }
        }
    }

    public synchronized void setPixelAspectPolicy(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Invalid policy:" + n);
        }
        this.pixelAspectPolicy_ = n;
        this.validate();
        this.repaint();
    }

    public int getPixelAspectPolicy() {
        return this.pixelAspectPolicy_;
    }

    public synchronized void setImageScalePolicy(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalArgumentException("Invalid policy:" + n);
        }
        this.imageScalePolicy_ = n;
        this.validate();
        this.repaint();
    }

    public int getImageScalePolicy() {
        return this.imageScalePolicy_;
    }

    public double getPixelAspectX() {
        if (this.image_ == null) {
            return 1.0;
        }
        Object object = this.image_.getProperty("aspect", this);
        if (object == null) {
            return 1.0;
        }
        double d = object == null || object == Image.UndefinedProperty ? 1.0 : (Double)object;
        switch (this.pixelAspectPolicy_) {
            case 0: {
                return 1.0;
            }
            case 2: {
                return d >= 1.0 ? d : 1.0;
            }
            case 1: {
                return d >= 1.0 ? Math.floor(d + 0.5) : 1.0;
            }
        }
        throw new InternalError("Invalid pixel aspect policy: " + this.pixelAspectPolicy_);
    }

    public double getPixelAspectY() {
        if (this.image_ == null) {
            return 1.0;
        }
        Object object = this.image_.getProperty("aspect", this);
        if (object == null) {
            return 1.0;
        }
        double d = object == null || object == Image.UndefinedProperty ? 1.0 : (Double)object;
        switch (this.pixelAspectPolicy_) {
            case 0: {
                return 1.0;
            }
            case 2: {
                return d < 1.0 ? 1.0 / d : 1.0;
            }
            case 1: {
                return d < 1.0 ? Math.floor(1.0 / d + 0.5) : 1.0;
            }
        }
        throw new InternalError("Invalid pixel aspect policy: " + this.pixelAspectPolicy_);
    }

    public Dimension getPreferredImageSize() {
        if (this.image_ == null) {
            return new Dimension(0, 0);
        }
        return new Dimension((int)Math.ceil((double)this.image_.getWidth(this) * this.getPixelAspectX()), (int)Math.ceil((double)this.image_.getHeight(this) * this.getPixelAspectY()));
    }

    public Dimension getScaledImageSize() {
        if (this.image_ == null) {
            return new Dimension(0, 0);
        }
        if (this.image_.getWidth(this) == -1) {
            try {
                MediaTracker mediaTracker = new MediaTracker(this);
                mediaTracker.addImage(this.image_, 0);
                mediaTracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return new Dimension((int)Math.ceil((double)this.image_.getWidth(this) * this.getPixelAspectX() * this.getScaleFactorX()), (int)Math.ceil((double)this.image_.getHeight(this) * this.getPixelAspectY() * this.getScaleFactorY()));
    }

    public void setImage(Image image) {
        this.image_ = image;
        this.invalidate();
        if (this.getParent() != null) {
            this.getParent().validate();
            this.getParent().repaint();
        }
        this.repaint();
    }

    public Image getImage() {
        return this.image_;
    }

    public void setScaleFactor(double d, double d2) {
        this.setScaleFactor0(d, d2);
        Container container = this.getParent();
        if (container != null) {
            ((Component)container).invalidate();
            ((Component)container).validate();
        }
        this.repaint();
    }

    protected void setScaleFactor0(double d, double d2) {
        double d3 = (this.scaleX_ + this.scaleY_) / 2.0;
        this.scaleX_ = d;
        this.scaleY_ = d2;
        this.propertyChangeSupport_.firePropertyChange("scale", new Double((d + d2) / 2.0), new Double(d3));
    }

    public double getScaleFactorX() {
        return this.scaleX_;
    }

    public double getScaleFactorY() {
        return this.scaleY_;
    }

    public Dimension getPreferredSize() {
        if (this.image_ == null) {
            return new Dimension(50, 15);
        }
        return this.getScaledImageSize();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport_.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport_.addPropertyChangeListener(propertyChangeListener);
    }

    public void setMessage(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        this.messages = objectArray;
        this.repaint();
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if (n == 8) {
            return true;
        }
        return super.imageUpdate(image, n, n2, n3, n4, n5);
    }

    private static void configure(Graphics graphics) {
        if (setRenderingHintMethod != null) {
            try {
                setRenderingHintMethod.invoke((Object)graphics, keyInterpolation, valueInterpolationNearestNeighbor);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                setRenderingHintMethod = null;
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Object object;
        Object object2;
        Method method;
        try {
            Class<?> clazz = Class.forName("java.awt.Graphics2D");
            Class<?> clazz2 = Class.forName("java.awt.RenderingHints");
            Class<?> clazz3 = Class.forName("java.awt.RenderingHints$Key");
            method = clazz.getMethod("setRenderingHint", clazz3, class$java$lang$Object == null ? (class$java$lang$Object = ImagePanelAWT.class$("java.lang.Object")) : class$java$lang$Object);
            object2 = clazz2.getField("KEY_INTERPOLATION").get(null);
            object = clazz2.getField("VALUE_INTERPOLATION_NEAREST_NEIGHBOR").get(null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            method = null;
            object2 = null;
            object = null;
        }
        setRenderingHintMethod = method;
        keyInterpolation = object2;
        valueInterpolationNearestNeighbor = object;
    }
}

