/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.gui.image;

import java.awt.image.DirectColorModel;

public class HAMColorModel
extends DirectColorModel {
    public static final int HAM6 = 6;
    public static final int HAM8 = 8;
    protected int HAMType;
    protected int map_size;
    protected boolean opaque;
    protected int[] rgb;

    public HAMColorModel(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        super(24, 0xFF0000, 65280, 255);
        if (n != 6 && n != 8) {
            throw new IllegalArgumentException("Unknown HAM Type: " + n);
        }
        this.HAMType = n;
        this.setRGBs(n2, byArray, byArray2, byArray3, null);
    }

    public int getHAMType() {
        return this.HAMType;
    }

    protected void setRGBs(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
        if (n > 256) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.map_size = n;
        this.rgb = new int[256];
        int n2 = 255;
        this.opaque = true;
        for (int i = 0; i < n; ++i) {
            if (byArray4 != null && (n2 = byArray4[i] & 0xFF) != 255) {
                this.opaque = false;
            }
            this.rgb[i] = n2 << 24 | (byArray[i] & 0xFF) << 16 | (byArray2[i] & 0xFF) << 8 | byArray3[i] & 0xFF;
        }
    }

    public final void getReds(byte[] byArray) {
        for (int i = 0; i < this.map_size; ++i) {
            byArray[i] = (byte)(this.rgb[i] >> 16);
        }
    }

    public final void getGreens(byte[] byArray) {
        for (int i = 0; i < this.map_size; ++i) {
            byArray[i] = (byte)(this.rgb[i] >> 8);
        }
    }

    public final void getBlues(byte[] byArray) {
        for (int i = 0; i < this.map_size; ++i) {
            byArray[i] = (byte)this.rgb[i];
        }
    }

    public final void getRGBs(int[] nArray) {
        for (int i = 0; i < this.map_size; ++i) {
            nArray[i] = this.rgb[i];
        }
    }

    public final int getMapSize() {
        return this.map_size;
    }
}

