/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.iff;

import ch.randelshofer.iff.IFFChunk;
import ch.randelshofer.iff.IFFVisitor;
import ch.randelshofer.iff.MC68000InputStream;
import ch.randelshofer.iff.ParseException;
import ch.randelshofer.util.AbortException;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public class IFFParser {
    public static final int FORM_ID = 1179603533;
    public static final int CAT_ID = 1128354848;
    public static final int LIST_ID = 1279873876;
    public static final int PROP_ID = 1347571536;
    public static final int NULL_ID = 0x20202020;
    public static final int[] RESERVED_IDs = new int[]{1279873876, 1179603533, 1347571536, 1128354848, 0x20202020, 1279873841, 1279873842, 1279873843, 1279873844, 1279873845, 1279873846, 1279873847, 1279873848, 1279873849, 1179603505, 1179603506, 1179603507, 1179603508, 1179603509, 1179603510, 1179603511, 1179603512, 1179603513, 1128354865, 1128354866, 1128354867, 1128354868, 1128354869, 1128354870, 1128354871, 1128354872, 1128354873};
    private long scan_;
    private IFFVisitor visitor_;
    private Hashtable dataChunks_;
    private Hashtable propertyChunks_;
    private Hashtable collectionChunks_;
    private Hashtable groupChunks_;
    private MC68000InputStream in_;

    public void parse(InputStream inputStream, IFFVisitor iFFVisitor) throws ParseException, AbortException, IOException {
        this.in_ = new MC68000InputStream(new BufferedInputStream(inputStream));
        this.visitor_ = iFFVisitor;
        this.parseFile();
    }

    private void parseFile() throws ParseException, AbortException, IOException {
        int n = this.in_.readLONG();
        switch (n) {
            case 1179603533: {
                this.parseFORM(null);
                break;
            }
            case 1128354848: {
                this.parseCAT(null);
                break;
            }
            case 1279873876: {
                this.parseLIST(null);
                break;
            }
            default: {
                throw new ParseException("IFF-85 files must start with 'FORM', 'CAT ', or 'LIST'. But not with: '" + IFFParser.idToString(n) + "'");
            }
        }
    }

    private void parseFORM(Hashtable hashtable) throws ParseException, AbortException, IOException {
        long l = this.in_.readULONG();
        long l2 = this.in_.getScan();
        int n = this.in_.readLONG();
        if (!IFFParser.isFormType(n)) {
            throw new ParseException("Invalid Form Type: " + IFFParser.idToString(n));
        }
        IFFChunk iFFChunk = hashtable == null ? null : (IFFChunk)hashtable.get(new Integer(n));
        IFFChunk iFFChunk2 = new IFFChunk(n, 1179603533, l, l2, iFFChunk);
        if (this.isGroupChunk(iFFChunk2)) {
            this.visitor_.enterGroup(iFFChunk2);
        }
        long l3 = l2 + l;
        try {
            while (this.in_.getScan() < l3) {
                long l4 = this.in_.getScan();
                int n2 = this.in_.readLONG();
                switch (n2) {
                    case 1179603533: {
                        this.parseFORM(hashtable);
                        break;
                    }
                    case 1128354848: {
                        this.parseCAT(hashtable);
                        break;
                    }
                    case 1279873876: {
                        this.parseLIST(hashtable);
                        break;
                    }
                    default: {
                        if (IFFParser.isLocalChunkID(n2)) {
                            this.parseLocalChunk(iFFChunk2, n2);
                            break;
                        }
                        throw new ParseException("Invalid IFFChunk within FORM: " + IFFParser.idToString(n2) + " at offset:" + l4);
                    }
                }
                this.in_.align();
            }
        }
        catch (EOFException eOFException) {
            System.out.println("Unexpected EOF after:" + (this.in_.getScan() - l2) + " should be:" + l);
        }
        if (this.isGroupChunk(iFFChunk2)) {
            this.visitor_.leaveGroup(iFFChunk2);
        }
    }

    private void parseCAT(Hashtable hashtable) throws ParseException, AbortException, IOException {
        long l = this.in_.readULONG();
        long l2 = this.in_.getScan();
        int n = this.in_.readLONG();
        if (!IFFParser.isContentType(n)) {
            throw new ParseException("Invalid Content Type: " + IFFParser.idToString(n));
        }
        IFFChunk iFFChunk = hashtable == null ? null : (IFFChunk)hashtable.get(new Integer(n));
        IFFChunk iFFChunk2 = new IFFChunk(n, 1128354848, l, l2, iFFChunk);
        if (this.isGroupChunk(iFFChunk2)) {
            this.visitor_.enterGroup(iFFChunk2);
        }
        long l3 = l2 + l;
        while (this.in_.getScan() < l3) {
            int n2 = this.in_.readLONG();
            switch (n2) {
                case 1179603533: {
                    this.parseFORM(hashtable);
                    break;
                }
                case 1128354848: {
                    this.parseCAT(hashtable);
                    break;
                }
                case 1279873876: {
                    this.parseLIST(hashtable);
                    break;
                }
                default: {
                    throw new ParseException("Invalid IFFChunk within CAT: " + IFFParser.idToString(n2));
                }
            }
            this.in_.align();
        }
        if (this.isGroupChunk(iFFChunk2)) {
            this.visitor_.leaveGroup(iFFChunk2);
        }
    }

    private void parseLIST(Hashtable hashtable) throws ParseException, AbortException, IOException {
        long l = this.in_.readULONG();
        long l2 = this.in_.getScan();
        int n = this.in_.readLONG();
        if (!IFFParser.isFormType(n)) {
            throw new ParseException("Invalid Form Type: " + IFFParser.idToString(n));
        }
        IFFChunk iFFChunk = hashtable == null ? null : (IFFChunk)hashtable.get(new Integer(n));
        IFFChunk iFFChunk2 = new IFFChunk(n, 1279873876, l, l2, iFFChunk);
        if (this.isGroupChunk(iFFChunk2)) {
            this.visitor_.enterGroup(iFFChunk2);
        }
        hashtable = new Hashtable<Integer, IFFChunk>();
        long l3 = l2 + l;
        while (this.in_.getScan() < l3) {
            int n2 = this.in_.readLONG();
            switch (n2) {
                case 1179603533: {
                    this.parseFORM(hashtable);
                    break;
                }
                case 1128354848: {
                    this.parseCAT(hashtable);
                    break;
                }
                case 1279873876: {
                    this.parseLIST(hashtable);
                    break;
                }
                case 1347571536: {
                    IFFChunk iFFChunk3 = this.parsePROP();
                    hashtable.put(new Integer(iFFChunk3.getType()), iFFChunk3);
                    break;
                }
                default: {
                    if (IFFParser.isLocalChunkID(n2)) {
                        this.parseLocalChunk(iFFChunk2, n2);
                        break;
                    }
                    throw new ParseException("Invalid IFFChunk ID within LIST: " + IFFParser.idToString(n2));
                }
            }
            this.in_.align();
        }
        if (this.isGroupChunk(iFFChunk2)) {
            this.visitor_.leaveGroup(iFFChunk2);
        }
    }

    private IFFChunk parsePROP() throws ParseException, AbortException, IOException {
        long l = this.in_.readULONG();
        long l2 = this.in_.getScan();
        int n = this.in_.readLONG();
        if (!IFFParser.isFormType(n)) {
            throw new ParseException("Invalid Form Type: " + IFFParser.idToString(n));
        }
        IFFChunk iFFChunk = new IFFChunk(n, 1347571536, l, l2);
        if (this.isGroupChunk(iFFChunk)) {
            this.visitor_.enterGroup(iFFChunk);
        }
        long l3 = l2 + l;
        while (this.in_.getScan() < l3) {
            int n2 = this.in_.readLONG();
            if (!IFFParser.isLocalChunkID(n2)) {
                throw new ParseException("Invalid IFFChunk ID within PROP: " + IFFParser.idToString(n2));
            }
            this.parseLocalChunk(iFFChunk, n2);
            this.in_.align();
        }
        if (this.isGroupChunk(iFFChunk)) {
            this.visitor_.leaveGroup(iFFChunk);
        }
        return iFFChunk;
    }

    private void parseLocalChunk(IFFChunk iFFChunk, int n) throws ParseException, AbortException, IOException {
        long l = this.in_.readULONG();
        long l2 = this.in_.getScan();
        IFFChunk iFFChunk2 = new IFFChunk(iFFChunk.getType(), n, l, l2);
        if (this.isDataChunk(iFFChunk2)) {
            byte[] byArray = new byte[(int)l];
            this.in_.read(byArray, 0, (int)l);
            iFFChunk2.setData(byArray);
            this.visitor_.visitChunk(iFFChunk, iFFChunk2);
        } else if (this.isPropertyChunk(iFFChunk2)) {
            byte[] byArray = new byte[(int)l];
            this.in_.read(byArray, 0, (int)l);
            iFFChunk2.setData(byArray);
            iFFChunk.putPropertyChunk(iFFChunk2);
        } else if (this.isCollectionChunk(iFFChunk2)) {
            byte[] byArray = new byte[(int)l];
            this.in_.read(byArray, 0, (int)l);
            iFFChunk2.setData(byArray);
            iFFChunk.addCollectionChunk(iFFChunk2);
        } else {
            this.in_.skipFully((int)l);
        }
    }

    protected boolean isDataChunk(IFFChunk iFFChunk) {
        if (this.dataChunks_ == null) {
            return this.collectionChunks_ == null && this.propertyChunks_ == null;
        }
        return this.dataChunks_.containsKey(iFFChunk);
    }

    protected boolean isGroupChunk(IFFChunk iFFChunk) {
        if (this.groupChunks_ == null) {
            return true;
        }
        return this.groupChunks_.containsKey(new Integer(iFFChunk.getID()));
    }

    protected boolean isPropertyChunk(IFFChunk iFFChunk) {
        if (this.propertyChunks_ == null) {
            return false;
        }
        return this.propertyChunks_.containsKey(iFFChunk);
    }

    protected boolean isCollectionChunk(IFFChunk iFFChunk) {
        if (this.collectionChunks_ == null) {
            return false;
        }
        return this.collectionChunks_.containsKey(iFFChunk);
    }

    public void declareDataChunk(int n, int n2) {
        IFFChunk iFFChunk = new IFFChunk(n, n2);
        if (this.dataChunks_ == null) {
            this.dataChunks_ = new Hashtable();
        }
        this.dataChunks_.put(iFFChunk, iFFChunk);
    }

    public void declareGroupChunk(int n, int n2) {
        IFFChunk iFFChunk = new IFFChunk(n, n2);
        if (this.groupChunks_ == null) {
            this.groupChunks_ = new Hashtable();
        }
        this.groupChunks_.put(new Integer(n2), iFFChunk);
    }

    public void declarePropertyChunk(int n, int n2) {
        IFFChunk iFFChunk = new IFFChunk(n, n2);
        if (this.propertyChunks_ == null) {
            this.propertyChunks_ = new Hashtable();
        }
        this.propertyChunks_.put(iFFChunk, iFFChunk);
    }

    public void declareCollectionChunk(int n, int n2) {
        IFFChunk iFFChunk = new IFFChunk(n, n2);
        if (this.collectionChunks_ == null) {
            this.collectionChunks_ = new Hashtable();
        }
        this.collectionChunks_.put(iFFChunk, iFFChunk);
    }

    public static boolean isGroupID(int n) {
        return n == 1179603533 || n == 1128354848 || n == 1279873876 || n == 1347571536;
    }

    public static boolean isID(int n) {
        int n2 = n >> 24;
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        if (n2 < 32 || n2 > 126 || n3 < 32 || n3 > 126 || n4 < 32 || n4 > 126 || n5 < 32 || n5 > 126) {
            return false;
        }
        return n == 0x20202020 || n2 != 32;
    }

    public static boolean isLocalChunkID(int n) {
        if (n == 0x20202020) {
            return false;
        }
        if (IFFParser.isGroupID(n)) {
            return false;
        }
        return IFFParser.isID(n);
    }

    public static boolean isReservedID(int n) {
        for (int i = 0; i < RESERVED_IDs.length; ++i) {
            if (n != RESERVED_IDs[i]) continue;
            return true;
        }
        return false;
    }

    public static boolean isFormType(int n) {
        if (IFFParser.isReservedID(n)) {
            return false;
        }
        int n2 = n >> 24;
        int n3 = n >> 16 & 0xFF;
        int n4 = n >> 8 & 0xFF;
        int n5 = n & 0xFF;
        if (n2 < 48 || n2 > 90 || n2 > 73 && n2 < 65 || n3 < 48 && n3 != 32 || n3 > 90 || n3 > 73 && n3 < 65 || n4 < 48 && n4 != 32 || n4 > 90 || n4 > 73 && n4 < 65 || n5 < 48 && n5 != 32 || n5 > 90 || n5 > 73 && n5 < 65) {
            return false;
        }
        return !IFFParser.isGroupID(n);
    }

    public static boolean isContentType(int n) {
        if (n == 0x20202020) {
            return true;
        }
        return IFFParser.isFormType(n);
    }

    public static String idToString(int n) {
        byte[] byArray = new byte[]{(byte)(n >>> 24), (byte)(n >>> 16), (byte)(n >>> 8), (byte)(n >>> 0)};
        return new String(byArray);
    }

    public static int stringToID(String string) {
        byte[] byArray = string.getBytes();
        return byArray[0] << 24 | byArray[1] << 16 | byArray[2] << 8 | byArray[3] << 0;
    }
}

