/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SuspendableInputStream
extends FilterInputStream {
    private static final int ACTIVE = 0;
    private static final int SUSPENDED = 1;
    private static final int ABORTED = 2;
    private volatile int state = 0;

    public SuspendableInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public synchronized void suspend() {
        if (this.state == 0) {
            this.state = 1;
            this.notifyAll();
        }
    }

    public synchronized void resume() {
        if (this.state == 1) {
            this.state = 0;
            this.notifyAll();
        }
    }

    public synchronized void abort() {
        if (this.state != 2) {
            this.state = 2;
            this.notifyAll();
        }
    }

    public boolean isSuspended() {
        return this.state == 1;
    }

    public boolean isAborted() {
        return this.state == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        SuspendableInputStream suspendableInputStream = this;
        synchronized (suspendableInputStream) {
            while (this.state == 1) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.state == 2) {
            throw new IOException("Aborted");
        }
        return super.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] byArray) throws IOException {
        SuspendableInputStream suspendableInputStream = this;
        synchronized (suspendableInputStream) {
            while (this.state == 1) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.state == 2) {
            throw new IOException("Aborted");
        }
        return super.read(byArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] byArray, int n, int n2) throws IOException {
        SuspendableInputStream suspendableInputStream = this;
        synchronized (suspendableInputStream) {
            while (this.state == 1) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.state == 2) {
            throw new IOException("Aborted");
        }
        return super.read(byArray, n, n2);
    }
}

