/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.media;

import ch.randelshofer.gui.BoundedRangeModel;
import ch.randelshofer.gui.event.ChangeEvent;
import ch.randelshofer.gui.event.ChangeListener;
import ch.randelshofer.gui.event.EventListenerList;
import ch.randelshofer.media.Player;
import ch.randelshofer.util.SequentialDispatcher;
import ch.randelshofer.util.StateEvent;
import ch.randelshofer.util.StateListener;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public abstract class AbstractPlayer
implements Player,
Runnable {
    private int state = 0;
    private int targetState = 0;
    protected EventListenerList listenerList = new EventListenerList();
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    protected SequentialDispatcher dispatcher = new SequentialDispatcher();
    static /* synthetic */ Class class$ch$randelshofer$util$StateListener;
    static /* synthetic */ Class class$ch$randelshofer$gui$event$ChangeListener;

    public int getState() {
        return this.state;
    }

    public int getTargetState() {
        return this.targetState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTargetState(int n) {
        AbstractPlayer abstractPlayer = this;
        synchronized (abstractPlayer) {
            if (this.targetState != -1) {
                this.targetState = n;
                this.notifyAll();
                this.dispatcher.dispatch(this);
            }
        }
    }

    public void realize() {
        switch (this.getState()) {
            case -1: {
                throw new IllegalStateException("Realize closed player.");
            }
            case 5: {
                throw new IllegalStateException("Realize started player.");
            }
        }
        this.setTargetState(2);
    }

    public void prefetch() {
        switch (this.getState()) {
            case -1: {
                throw new IllegalStateException("Prefetch closed player.");
            }
            case 5: {
                throw new IllegalStateException("Prefetch started player.");
            }
        }
        this.setTargetState(4);
    }

    public void deallocate() {
        switch (this.getState()) {
            case -1: {
                throw new IllegalStateException("Deallocate closed player.");
            }
            case 1: {
                this.setTargetState(0);
                break;
            }
            case 3: {
                this.setTargetState(2);
                break;
            }
            case 4: {
                this.setTargetState(2);
                break;
            }
            case 5: {
                throw new IllegalStateException("Deallocate started player.");
            }
        }
    }

    public void start() {
        switch (this.getState()) {
            case -1: {
                throw new IllegalStateException("Deallocate closed player.");
            }
        }
        this.setTargetState(5);
    }

    public void stop() {
        switch (this.getState()) {
            case -1: {
                break;
            }
            case 5: {
                this.setTargetState(4);
            }
        }
    }

    public void close() {
        this.setTargetState(-1);
    }

    public void addStateListener(StateListener stateListener) {
        this.listenerList.add(class$ch$randelshofer$util$StateListener == null ? (class$ch$randelshofer$util$StateListener = AbstractPlayer.class$("ch.randelshofer.util.StateListener")) : class$ch$randelshofer$util$StateListener, stateListener);
    }

    public void removeStateListener(StateListener stateListener) {
        this.listenerList.remove(class$ch$randelshofer$util$StateListener == null ? (class$ch$randelshofer$util$StateListener = AbstractPlayer.class$("ch.randelshofer.util.StateListener")) : class$ch$randelshofer$util$StateListener, stateListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    protected void fireStateChanged(int n) {
        StateEvent stateEvent = null;
        ChangeEvent changeEvent = null;
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] == (class$ch$randelshofer$util$StateListener == null ? AbstractPlayer.class$("ch.randelshofer.util.StateListener") : class$ch$randelshofer$util$StateListener)) {
                if (stateEvent == null) {
                    stateEvent = new StateEvent(this, n);
                }
                ((StateListener)objectArray[i + 1]).stateChanged(stateEvent);
            }
            if (objectArray[i] != (class$ch$randelshofer$gui$event$ChangeListener == null ? AbstractPlayer.class$("ch.randelshofer.gui.event.ChangeListener") : class$ch$randelshofer$gui$event$ChangeListener)) continue;
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }

    public void run() {
        while (this.state != this.targetState) {
            this.state = this.targetState > this.state ? ++this.state : this.targetState;
            this.fireStateChanged(this.state);
            switch (this.state) {
                case -1: {
                    this.doClosed();
                    break;
                }
                case 0: {
                    this.doUnrealized();
                    break;
                }
                case 1: {
                    this.doRealizing();
                    break;
                }
                case 2: {
                    this.doRealized();
                    break;
                }
                case 3: {
                    this.doPrefetching();
                    break;
                }
                case 4: {
                    this.doPrefetched();
                    break;
                }
                case 5: {
                    this.doStarted();
                    this.setTargetState(4);
                }
            }
        }
    }

    protected abstract void doClosed();

    protected abstract void doUnrealized();

    protected abstract void doRealizing();

    protected abstract void doRealized();

    protected abstract void doPrefetching();

    protected abstract void doPrefetched();

    protected abstract void doStarted();

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(class$ch$randelshofer$gui$event$ChangeListener == null ? (class$ch$randelshofer$gui$event$ChangeListener = AbstractPlayer.class$("ch.randelshofer.gui.event.ChangeListener")) : class$ch$randelshofer$gui$event$ChangeListener, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(class$ch$randelshofer$gui$event$ChangeListener == null ? (class$ch$randelshofer$gui$event$ChangeListener = AbstractPlayer.class$("ch.randelshofer.gui.event.ChangeListener")) : class$ch$randelshofer$gui$event$ChangeListener, changeListener);
    }

    public boolean isActive() {
        return this.getTargetState() == 5;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public abstract /* synthetic */ long getTotalDuration();

    public abstract /* synthetic */ Component getControlPanelComponent();

    public abstract /* synthetic */ Component getVisualComponent();

    public abstract /* synthetic */ BoundedRangeModel getCachingModel();

    public abstract /* synthetic */ BoundedRangeModel getTimeModel();

    public abstract /* synthetic */ boolean isAudioAvailable();

    public abstract /* synthetic */ boolean isAudioEnabled();

    public abstract /* synthetic */ void setAudioEnabled(boolean var1);
}

