/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.media;

import ch.randelshofer.gui.AbstractButton;
import ch.randelshofer.gui.BoundedRangeModel;
import ch.randelshofer.gui.ImageIconAWT;
import ch.randelshofer.gui.ToggleButton;
import ch.randelshofer.gui.event.ChangeEvent;
import ch.randelshofer.gui.event.ChangeListener;
import ch.randelshofer.media.MovieSliderAqua;
import ch.randelshofer.media.Player;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class MovieControlAqua
extends Panel
implements ActionListener,
ItemListener,
ChangeListener,
PropertyChangeListener {
    private Player player;
    private MovieSliderAqua slider;
    private AbstractButton forwardButton;
    private AbstractButton rewindButton;
    private ToggleButton startButton;
    private ToggleButton audioButton;
    private BoundedRangeModel boundedRangeModel;
    private static final Image bgWest = Toolkit.getDefaultToolkit().getImage((class$ch$randelshofer$media$MovieControlAqua == null ? (class$ch$randelshofer$media$MovieControlAqua = MovieControlAqua.class$("ch.randelshofer.media.MovieControlAqua")) : class$ch$randelshofer$media$MovieControlAqua).getResource("images/moviecontrol_bg_west.gif"));
    private static final Image bgEast = Toolkit.getDefaultToolkit().getImage((class$ch$randelshofer$media$MovieControlAqua == null ? (class$ch$randelshofer$media$MovieControlAqua = MovieControlAqua.class$("ch.randelshofer.media.MovieControlAqua")) : class$ch$randelshofer$media$MovieControlAqua).getResource("images/moviecontrol_bg_east.gif"));
    private static final Image bgWestPressed = Toolkit.getDefaultToolkit().getImage((class$ch$randelshofer$media$MovieControlAqua == null ? (class$ch$randelshofer$media$MovieControlAqua = MovieControlAqua.class$("ch.randelshofer.media.MovieControlAqua")) : class$ch$randelshofer$media$MovieControlAqua).getResource("images/moviecontrol_bg_west_pressed.gif"));
    private static final Image bgEastPressed = Toolkit.getDefaultToolkit().getImage((class$ch$randelshofer$media$MovieControlAqua == null ? (class$ch$randelshofer$media$MovieControlAqua = MovieControlAqua.class$("ch.randelshofer.media.MovieControlAqua")) : class$ch$randelshofer$media$MovieControlAqua).getResource("images/moviecontrol_bg_east_pressed.gif"));
    private static final ImageIconAWT icnAudio = new ImageIconAWT((class$ch$randelshofer$media$MovieControlAqua == null ? (class$ch$randelshofer$media$MovieControlAqua = MovieControlAqua.class$("ch.randelshofer.media.MovieControlAqua")) : class$ch$randelshofer$media$MovieControlAqua).getResource("images/icn_audio.gif"));
    private static final ImageIconAWT icnAudioSelected = new ImageIconAWT((class$ch$randelshofer$media$MovieControlAqua == null ? (class$ch$randelshofer$media$MovieControlAqua = MovieControlAqua.class$("ch.randelshofer.media.MovieControlAqua")) : class$ch$randelshofer$media$MovieControlAqua).getResource("images/icn_audio_selected.gif"));
    private static final ImageIconAWT icnPlay = new ImageIconAWT((class$ch$randelshofer$media$MovieControlAqua == null ? (class$ch$randelshofer$media$MovieControlAqua = MovieControlAqua.class$("ch.randelshofer.media.MovieControlAqua")) : class$ch$randelshofer$media$MovieControlAqua).getResource("images/icn_play.gif"));
    private static final ImageIconAWT icnPause = new ImageIconAWT((class$ch$randelshofer$media$MovieControlAqua == null ? (class$ch$randelshofer$media$MovieControlAqua = MovieControlAqua.class$("ch.randelshofer.media.MovieControlAqua")) : class$ch$randelshofer$media$MovieControlAqua).getResource("images/icn_pause.gif"));
    private static final ImageIconAWT icnBack = new ImageIconAWT((class$ch$randelshofer$media$MovieControlAqua == null ? (class$ch$randelshofer$media$MovieControlAqua = MovieControlAqua.class$("ch.randelshofer.media.MovieControlAqua")) : class$ch$randelshofer$media$MovieControlAqua).getResource("images/icn_back.gif"));
    private static final ImageIconAWT icnNext = new ImageIconAWT((class$ch$randelshofer$media$MovieControlAqua == null ? (class$ch$randelshofer$media$MovieControlAqua = MovieControlAqua.class$("ch.randelshofer.media.MovieControlAqua")) : class$ch$randelshofer$media$MovieControlAqua).getResource("images/icn_next.gif"));
    static /* synthetic */ Class class$ch$randelshofer$media$MovieControlAqua;

    public MovieControlAqua() {
        this.setBackground(new Color(118, 118, 118));
        Dimension dimension = new Dimension(16, 16);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.audioButton = new ToggleButton();
        this.audioButton.addItemListener(this);
        this.audioButton.setPreferredSize(dimension);
        this.audioButton.setMinimumSize(dimension);
        this.audioButton.setVisible(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagLayout.setConstraints(this.audioButton, gridBagConstraints);
        this.add(this.audioButton);
        this.startButton = new ToggleButton();
        this.startButton.addItemListener(this);
        this.startButton.setPreferredSize(dimension);
        this.startButton.setMinimumSize(dimension);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(this.startButton, gridBagConstraints);
        this.add(this.startButton);
        this.slider = new MovieSliderAqua();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.slider, gridBagConstraints);
        this.add(this.slider);
        this.rewindButton = new AbstractButton();
        this.rewindButton.setPreferredSize(dimension);
        this.rewindButton.setMinimumSize(dimension);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagLayout.setConstraints(this.rewindButton, gridBagConstraints);
        this.add(this.rewindButton);
        this.rewindButton.addActionListener(this);
        this.forwardButton = new AbstractButton();
        dimension = new Dimension(17, 16);
        this.forwardButton.setPreferredSize(dimension);
        this.forwardButton.setMinimumSize(dimension);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagLayout.setConstraints(this.forwardButton, gridBagConstraints);
        this.add(this.forwardButton);
        this.forwardButton.addActionListener(this);
        Image image = bgWest;
        this.startButton.setEnabledBackgroundImage(image);
        this.audioButton.setEnabledBackgroundImage(image);
        this.rewindButton.setEnabledBackgroundImage(image);
        image = bgEast;
        this.forwardButton.setEnabledBackgroundImage(image);
        image = bgWestPressed;
        this.rewindButton.setPressedBackgroundImage(image);
        this.startButton.setPressedBackgroundImage(image);
        this.audioButton.setPressedBackgroundImage(image);
        image = bgEastPressed;
        this.forwardButton.setPressedBackgroundImage(image);
        this.audioButton.setUnselectedIcon(icnAudio);
        this.audioButton.setSelectedIcon(icnAudioSelected);
        this.startButton.setUnselectedIcon(icnPlay);
        this.startButton.setSelectedIcon(icnPause);
        this.rewindButton.setIcon(icnBack);
        this.forwardButton.setIcon(icnNext);
    }

    public synchronized void setPlayer(Player player) {
        if (this.player != null) {
            this.player.removeChangeListener(this);
            player.removePropertyChangeListener(this);
        }
        this.player = player;
        this.boundedRangeModel = player == null ? null : player.getTimeModel();
        this.slider.setModel(this.boundedRangeModel);
        if (player != null) {
            this.slider.setProgressModel(player.getCachingModel());
            this.startButton.setSelected(player.isActive());
            player.addChangeListener(this);
            player.addPropertyChangeListener(this);
            this.audioButton.setVisible(player.isAudioAvailable());
            this.audioButton.setSelected(player.isAudioEnabled());
            this.validate();
            this.repaint();
            BoundedRangeModel boundedRangeModel = this.slider.getProgressModel();
        }
    }

    public void setProgressModel(BoundedRangeModel boundedRangeModel) {
        this.slider.setProgressModel(boundedRangeModel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this.boundedRangeModel != null) {
            int n = this.boundedRangeModel.getValue();
            if (object == this.forwardButton) {
                this.boundedRangeModel.setValue(n == this.boundedRangeModel.getMaximum() ? this.boundedRangeModel.getMinimum() : n + 1);
            } else if (object == this.rewindButton) {
                this.boundedRangeModel.setValue(n == this.boundedRangeModel.getMinimum() ? this.boundedRangeModel.getMaximum() : n - 1);
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.player == null) {
            return;
        }
        if (this.startButton.isSelected() != this.player.isActive()) {
            if (this.startButton.isSelected()) {
                this.player.start();
            } else {
                this.player.stop();
            }
        }
        this.player.setAudioEnabled(this.audioButton.isSelected());
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.startButton.setSelected(this.player.isActive());
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("audioEnabled")) {
            this.audioButton.setSelected(this.player.isAudioEnabled());
        }
        if (propertyChangeEvent.getPropertyName().equals("audioAvailable")) {
            this.audioButton.setVisible(this.player.isAudioAvailable());
            this.validate();
            this.repaint();
        }
        if (propertyChangeEvent.getPropertyName().equals("cached")) {
            BoundedRangeModel boundedRangeModel = this.slider.getProgressModel();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

