/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.media;

import ch.randelshofer.gui.BoundedRangeModel;
import ch.randelshofer.gui.DefaultBoundedRangeModel;
import ch.randelshofer.gui.event.ChangeEvent;
import ch.randelshofer.gui.event.ChangeListener;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class MovieSliderAqua
extends Canvas
implements ChangeListener,
MouseListener,
MouseMotionListener {
    private static final int THUMB_WIDTH = 16;
    private static final int THUMB_HEIGHT = 16;
    private static final int HALF_THUMB_WIDTH = 8;
    private BoundedRangeModel model_;
    protected int thumbPos_ = 0;
    private int progressPos_ = 0;
    private BoundedRangeModel progressModel_;
    private boolean isPressed;
    private boolean isArmed;
    private static Image trackEastImage;
    private static Image trackCenterImage;
    private static Image trackWestImage;
    private static Image trackEastUnloadedImage;
    private static Image trackCenterUnloadedImage;
    private static Image trackWestUnloadedImage;
    private static Image thumbImage;
    private static Image thumbPressedImage;
    protected Graphics backGfx;
    protected Image backImg;
    protected Dimension backSize = new Dimension(0, 0);

    public MovieSliderAqua() {
        this.model_ = new DefaultBoundedRangeModel();
        this.model_.addChangeListener(this);
        this.progressModel_ = new DefaultBoundedRangeModel();
        this.progressModel_.setValue(this.progressModel_.getMaximum());
        this.progressModel_.addChangeListener(this);
        this.setBackground(Color.lightGray);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        if (trackEastImage == null) {
            Toolkit toolkit = this.getToolkit();
            Class<?> clazz = this.getClass();
            trackEastImage = toolkit.getImage(clazz.getResource("images/slider_track_east.gif"));
            trackCenterImage = toolkit.getImage(clazz.getResource("images/slider_track_center.gif"));
            trackWestImage = toolkit.getImage(clazz.getResource("images/slider_track_west.gif"));
            trackEastUnloadedImage = toolkit.getImage(clazz.getResource("images/slider_track_east_unloaded.gif"));
            trackCenterUnloadedImage = toolkit.getImage(clazz.getResource("images/slider_track_center_unloaded.gif"));
            trackWestUnloadedImage = toolkit.getImage(clazz.getResource("images/slider_track_west_unloaded.gif"));
            thumbImage = toolkit.getImage(clazz.getResource("images/slider_thumb.png"));
            thumbPressedImage = toolkit.getImage(clazz.getResource("images/slider_thumb_pressed.png"));
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(trackEastImage, 0);
            mediaTracker.addImage(trackCenterImage, 0);
            mediaTracker.addImage(trackWestImage, 0);
            mediaTracker.addImage(trackEastUnloadedImage, 0);
            mediaTracker.addImage(trackCenterUnloadedImage, 0);
            mediaTracker.addImage(trackWestUnloadedImage, 0);
            mediaTracker.addImage(thumbImage, 0);
            mediaTracker.addImage(thumbPressedImage, 0);
            mediaTracker.checkAll(true);
        }
    }

    public synchronized void setModel(BoundedRangeModel boundedRangeModel) {
        if (this.model_ != null) {
            this.model_.removeChangeListener(this);
        }
        BoundedRangeModel boundedRangeModel2 = this.model_ = boundedRangeModel == null ? new DefaultBoundedRangeModel() : boundedRangeModel;
        if (this.model_ != null) {
            this.model_.addChangeListener(this);
        }
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return new Dimension(100, 16);
    }

    public Dimension getMinimumSize() {
        return new Dimension(16, 16);
    }

    protected void moveThumb(int n) {
        int n2 = this.getSize().width;
        float f = (float)(n - 8) / (float)(n2 - 16);
        this.model_.setValue((int)(f * (float)(this.model_.getMaximum() - this.model_.getMinimum())));
    }

    protected int computeThumbPos() {
        BoundedRangeModel boundedRangeModel = this.model_;
        if (boundedRangeModel == null) {
            return 0;
        }
        int n = this.getSize().width - 16;
        float f = Math.max(0.0f, (float)boundedRangeModel.getValue() / (float)(boundedRangeModel.getMaximum() - boundedRangeModel.getMinimum()));
        return (int)((float)n * f);
    }

    public synchronized void setProgressModel(BoundedRangeModel boundedRangeModel) {
        if (this.progressModel_ != null) {
            this.progressModel_.removeChangeListener(this);
        }
        BoundedRangeModel boundedRangeModel2 = this.progressModel_ = boundedRangeModel == null ? new DefaultBoundedRangeModel() : boundedRangeModel;
        if (this.progressModel_ != null) {
            this.progressModel_.addChangeListener(this);
        }
    }

    public BoundedRangeModel getProgressModel() {
        return this.progressModel_;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        if (this instanceof Canvas) {
            Dimension dimension = this.getSize();
            if (this.backGfx == null || this.backSize.width != dimension.width || this.backSize.height != dimension.height) {
                if (dimension.width <= 0 || dimension.height <= 0) {
                    return;
                }
                this.backImg = this.createImage(dimension.width, dimension.height);
                this.backGfx = this.backImg.getGraphics();
                this.backSize = dimension;
            }
            this.thumbPos_ = this.computeThumbPos();
            this.progressPos_ = this.computeProgressPos();
            this.paintTrack(this.backGfx, this.progressPos_);
            this.paintThumb(this.backGfx, this.thumbPos_);
            graphics.drawImage(this.backImg, 0, 0, this);
        } else {
            this.thumbPos_ = this.computeThumbPos();
            this.progressPos_ = this.computeProgressPos();
            this.paintTrack(graphics, this.progressPos_);
            this.paintThumb(graphics, this.thumbPos_);
        }
    }

    private void paintTrack(Graphics graphics, int n) {
        Dimension dimension = this.getSize();
        int n2 = dimension.width;
        int n3 = dimension.height;
        Image image = this.progressModel_.getValue() == this.progressModel_.getMinimum() ? trackWestUnloadedImage : trackWestImage;
        graphics.drawImage(image, 0, 0, this);
        int n4 = n2 - trackEastImage.getWidth(this) - trackWestImage.getWidth(this);
        int n5 = Math.min(n4, n - trackWestImage.getWidth(this));
        if (n5 > 0) {
            graphics.drawImage(trackCenterImage, trackWestImage.getWidth(this), 0, n5, trackCenterImage.getHeight(this), this);
        }
        if ((n5 = n4 - n5) > 0) {
            graphics.drawImage(trackCenterUnloadedImage, n2 - trackEastImage.getWidth(this) - n5, 0, n5, trackCenterUnloadedImage.getHeight(this), this);
        }
        image = this.progressModel_.getValue() < this.progressModel_.getMaximum() - this.progressModel_.getExtent() ? trackEastUnloadedImage : trackEastImage;
        graphics.drawImage(image, n2 - image.getWidth(this), 0, this);
    }

    public void paintThumb(Graphics graphics, int n) {
        Dimension dimension = this.getSize();
        int n2 = dimension.width;
        int n3 = dimension.height;
        Image image = this.isPressed && this.isArmed ? thumbPressedImage : thumbImage;
        graphics.drawImage(image, n, 1, this);
    }

    protected int computeProgressPos() {
        BoundedRangeModel boundedRangeModel = this.progressModel_;
        if (boundedRangeModel == null) {
            return 0;
        }
        int n = this.getSize().width - trackEastImage.getWidth(this) - trackWestImage.getWidth(this);
        float f = Math.max(0.0f, (float)boundedRangeModel.getValue() / (float)(boundedRangeModel.getMaximum() - boundedRangeModel.getMinimum()));
        return (int)((float)n * f) + trackWestImage.getWidth(this);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        BoundedRangeModel boundedRangeModel = this.progressModel_;
        if (boundedRangeModel != null && changeEvent.getSource() == boundedRangeModel) {
            if (this.computeProgressPos() != this.progressPos_) {
                this.repaint();
            }
        } else if (this.computeThumbPos() != this.thumbPos_) {
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.isArmed = true;
        this.repaint();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.isArmed = false;
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.model_.setValueIsAdjusting(true);
        this.isPressed = true;
        this.moveThumb(mouseEvent.getX());
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.isPressed = false;
        this.model_.setValueIsAdjusting(false);
        this.moveThumb(mouseEvent.getX());
        this.repaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.moveThumb(mouseEvent.getX());
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

