/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.media.anim;

import ch.randelshofer.gui.image.HAMColorModel;
import ch.randelshofer.iff.IFFChunk;
import ch.randelshofer.iff.IFFParser;
import ch.randelshofer.iff.IFFVisitor;
import ch.randelshofer.iff.MC68000InputStream;
import ch.randelshofer.iff.ParseException;
import ch.randelshofer.media.anim.ANIMAudioCommand;
import ch.randelshofer.media.anim.ANIMDeltaFrame;
import ch.randelshofer.media.anim.ANIMFrame;
import ch.randelshofer.media.anim.ANIMKeyFrame;
import ch.randelshofer.media.anim.ANIMMovieTrack;
import ch.randelshofer.media.eightsvx.EightSVXDecoder;
import ch.randelshofer.util.AbortException;
import ch.randelshofer.util.ArrayUtil;
import java.applet.AudioClip;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;

public class ANIMDecoder
implements IFFVisitor {
    private static final int ILBM_ID = IFFParser.stringToID("ILBM");
    private static final int BMHD_ID = IFFParser.stringToID("BMHD");
    private static final int CMAP_ID = IFFParser.stringToID("CMAP");
    private static final int CAMG_ID = IFFParser.stringToID("CAMG");
    private static final int BODY_ID = IFFParser.stringToID("BODY");
    private static final int ANHD_ID = IFFParser.stringToID("ANHD");
    private static final int DLTA_ID = IFFParser.stringToID("DLTA");
    private static final int ANIM_ID = IFFParser.stringToID("ANIM");
    private static final int COPYRIGHT_ID = IFFParser.stringToID("(c) ");
    private static final int AUTH_ID = IFFParser.stringToID("AUTH");
    private static final int ANNO_ID = IFFParser.stringToID("ANNO");
    private static final int ANFI_ID = IFFParser.stringToID("ANFI");
    private static final int SCTL_ID = IFFParser.stringToID("SCTL");
    protected static final int MONITOR_ID_MASK = -61440;
    protected static final int DEFAULT_MONITOR_ID = 0;
    protected static final int NTSC_MONITOR_ID = 69632;
    protected static final int PAL_MONITOR_ID = 135168;
    protected static final int VGA_MONITOR_ID = 200704;
    protected static final int A2024_MONITOR_ID = 266240;
    protected static final int PROTO_MONITOR_ID = 331776;
    protected static final int EURO72_MONITOR_ID = 397312;
    protected static final int EURO36_MONITOR_ID = 462848;
    protected static final int SUPER72_MONITOR_ID = 528384;
    protected static final int DBLNTSC_MONITOR_ID = 593920;
    protected static final int DBLPAL_MONITOR_ID = 4096;
    protected static final int HAM_MASK = 2048;
    protected static final int EHB_MASK = 128;
    protected static final int HAM_KEY = 2048;
    protected static final int EXTRAHALFBRITE_KEY = 128;
    private InputStream inputStream_;
    private URL location_;
    private Vector sources_;
    private Hashtable properties_;
    private ColorModel cmapColorModel_;
    private ANIMMovieTrack track_;
    private int animCount_;
    private int index_;
    private EightSVXDecoder eightSVXDecoder_;
    private byte[] previousCMAPdata_;
    private boolean isWithinANIMGroup_;

    public ANIMDecoder(InputStream inputStream) {
        this.inputStream_ = inputStream;
    }

    public ANIMDecoder(URL uRL) {
        this.location_ = uRL;
    }

    public void produce(ANIMMovieTrack aNIMMovieTrack, int n, boolean bl) throws IOException {
        InputStream inputStream = null;
        this.track_ = aNIMMovieTrack;
        this.index_ = n;
        this.animCount_ = 0;
        try {
            inputStream = this.inputStream_ != null ? this.inputStream_ : this.location_.openStream();
            IFFParser iFFParser = new IFFParser();
            this.registerChunks(iFFParser, bl);
            if (bl) {
                this.eightSVXDecoder_ = new EightSVXDecoder(){

                    public void addAudioClip(AudioClip audioClip) {
                        super.addAudioClip(audioClip);
                        ANIMDecoder.this.track_.addAudioClip(audioClip);
                    }
                };
                this.eightSVXDecoder_.registerChunks(iFFParser);
            }
            iFFParser.parse(inputStream, this);
        }
        catch (ParseException parseException) {
            throw new IOException(parseException.getMessage());
        }
        catch (AbortException abortException) {
            throw new IOException(abortException.getMessage());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                System.out.println(iOException);
            }
        }
    }

    public void registerChunks(IFFParser iFFParser, boolean bl) {
        iFFParser.declarePropertyChunk(ILBM_ID, BMHD_ID);
        iFFParser.declarePropertyChunk(ILBM_ID, CMAP_ID);
        iFFParser.declarePropertyChunk(ILBM_ID, CAMG_ID);
        iFFParser.declarePropertyChunk(ILBM_ID, ANHD_ID);
        if (bl) {
            iFFParser.declarePropertyChunk(ILBM_ID, ANFI_ID);
            iFFParser.declareCollectionChunk(ILBM_ID, SCTL_ID);
        }
        iFFParser.declareGroupChunk(ANIM_ID, 1179603533);
        iFFParser.declareGroupChunk(ILBM_ID, 1179603533);
        iFFParser.declareDataChunk(ILBM_ID, BODY_ID);
        iFFParser.declareDataChunk(ILBM_ID, DLTA_ID);
        iFFParser.declareCollectionChunk(ILBM_ID, AUTH_ID);
        iFFParser.declareCollectionChunk(ILBM_ID, ANNO_ID);
        iFFParser.declareCollectionChunk(ILBM_ID, COPYRIGHT_ID);
    }

    public void enterGroup(IFFChunk iFFChunk) {
        if (iFFChunk.getType() == ANIM_ID && this.animCount_++ == this.index_) {
            this.isWithinANIMGroup_ = true;
        }
        if (this.isWithinANIMGroup_ && this.eightSVXDecoder_ != null) {
            this.eightSVXDecoder_.enterGroup(iFFChunk);
        }
    }

    public void leaveGroup(IFFChunk iFFChunk) {
        if (this.isWithinANIMGroup_ && this.eightSVXDecoder_ != null) {
            this.eightSVXDecoder_.leaveGroup(iFFChunk);
        }
        if (iFFChunk.getType() == ANIM_ID) {
            this.isWithinANIMGroup_ = false;
        }
    }

    public void visitChunk(IFFChunk iFFChunk, IFFChunk iFFChunk2) throws ParseException, AbortException {
        if (Thread.currentThread().isInterrupted()) {
            throw new AbortException();
        }
        if (this.isWithinANIMGroup_) {
            if (this.eightSVXDecoder_ != null) {
                this.eightSVXDecoder_.visitChunk(iFFChunk, iFFChunk2);
            }
            if (iFFChunk.getType() == ILBM_ID) {
                ColorModel colorModel;
                if (this.track_.getWidth() == 0) {
                    this.decodeBMHD(iFFChunk.getPropertyChunk(BMHD_ID), this.track_);
                    this.decodeCAMG(iFFChunk.getPropertyChunk(CAMG_ID), this.track_);
                    this.decodeAUTH(iFFChunk.getCollectionChunks(AUTH_ID), this.track_);
                    this.decodeANNO(iFFChunk.getCollectionChunks(ANNO_ID), this.track_);
                    this.decodeCOPYRIGHT(iFFChunk.getCollectionChunks(COPYRIGHT_ID), this.track_);
                }
                if ((colorModel = this.decodeCMAP(iFFChunk.getPropertyChunk(CMAP_ID), this.track_)) != null) {
                    this.cmapColorModel_ = colorModel;
                }
                if (iFFChunk2.getID() == BODY_ID) {
                    this.decodeBODY(this.cmapColorModel_, iFFChunk, iFFChunk2, this.track_);
                } else if (iFFChunk2.getID() == DLTA_ID) {
                    this.decodeDLTA(this.cmapColorModel_, iFFChunk, iFFChunk2, this.track_);
                }
            }
        }
    }

    private void decodeBMHD(IFFChunk iFFChunk, ANIMMovieTrack aNIMMovieTrack) throws ParseException {
        try {
            MC68000InputStream mC68000InputStream = new MC68000InputStream(new ByteArrayInputStream(iFFChunk.getData()));
            aNIMMovieTrack.setWidth(mC68000InputStream.readUWORD());
            aNIMMovieTrack.setHeight(mC68000InputStream.readUWORD());
            aNIMMovieTrack.setXPosition(mC68000InputStream.readWORD());
            aNIMMovieTrack.setYPosition(mC68000InputStream.readWORD());
            aNIMMovieTrack.setNbPlanes(mC68000InputStream.readUBYTE());
            aNIMMovieTrack.setMasking(mC68000InputStream.readUBYTE());
            aNIMMovieTrack.setCompression(mC68000InputStream.readUBYTE());
            mC68000InputStream.skip(1L);
            aNIMMovieTrack.setTransparentColor(mC68000InputStream.readUWORD());
            aNIMMovieTrack.setXAspect(mC68000InputStream.readUBYTE());
            aNIMMovieTrack.setYAspect(mC68000InputStream.readUBYTE());
            aNIMMovieTrack.setPageWidth(mC68000InputStream.readWORD());
            aNIMMovieTrack.setPageHeight(mC68000InputStream.readWORD());
            mC68000InputStream.close();
        }
        catch (IOException iOException) {
            throw new ParseException(iOException.toString());
        }
    }

    private void decodeCAMG(IFFChunk iFFChunk, ANIMMovieTrack aNIMMovieTrack) throws ParseException {
        int n;
        int n2 = 0;
        if (iFFChunk != null) {
            try {
                MC68000InputStream mC68000InputStream = new MC68000InputStream(new ByteArrayInputStream(iFFChunk.getData()));
                n2 = mC68000InputStream.readLONG();
                mC68000InputStream.close();
            }
            catch (IOException iOException) {
                throw new ParseException(iOException.toString());
            }
        }
        switch (n2 & 0x880) {
            case 128: {
                aNIMMovieTrack.setScreenMode(2);
                break;
            }
            case 2048: {
                if (aNIMMovieTrack.getNbPlanes() == 6) {
                    aNIMMovieTrack.setScreenMode(3);
                    break;
                }
                if (aNIMMovieTrack.getNbPlanes() == 8) {
                    aNIMMovieTrack.setScreenMode(4);
                    break;
                }
                throw new ParseException("unsupported Ham Mode with " + aNIMMovieTrack.getNbPlanes() + " bitplanes");
            }
            default: {
                if (aNIMMovieTrack.getNbPlanes() <= 8) {
                    aNIMMovieTrack.setScreenMode(0);
                    break;
                }
                aNIMMovieTrack.setScreenMode(1);
            }
        }
        switch (n2 & 0xFFFF1000) {
            case 0: {
                n = 60;
                break;
            }
            case 69632: {
                n = 60;
                break;
            }
            case 135168: {
                n = 50;
                break;
            }
            case 200704: {
                n = 58;
                break;
            }
            case 266240: {
                n = 60;
                break;
            }
            case 331776: {
                n = 60;
                break;
            }
            case 397312: {
                n = 69;
                break;
            }
            case 462848: {
                n = 73;
                break;
            }
            case 593920: {
                n = 58;
                break;
            }
            case 4096: {
                n = 48;
                break;
            }
            case 528384: {
                n = 71;
                break;
            }
            default: {
                n = 60;
            }
        }
        aNIMMovieTrack.setJiffies(n);
    }

    private ColorModel decodeCMAP(IFFChunk iFFChunk, ANIMMovieTrack aNIMMovieTrack) throws ParseException {
        int n;
        int n2 = 0;
        int n3 = 0;
        if (iFFChunk == null) {
            return null;
        }
        byte[] byArray = iFFChunk.getData();
        if (this.previousCMAPdata_ != null && ArrayUtil.equals(byArray, this.previousCMAPdata_)) {
            return null;
        }
        this.previousCMAPdata_ = byArray;
        switch (aNIMMovieTrack.getScreenMode()) {
            case 2: {
                n2 = 64;
                n3 = Math.min(32, (int)iFFChunk.getSize() / 3);
                break;
            }
            case 3: 
            case 4: {
                n2 = 1 << aNIMMovieTrack.getNbPlanes() - 2;
                n3 = Math.min(n2, (int)iFFChunk.getSize() / 3);
                break;
            }
            case 0: {
                n2 = 1 << aNIMMovieTrack.getNbPlanes();
                n3 = Math.min(n2, (int)iFFChunk.getSize() / 3);
                break;
            }
            case 1: {
                return new DirectColorModel(24, 0xFF0000, 65280, 255);
            }
        }
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = new byte[n2];
        byte[] byArray4 = new byte[n2];
        byte[] byArray5 = iFFChunk.getData();
        int n4 = 0;
        for (n = 0; n < n3; ++n) {
            byArray2[n] = byArray5[n4++];
            byArray3[n] = byArray5[n4++];
            byArray4[n] = byArray5[n4++];
        }
        switch (aNIMMovieTrack.getScreenMode()) {
            case 2: {
                n4 = 32;
                n = 0;
                while (n < 32) {
                    byArray2[n4] = (byte)((byArray2[n] & 0xFF) / 2);
                    byArray3[n4] = (byte)((byArray3[n] & 0xFF) / 2);
                    byArray4[n4] = (byte)((byArray4[n] & 0xFF) / 2);
                    ++n;
                    ++n4;
                }
                return new IndexColorModel(8, 64, byArray2, byArray3, byArray4, -1);
            }
            case 3: {
                return new HAMColorModel(6, 16, byArray2, byArray3, byArray4);
            }
            case 4: {
                return new HAMColorModel(8, 64, byArray2, byArray3, byArray4);
            }
            case 0: {
                return new IndexColorModel(8, Math.min(byArray2.length, (int)iFFChunk.getSize() / 3), byArray2, byArray3, byArray4, -1);
            }
        }
        throw new ParseException("ScreenMode not supported:" + aNIMMovieTrack.getScreenMode());
    }

    private void decodeBODY(ColorModel colorModel, IFFChunk iFFChunk, IFFChunk iFFChunk2, ANIMMovieTrack aNIMMovieTrack) throws ParseException {
        ANIMKeyFrame aNIMKeyFrame = new ANIMKeyFrame();
        aNIMKeyFrame.setColorModel(colorModel);
        this.decodeANHD(iFFChunk.getPropertyChunk(ANHD_ID), aNIMKeyFrame);
        if (iFFChunk.getPropertyChunk(ANFI_ID) != null) {
            this.decodeANFI(iFFChunk.getPropertyChunk(ANFI_ID), aNIMKeyFrame, aNIMMovieTrack);
        }
        IFFChunk[] iFFChunkArray = iFFChunk.getCollectionChunks(SCTL_ID);
        for (int i = 0; i < iFFChunkArray.length; ++i) {
            this.decodeSCTL(iFFChunkArray[i], aNIMKeyFrame, aNIMMovieTrack);
        }
        aNIMKeyFrame.cleanUpAudioCommands();
        aNIMKeyFrame.setData(iFFChunk2.getData());
        aNIMKeyFrame.setCompressed(aNIMMovieTrack.getCompression() == 1);
        aNIMMovieTrack.addFrame(aNIMKeyFrame);
    }

    private void decodeDLTA(ColorModel colorModel, IFFChunk iFFChunk, IFFChunk iFFChunk2, ANIMMovieTrack aNIMMovieTrack) throws ParseException {
        ANIMDeltaFrame aNIMDeltaFrame = new ANIMDeltaFrame();
        aNIMDeltaFrame.setColorModel(colorModel);
        this.decodeANHD(iFFChunk.getPropertyChunk(ANHD_ID), aNIMDeltaFrame);
        if (iFFChunk.getPropertyChunk(ANFI_ID) != null) {
            this.decodeANFI(iFFChunk.getPropertyChunk(ANFI_ID), aNIMDeltaFrame, aNIMMovieTrack);
        }
        IFFChunk[] iFFChunkArray = iFFChunk.getCollectionChunks(SCTL_ID);
        for (int i = 0; i < iFFChunkArray.length; ++i) {
            this.decodeSCTL(iFFChunkArray[i], aNIMDeltaFrame, aNIMMovieTrack);
        }
        aNIMDeltaFrame.cleanUpAudioCommands();
        aNIMDeltaFrame.setData(iFFChunk2.getData());
        aNIMMovieTrack.addFrame(aNIMDeltaFrame);
    }

    private void decodeANHD(IFFChunk iFFChunk, ANIMFrame aNIMFrame) throws ParseException {
        if (iFFChunk != null) {
            try {
                MC68000InputStream mC68000InputStream = new MC68000InputStream(new ByteArrayInputStream(iFFChunk.getData()));
                aNIMFrame.setOperation(mC68000InputStream.readUBYTE());
                aNIMFrame.setMask(mC68000InputStream.readUBYTE());
                aNIMFrame.setWidth(mC68000InputStream.readUWORD());
                aNIMFrame.setHeight(mC68000InputStream.readUWORD());
                aNIMFrame.setY(mC68000InputStream.readWORD());
                aNIMFrame.setX(mC68000InputStream.readWORD());
                aNIMFrame.setAbsTime(mC68000InputStream.readULONG());
                aNIMFrame.setRelTime(mC68000InputStream.readULONG());
                aNIMFrame.setInterleave(mC68000InputStream.readUBYTE());
                mC68000InputStream.skip(1L);
                aNIMFrame.setBits((int)mC68000InputStream.readULONG());
                mC68000InputStream.close();
            }
            catch (IOException iOException) {
                throw new ParseException(iOException.toString());
            }
        }
    }

    private void decodeANFI(IFFChunk iFFChunk, ANIMFrame aNIMFrame, ANIMMovieTrack aNIMMovieTrack) throws ParseException {
        try {
            MC68000InputStream mC68000InputStream = new MC68000InputStream(new ByteArrayInputStream(iFFChunk.getData()));
            for (int i = 0; i < 4; ++i) {
                int n = mC68000InputStream.readUWORD();
                int n2 = mC68000InputStream.readUWORD();
                int n3 = mC68000InputStream.readUBYTE();
                int n4 = mC68000InputStream.readUBYTE();
                int n5 = mC68000InputStream.readUBYTE();
                n5 = n5 > 2 ? --n5 : 1;
                int n6 = mC68000InputStream.readUBYTE();
                if (n == 0) continue;
                ANIMAudioCommand aNIMAudioCommand = new ANIMAudioCommand(1, n6 - 1, n3, n5, 1 << n4, 0, 0);
                aNIMFrame.addAudioCommand(aNIMAudioCommand);
                aNIMAudioCommand.prepare(aNIMMovieTrack);
            }
            mC68000InputStream.close();
        }
        catch (IOException iOException) {
            throw new ParseException(iOException.toString());
        }
    }

    private void decodeSCTL(IFFChunk iFFChunk, ANIMFrame aNIMFrame, ANIMMovieTrack aNIMMovieTrack) throws ParseException {
        try {
            MC68000InputStream mC68000InputStream = new MC68000InputStream(new ByteArrayInputStream(iFFChunk.getData()));
            int n = mC68000InputStream.readUBYTE();
            int n2 = mC68000InputStream.readUBYTE();
            int n3 = mC68000InputStream.readUWORD();
            int n4 = mC68000InputStream.readUWORD();
            int n5 = mC68000InputStream.readUWORD();
            int n6 = mC68000InputStream.readUWORD();
            int n7 = mC68000InputStream.readUWORD();
            mC68000InputStream.close();
            ANIMAudioCommand aNIMAudioCommand = new ANIMAudioCommand(n, n2, n3, n4, n5, n6, n7);
            aNIMFrame.addAudioCommand(aNIMAudioCommand);
            aNIMAudioCommand.prepare(aNIMMovieTrack);
        }
        catch (IOException iOException) {
            throw new ParseException(iOException.toString());
        }
    }

    protected void decodeCOPYRIGHT(IFFChunk[] iFFChunkArray, ANIMMovieTrack aNIMMovieTrack) throws ParseException {
        for (int i = 0; i < iFFChunkArray.length; ++i) {
            String string = new String(iFFChunkArray[i].getData());
            this.appendProperty("copyright", string);
            this.appendProperty("comment", "\ufffd " + string);
        }
    }

    protected void decodeAUTH(IFFChunk[] iFFChunkArray, ANIMMovieTrack aNIMMovieTrack) throws ParseException {
        for (int i = 0; i < iFFChunkArray.length; ++i) {
            String string = new String(iFFChunkArray[i].getData());
            this.appendProperty("author", string);
            this.appendProperty("comment", "Author " + string);
        }
    }

    protected void decodeANNO(IFFChunk[] iFFChunkArray, ANIMMovieTrack aNIMMovieTrack) throws ParseException {
        for (int i = 0; i < iFFChunkArray.length; ++i) {
            String string = new String(iFFChunkArray[i].getData());
            this.appendProperty("annotation", string);
            this.appendProperty("comment", string);
        }
    }

    private void appendProperty(String string, String string2) {
        String string3 = (String)this.track_.getProperty(string);
        if (string3 == null) {
            this.track_.setProperty(string, string2);
        } else {
            this.track_.setProperty(string, string3 + "\n" + string2);
        }
    }
}

