/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.media.anim;

import ch.randelshofer.gui.image.Bitmap;
import ch.randelshofer.media.anim.ANIMFrame;
import ch.randelshofer.media.anim.ANIMMovieTrack;

public class ANIMDeltaFrame
extends ANIMFrame {
    private int leftBound;
    private int topBound;
    private int rightBound;
    private int bottomBound;
    private static final int DECODER_BYTE_VERTICAL = 5;
    private static final int DECODER_VERTICAL_7_SHORT = 6;
    private static final int DECODER_VERTICAL_7_LONG = 7;
    private static final int DECODER_VERTICAL_8_SHORT = 8;
    private static final int DECODER_VERTICAL_8_LONG = 9;
    private static final int DECODER_J = 74;
    public static final int OP_Direct = 0;
    public static final int OP_XOR = 1;
    public static final int OP_LongDelta = 2;
    public static final int OP_ShortDelta = 3;
    public static final int OP_GeneralDelta = 4;
    public static final int OP_ByteVertical = 5;
    public static final int OP_StereoDelta = 6;
    public static final int OP_Vertical7 = 7;
    public static final int OP_Vertical8 = 8;
    public static final int OP_J = 74;

    private int getDecoder() {
        switch (this.getOperation()) {
            case 0: {
                throw new InternalError("Key Frames not yet supported (Anim Op0)");
            }
            case 5: {
                if ((this.getBits() & 0xFFF7) != 0) {
                    throw new InternalError("Unknown Bits for Anim Op5 in ANHD; Bits:" + this.getBits());
                }
                return 5;
            }
            case 7: {
                if ((this.getBits() & 1) == 0) {
                    return 6;
                }
                return 7;
            }
            case 8: {
                if ((this.getBits() & 1) == 0) {
                    return 8;
                }
                return 9;
            }
            case 74: {
                return 74;
            }
        }
        throw new InternalError("ANIM Op" + this.getOperation() + " not supported.");
    }

    public void decode(Bitmap bitmap, ANIMMovieTrack aNIMMovieTrack) {
        switch (this.getDecoder()) {
            case 5: {
                this.decodeByteVertical(bitmap, aNIMMovieTrack);
                break;
            }
            case 6: {
                this.decodeVertical7Short(bitmap, aNIMMovieTrack);
                break;
            }
            case 7: {
                this.decodeVertical7Long(bitmap, aNIMMovieTrack);
                break;
            }
            case 8: {
                this.decodeVertical8Short(bitmap, aNIMMovieTrack);
                break;
            }
            case 9: {
                this.decodeVertical8Long(bitmap, aNIMMovieTrack);
                break;
            }
            case 74: {
                this.decodeJ(bitmap, aNIMMovieTrack);
                break;
            }
            default: {
                throw new InternalError("Unsupported decoder." + this.getDecoder());
            }
        }
    }

    private void decodeByteVertical(Bitmap bitmap, ANIMMovieTrack aNIMMovieTrack) {
        int n = 0;
        int n2 = 0;
        byte[] byArray = bitmap.getBitmap();
        int n3 = 0;
        int n4 = bitmap.getBitplaneStride();
        int n5 = aNIMMovieTrack.getNbPlanes() * n4;
        int n6 = 0;
        int n7 = 0;
        byte by = 0;
        this.leftBound = n4;
        this.rightBound = 0;
        this.topBound = aNIMMovieTrack.getHeight();
        this.bottomBound = 0;
        int n8 = aNIMMovieTrack.getHeight();
        for (int i = 0; i < aNIMMovieTrack.getNbPlanes(); ++i) {
            n2 = ((this.data[i * 4] & 0xFF) << 24) + ((this.data[i * 4 + 1] & 0xFF) << 16) + ((this.data[i * 4 + 2] & 0xFF) << 8) + (this.data[i * 4 + 3] & 0xFF);
            if (n2 <= 0) continue;
            for (n = 0; n < n4; ++n) {
                n3 = n + i * n4;
                if ((n7 = this.data[n2++] & 0xFF) <= 0) continue;
                if (n < this.leftBound) {
                    this.leftBound = n;
                }
                if (n > this.rightBound) {
                    this.rightBound = n;
                }
                if ((n6 = this.data[n2]) <= 0) {
                    this.topBound = 0;
                } else if (n6 < this.topBound) {
                    this.topBound = n6;
                }
                while (n7 > 0) {
                    if ((n6 = this.data[n2++]) > 0) {
                        n3 += n6 * n5;
                    } else if (n6 < 0) {
                        n6 &= 0x7F;
                        while (n6-- > 0) {
                            byArray[n3] = this.data[n2++];
                            n3 += n5;
                        }
                    } else {
                        if ((n6 = this.data[n2++] & 0xFF) == 0) {
                            return;
                        }
                        by = this.data[n2++];
                        while (n6-- > 0) {
                            byArray[n3] = by;
                            n3 += n5;
                        }
                    }
                    --n7;
                }
                if (n6 <= 0) {
                    int n9 = (n3 - (n + i * n4)) / n5;
                    if (n9 <= this.bottomBound) continue;
                    this.bottomBound = n9;
                    continue;
                }
                if (n8 - n6 <= this.bottomBound) continue;
                this.bottomBound = n8 - n6;
            }
        }
        if (this.leftBound <= this.rightBound) {
            this.leftBound *= 8;
            this.rightBound = this.rightBound * 8 + 8;
        }
    }

    protected void decodeVertical8Short(Bitmap bitmap, ANIMMovieTrack aNIMMovieTrack) {
        int n = 0;
        int n2 = 0;
        byte[] byArray = bitmap.getBitmap();
        int n3 = 0;
        int n4 = bitmap.getBitplaneStride();
        int n5 = aNIMMovieTrack.getNbPlanes() * n4;
        int n6 = 0;
        int n7 = 0;
        byte by = 0;
        byte by2 = 0;
        this.leftBound = n4;
        this.rightBound = 0;
        this.topBound = aNIMMovieTrack.getHeight() - 1;
        this.bottomBound = 0;
        int n8 = aNIMMovieTrack.getHeight() - 1;
        for (int i = 0; i < aNIMMovieTrack.getNbPlanes(); ++i) {
            n2 = ((this.data[i * 4] & 0xFF) << 24) + ((this.data[i * 4 + 1] & 0xFF) << 16) + ((this.data[i * 4 + 2] & 0xFF) << 8) + (this.data[i * 4 + 3] & 0xFF);
            if (n2 <= 0) continue;
            for (n = 0; n < n4; n += 2) {
                n3 = n + i * n4;
                if ((n7 = (this.data[n2++] & 0xFF) << 8 | this.data[n2++] & 0xFF) <= 0) continue;
                if (n < this.leftBound) {
                    this.leftBound = n;
                }
                if (n > this.rightBound) {
                    this.rightBound = n;
                }
                if ((n6 = this.data[n2] << 8 | this.data[n2 + 1] & 0xFF) <= 0) {
                    this.topBound = 0;
                } else if (n6 < this.topBound) {
                    this.topBound = n6;
                }
                while (n7 > 0) {
                    if ((n6 = this.data[n2++] << 8 | this.data[n2++] & 0xFF) > 0) {
                        n3 += n6 * n5;
                    } else if (n6 < 0) {
                        n6 &= Short.MAX_VALUE;
                        while (n6-- > 0) {
                            byArray[n3] = this.data[n2++];
                            byArray[n3 + 1] = this.data[n2++];
                            n3 += n5;
                        }
                    } else {
                        if ((n6 = (this.data[n2++] << 8 | this.data[n2++] & 0xFF) & 0xFFFF) == 0) {
                            return;
                        }
                        by = this.data[n2++];
                        by2 = this.data[n2++];
                        while (n6-- > 0) {
                            byArray[n3] = by;
                            byArray[n3 + 1] = by2;
                            n3 += n5;
                        }
                    }
                    --n7;
                }
                if (n6 <= 0) {
                    int n9 = (n3 - (n + i * n4)) / n5;
                    if (n9 <= this.bottomBound) continue;
                    this.bottomBound = n9;
                    continue;
                }
                if (n8 - n6 <= this.bottomBound) continue;
                this.bottomBound = n8 - n6;
            }
        }
        if (this.leftBound <= this.rightBound) {
            this.leftBound *= 8;
            this.rightBound = this.rightBound * 8 + 16;
        }
    }

    protected void decodeVertical8Long(Bitmap bitmap, ANIMMovieTrack aNIMMovieTrack) {
        int n = 0;
        int n2 = 0;
        byte[] byArray = bitmap.getBitmap();
        int n3 = 0;
        int n4 = bitmap.getBitplaneStride();
        int n5 = aNIMMovieTrack.getNbPlanes() * n4;
        int n6 = 0;
        int n7 = 0;
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        this.leftBound = n4;
        this.rightBound = 0;
        this.topBound = aNIMMovieTrack.getHeight() - 1;
        this.bottomBound = 0;
        int n8 = aNIMMovieTrack.getHeight() - 1;
        for (int i = 0; i < aNIMMovieTrack.getNbPlanes(); ++i) {
            n2 = ((this.data[i * 4] & 0xFF) << 24) + ((this.data[i * 4 + 1] & 0xFF) << 16) + ((this.data[i * 4 + 2] & 0xFF) << 8) + (this.data[i * 4 + 3] & 0xFF);
            if (n2 <= 0) continue;
            for (n = 0; n < n4; n += 4) {
                n3 = n + i * n4;
                if ((n7 = ((this.data[n2++] & 0xFF) << 24) + ((this.data[n2++] & 0xFF) << 16) + ((this.data[n2++] & 0xFF) << 8) + (this.data[n2++] & 0xFF)) <= 0) continue;
                if (n < this.leftBound) {
                    this.leftBound = n;
                }
                if (n > this.rightBound) {
                    this.rightBound = n;
                }
                if ((n6 = ((this.data[n2] & 0xFF) << 24) + ((this.data[n2 + 1] & 0xFF) << 16) + ((this.data[n2 + 2] & 0xFF) << 8) + (this.data[n2 + 3] & 0xFF)) <= 0) {
                    this.topBound = 0;
                } else if (n6 < this.topBound) {
                    this.topBound = n6;
                }
                while (n7 > 0) {
                    if ((n6 = ((this.data[n2++] & 0xFF) << 24) + ((this.data[n2++] & 0xFF) << 16) + ((this.data[n2++] & 0xFF) << 8) + (this.data[n2++] & 0xFF)) > 0) {
                        n3 += n6 * n5;
                    } else if (n6 < 0) {
                        n6 &= Integer.MAX_VALUE;
                        while (n6-- > 0) {
                            byArray[n3] = this.data[n2++];
                            byArray[n3 + 1] = this.data[n2++];
                            byArray[n3 + 2] = this.data[n2++];
                            byArray[n3 + 3] = this.data[n2++];
                            n3 += n5;
                        }
                    } else {
                        if ((n6 = ((this.data[n2++] & 0xFF) << 24) + ((this.data[n2++] & 0xFF) << 16) + ((this.data[n2++] & 0xFF) << 8) + (this.data[n2++] & 0xFF)) == 0) {
                            return;
                        }
                        by = this.data[n2++];
                        by2 = this.data[n2++];
                        by3 = this.data[n2++];
                        by4 = this.data[n2++];
                        while (n6-- > 0) {
                            byArray[n3] = by;
                            byArray[n3 + 1] = by2;
                            byArray[n3 + 2] = by3;
                            byArray[n3 + 3] = by4;
                            n3 += n5;
                        }
                    }
                    --n7;
                }
                if (n6 <= 0) {
                    int n9 = (n3 - (n + i * n4)) / n5;
                    if (n9 <= this.bottomBound) continue;
                    this.bottomBound = n9;
                    continue;
                }
                if (n8 - n6 <= this.bottomBound) continue;
                this.bottomBound = n8 - n6;
            }
        }
        if (this.leftBound <= this.rightBound) {
            this.leftBound *= 8;
            this.rightBound = this.rightBound * 8 + 32;
        }
    }

    protected void decodeVertical7Short(Bitmap bitmap, ANIMMovieTrack aNIMMovieTrack) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        byte[] byArray = bitmap.getBitmap();
        int n4 = 0;
        int n5 = bitmap.getBitplaneStride();
        int n6 = bitmap.getScanlineStride();
        int n7 = 0;
        int n8 = 0;
        byte by = 0;
        byte by2 = 0;
        this.leftBound = n5;
        this.rightBound = 0;
        this.topBound = aNIMMovieTrack.getHeight() - 1;
        this.bottomBound = 0;
        int n9 = aNIMMovieTrack.getHeight() - 1;
        for (int i = 0; i < aNIMMovieTrack.getNbPlanes(); ++i) {
            n2 = ((this.data[i * 4] & 0xFF) << 24) + ((this.data[i * 4 + 1] & 0xFF) << 16) + ((this.data[i * 4 + 2] & 0xFF) << 8) + (this.data[i * 4 + 3] & 0xFF);
            n3 = ((this.data[i * 4 + 32] & 0xFF) << 24) + ((this.data[i * 4 + 33] & 0xFF) << 16) + ((this.data[i * 4 + 34] & 0xFF) << 8) + (this.data[i * 4 + 35] & 0xFF);
            if (n2 <= 0) continue;
            for (n = 0; n < n5; n += 2) {
                n4 = n + i * n5;
                if ((n8 = this.data[n2++] & 0xFF) <= 0) continue;
                if (n < this.leftBound) {
                    this.leftBound = n;
                }
                if (n > this.rightBound) {
                    this.rightBound = n;
                }
                if ((n7 = this.data[n2]) <= 0) {
                    this.topBound = 0;
                } else if (n7 < this.topBound) {
                    this.topBound = n7;
                }
                while (n8 > 0) {
                    if ((n7 = this.data[n2++]) > 0) {
                        n4 += n7 * n6;
                    } else if (n7 < 0) {
                        n7 &= 0x7F;
                        while (n7-- > 0) {
                            byArray[n4] = this.data[n3++];
                            byArray[n4 + 1] = this.data[n3++];
                            n4 += n6;
                        }
                    } else {
                        if ((n7 = this.data[n2++] & 0xFF) == 0) {
                            return;
                        }
                        by = this.data[n3++];
                        by2 = this.data[n3++];
                        while (n7-- > 0) {
                            byArray[n4] = by;
                            byArray[n4 + 1] = by2;
                            n4 += n6;
                        }
                    }
                    --n8;
                }
                if (n7 <= 0) {
                    int n10 = (n4 - (n + i * n5)) / n6;
                    if (n10 <= this.bottomBound) continue;
                    this.bottomBound = n10;
                    continue;
                }
                if (n9 - n7 <= this.bottomBound) continue;
                this.bottomBound = n9 - n7;
            }
        }
        if (this.leftBound <= this.rightBound) {
            this.leftBound *= 8;
            this.rightBound = this.rightBound * 8 + 32;
        }
    }

    protected void decodeVertical7Long(Bitmap bitmap, ANIMMovieTrack aNIMMovieTrack) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        byte[] byArray = bitmap.getBitmap();
        int n4 = 0;
        int n5 = bitmap.getBitplaneStride();
        int n6 = aNIMMovieTrack.getNbPlanes() * n5;
        int n7 = 0;
        int n8 = 0;
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        this.leftBound = n5;
        this.rightBound = 0;
        this.topBound = aNIMMovieTrack.getHeight() - 1;
        this.bottomBound = 0;
        int n9 = aNIMMovieTrack.getHeight() - 1;
        for (int i = 0; i < aNIMMovieTrack.getNbPlanes(); ++i) {
            n2 = ((this.data[i * 4] & 0xFF) << 24) + ((this.data[i * 4 + 1] & 0xFF) << 16) + ((this.data[i * 4 + 2] & 0xFF) << 8) + (this.data[i * 4 + 3] & 0xFF);
            n3 = ((this.data[i * 4 + 32] & 0xFF) << 24) + ((this.data[i * 4 + 33] & 0xFF) << 16) + ((this.data[i * 4 + 34] & 0xFF) << 8) + (this.data[i * 4 + 35] & 0xFF);
            if (n2 <= 0) continue;
            for (n = 0; n < n5; n += 4) {
                n4 = n + i * n5;
                if ((n8 = this.data[n2++] & 0xFF) <= 0) continue;
                if (n < this.leftBound) {
                    this.leftBound = n;
                }
                if (n > this.rightBound) {
                    this.rightBound = n;
                }
                if ((n7 = this.data[n2]) <= 0) {
                    this.topBound = 0;
                } else if (n7 < this.topBound) {
                    this.topBound = n7;
                }
                while (n8 > 0) {
                    if ((n7 = this.data[n2++]) > 0) {
                        n4 += n7 * n6;
                    } else if (n7 < 0) {
                        n7 &= 0x7F;
                        while (n7-- > 0) {
                            byArray[n4] = this.data[n3++];
                            byArray[n4 + 1] = this.data[n3++];
                            byArray[n4 + 2] = this.data[n3++];
                            byArray[n4 + 3] = this.data[n3++];
                            n4 += n6;
                        }
                    } else {
                        if ((n7 = this.data[n2++] & 0xFF) == 0) {
                            return;
                        }
                        by = this.data[n3++];
                        by2 = this.data[n3++];
                        by3 = this.data[n3++];
                        by4 = this.data[n3++];
                        while (n7-- > 0) {
                            byArray[n4] = by;
                            byArray[n4 + 1] = by2;
                            byArray[n4 + 2] = by3;
                            byArray[n4 + 3] = by4;
                            n4 += n6;
                        }
                    }
                    --n8;
                }
                if (n7 <= 0) {
                    int n10 = (n4 - (n + i * n5)) / n6;
                    if (n10 <= this.bottomBound) continue;
                    this.bottomBound = n10;
                    continue;
                }
                if (n9 - n7 <= this.bottomBound) continue;
                this.bottomBound = n9 - n7;
            }
        }
        if (this.leftBound <= this.rightBound) {
            this.leftBound *= 8;
            this.rightBound = this.rightBound * 8 + 64;
        }
    }

    protected void decodeJ(Bitmap bitmap, ANIMMovieTrack aNIMMovieTrack) {
        int n = aNIMMovieTrack.getNbPlanes();
        int n2 = bitmap.getBitplaneStride();
        this.leftBound = aNIMMovieTrack.getWidth() - 1;
        this.rightBound = 0;
        this.topBound = aNIMMovieTrack.getHeight() - 1;
        this.bottomBound = 0;
        int n3 = 0;
        byte[] byArray = bitmap.getBitmap();
        block5: while (n3 < this.data.length) {
            int n4 = (this.data[n3++] & 0xFF) << 8 | this.data[n3++] & 0xFF;
            switch (n4) {
                case 0: {
                    break block5;
                }
                case 1: {
                    int n5;
                    int n6;
                    int n7;
                    int n8;
                    int n9;
                    int n10;
                    int n11;
                    int n12 = (this.data[n3++] & 0xFF) << 8 | this.data[n3++] & 0xFF;
                    int n13 = (this.data[n3++] & 0xFF) << 8 | this.data[n3++] & 0xFF;
                    int n14 = (this.data[n3++] & 0xFF) << 8 | this.data[n3++] & 0xFF;
                    for (n11 = 0; n11 < n14; ++n11) {
                        n10 = (this.data[n3++] & 0xFF) << 8 | this.data[n3++] & 0xFF;
                        this.leftBound = Math.min(this.leftBound, n10 % n2 * 8);
                        this.rightBound = Math.max(this.rightBound, n10 % n2 * 8 + 8);
                        this.topBound = Math.min(this.topBound, n10 / n2);
                        this.bottomBound = Math.max(this.bottomBound, n10 / n2 + n13);
                        n9 = n10 / n2 * n;
                        n9 *= n2;
                        n9 += n10 % n2;
                        for (n8 = 0; n8 < n; ++n8) {
                            for (n7 = 0; n7 < n13; ++n7) {
                                n6 = this.data[n3++];
                                n5 = n8 * n2 * n13 + n7 * n2 + n9;
                                if (n12 == 1) {
                                    int n15 = n5;
                                    byArray[n15] = (byte)(byArray[n15] ^ n6);
                                    continue;
                                }
                                byArray[n5] = n6;
                            }
                        }
                        if (n3 % 2 != 1) continue;
                        ++n3;
                    }
                    continue block5;
                }
                case 2: {
                    int n5;
                    int n6;
                    int n7;
                    int n8;
                    int n9;
                    int n10;
                    int n12 = (this.data[n3++] & 0xFF) << 8 | this.data[n3++] & 0xFF;
                    int n13 = (this.data[n3++] & 0xFF) << 8 | this.data[n3++] & 0xFF;
                    int n14 = (this.data[n3++] & 0xFF) << 8 | this.data[n3++] & 0xFF;
                    int n11 = (this.data[n3++] & 0xFF) << 8 | this.data[n3++] & 0xFF;
                    for (n10 = 0; n10 < n11; ++n10) {
                        n9 = (this.data[n3++] & 0xFF) << 8 | this.data[n3++] & 0xFF;
                        this.leftBound = Math.min(this.leftBound, n9 % n2 * 8);
                        this.rightBound = Math.max(this.rightBound, (n9 % n2 + n14) * 8 + 8);
                        this.topBound = Math.min(this.topBound, n9 / n2);
                        this.bottomBound = Math.max(this.bottomBound, n9 / n2 + n13);
                        n8 = n9 / n2 * n;
                        n8 *= n2;
                        n8 += n9 % n2;
                        for (n7 = 0; n7 < n; ++n7) {
                            for (n6 = 0; n6 < n13; ++n6) {
                                for (n5 = 0; n5 < n14; ++n5) {
                                    byte by = this.data[n3++];
                                    int n16 = n7 * n2 * n13 + n6 * n2 + n8 + n5;
                                    if (n12 == 1) {
                                        int n17 = n16;
                                        byArray[n17] = (byte)(byArray[n17] ^ by);
                                        continue;
                                    }
                                    if (n12 != 0) continue;
                                    byArray[n16] = by;
                                }
                            }
                        }
                        if (n3 % 2 != 1) continue;
                        ++n3;
                    }
                    continue block5;
                }
                default: {
                    System.out.println("Unsupported changeType in 'J' delta frame:" + n4);
                    break block5;
                }
            }
        }
    }

    public int getTopBound(ANIMMovieTrack aNIMMovieTrack) {
        return this.topBound;
    }

    public int getBottomBound(ANIMMovieTrack aNIMMovieTrack) {
        return this.bottomBound;
    }

    public int getLeftBound(ANIMMovieTrack aNIMMovieTrack) {
        return this.leftBound;
    }

    public int getRightBound(ANIMMovieTrack aNIMMovieTrack) {
        return this.rightBound;
    }
}

