/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.media.anim;

import ch.randelshofer.gui.image.Bitmap;
import ch.randelshofer.media.anim.ANIMAudioCommand;
import ch.randelshofer.media.anim.ANIMMovieTrack;
import java.awt.image.ColorModel;
import java.util.Vector;

public abstract class ANIMFrame {
    protected ColorModel colorModel;
    protected byte[] data;
    private int operation;
    private int mask;
    private long reltime;
    private int interleave;
    private int bits;
    protected static final int BadBitsOP_GeneralDelta = 65472;
    protected static final int BIT_LongData = 1;
    protected static final int BIT_XOR = 2;
    protected static final int BIT_OneInfoListForAllPlanes = 4;
    protected static final int BIT_RLC = 8;
    protected static final int BIT_Vertical = 16;
    protected static final int BIT_LongInfoOffsets = 32;
    protected static final int BadBitsOP_ByteVertical = 65527;
    private ANIMAudioCommand[] audioCommands;

    public void addAudioCommand(ANIMAudioCommand aNIMAudioCommand) {
        if (this.audioCommands == null) {
            this.audioCommands = new ANIMAudioCommand[1];
        } else {
            ANIMAudioCommand[] aNIMAudioCommandArray = this.audioCommands;
            this.audioCommands = new ANIMAudioCommand[aNIMAudioCommandArray.length + 1];
            System.arraycopy(aNIMAudioCommandArray, 0, this.audioCommands, 0, aNIMAudioCommandArray.length);
        }
        this.audioCommands[this.audioCommands.length - 1] = aNIMAudioCommand;
    }

    public ANIMAudioCommand[] getAudioCommands() {
        return this.audioCommands;
    }

    public void cleanUpAudioCommands() {
        if (this.audioCommands != null && this.audioCommands.length > 1) {
            Vector<ANIMAudioCommand> vector = new Vector<ANIMAudioCommand>();
            vector.addElement(this.audioCommands[0]);
            for (int i = 1; i < this.audioCommands.length; ++i) {
                int n;
                for (n = 0; n < i && (this.audioCommands[n].getChannelMask() & this.audioCommands[i].getChannelMask()) == 0; ++n) {
                }
                if (n != i) continue;
                vector.addElement(this.audioCommands[i]);
            }
            this.audioCommands = new ANIMAudioCommand[vector.size()];
            vector.copyInto(this.audioCommands);
        }
    }

    public void setColorModel(ColorModel colorModel) {
        this.colorModel = colorModel;
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public void setData(byte[] byArray) {
        this.data = byArray;
    }

    public void setOperation(int n) {
        this.operation = n;
    }

    public void setMask(int n) {
        this.mask = n;
    }

    public void setWidth(int n) {
    }

    public void setHeight(int n) {
    }

    public void setX(int n) {
    }

    public void setY(int n) {
    }

    public void setAbsTime(long l) {
    }

    public void setRelTime(long l) {
        this.reltime = l;
    }

    public void setInterleave(int n) {
        this.interleave = n;
    }

    public void setBits(int n) {
        this.bits = n;
    }

    public int getOperation() {
        return this.operation;
    }

    public int getBits() {
        return this.bits;
    }

    public long getRelTime() {
        return this.reltime;
    }

    public abstract void decode(Bitmap var1, ANIMMovieTrack var2);

    public int getTopBound(ANIMMovieTrack aNIMMovieTrack) {
        return 0;
    }

    public int getBottomBound(ANIMMovieTrack aNIMMovieTrack) {
        return aNIMMovieTrack.getHeight() - 1;
    }

    public int getLeftBound(ANIMMovieTrack aNIMMovieTrack) {
        return 0;
    }

    public int getRightBound(ANIMMovieTrack aNIMMovieTrack) {
        return aNIMMovieTrack.getWidth() - 1;
    }
}

