/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.media.anim;

import ch.randelshofer.media.anim.ANIMAudioCommand;
import ch.randelshofer.media.anim.ANIMFrame;
import ch.randelshofer.util.ArrayUtil;
import java.applet.AudioClip;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ANIMMovieTrack {
    private int width_;
    private int height_;
    private int xPosition_;
    private int yPosition_;
    private int nbPlanes_;
    private int nbPalettes_ = -1;
    private int masking_;
    public static final int MSK_NONE = 0;
    public static final int MSK_HAS_MASK = 1;
    public static final int MSK_HAS_TRANSPARENT_COLOR = 2;
    public static final int MSK_LASSO = 3;
    private int transparentColor_;
    private int xAspect_;
    private int yAspect_;
    private int pageWidth_;
    private int pageHeight_;
    private int screenMode_;
    private int jiffies;
    private boolean isPlayWrapupFrames = false;
    private boolean isSwapSpeakers = false;
    public static final int MODE_INDEXED_COLORS = 0;
    public static final int MODE_DIRECT_COLORS = 1;
    public static final int MODE_EHB = 2;
    public static final int MODE_HAM6 = 3;
    public static final int MODE_HAM8 = 4;
    private int compression_;
    public static final int CMP_NONE = 0;
    public static final int CMP_BYTE_RUN_1 = 1;
    private long totalDuration_;
    private Hashtable properties_ = new Hashtable();
    private Vector frames_ = new Vector();
    private Vector audioClips_ = new Vector();
    private PropertyChangeSupport listeners_ = new PropertyChangeSupport(this);

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners_.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listeners_.removePropertyChangeListener(propertyChangeListener);
    }

    public void setProperty(String string, Object object) {
        Object v = this.properties_.get(string);
        if (object == null) {
            this.properties_.remove(string);
        } else {
            this.properties_.put(string, object);
        }
        this.listeners_.firePropertyChange(string, v, object);
    }

    public void setPlayWrapupFrames(boolean bl) {
        this.isPlayWrapupFrames = bl;
        this.nbPalettes_ = -1;
    }

    public boolean isPlayWrapupFrames() {
        return this.isPlayWrapupFrames();
    }

    public void setSwapSpeakers(boolean bl) {
        boolean bl2 = this.isSwapSpeakers;
        this.isSwapSpeakers = bl;
        if (bl != bl2) {
            Enumeration enumeration = this.frames_.elements();
            while (enumeration.hasMoreElements()) {
                ANIMAudioCommand[] aNIMAudioCommandArray = ((ANIMFrame)enumeration.nextElement()).getAudioCommands();
                if (aNIMAudioCommandArray == null) continue;
                for (int i = 0; i < aNIMAudioCommandArray.length; ++i) {
                    aNIMAudioCommandArray[i].dispose();
                }
            }
        }
    }

    public boolean isSwapSpeakers() {
        return this.isSwapSpeakers;
    }

    public Object getProperty(String string) {
        return this.properties_.get(string);
    }

    private void firePropertyChange(String string, int n, int n2) {
        this.listeners_.firePropertyChange(string, new Integer(n), new Integer(n2));
    }

    public void setJiffies(int n) {
        int n2 = this.jiffies;
        this.jiffies = n;
        this.firePropertyChange("jiffies", n2, n);
    }

    public void setCompression(int n) {
        int n2 = this.compression_;
        this.compression_ = n;
        this.firePropertyChange("compression", n2, n);
    }

    public void setWidth(int n) {
        int n2 = this.width_;
        this.width_ = n;
        this.firePropertyChange("width", n2, n);
    }

    public void setHeight(int n) {
        int n2 = this.height_;
        this.height_ = n;
        this.firePropertyChange("height", n2, n);
    }

    public void setXPosition(int n) {
        int n2 = this.xPosition_;
        this.xPosition_ = n;
        this.firePropertyChange("xPosition", n2, n);
    }

    public void setYPosition(int n) {
        int n2 = this.yPosition_;
        this.yPosition_ = n;
        this.firePropertyChange("yPosition", n2, n);
    }

    public void setNbPlanes(int n) {
        int n2 = this.nbPlanes_;
        this.nbPlanes_ = n;
        this.firePropertyChange("nbPlanes", n2, n);
    }

    public void setMasking(int n) {
        int n2 = this.masking_;
        this.masking_ = n;
        this.firePropertyChange("masking", n2, n);
    }

    public void setTransparentColor(int n) {
        int n2 = this.transparentColor_;
        this.transparentColor_ = n;
        this.firePropertyChange("transparentColor", n2, n);
    }

    public void setXAspect(int n) {
        int n2 = this.xAspect_;
        this.xAspect_ = n;
        this.firePropertyChange("xAspect", n2, n);
    }

    public void setYAspect(int n) {
        int n2 = this.yAspect_;
        this.yAspect_ = n;
        this.firePropertyChange("yAspect", n2, n);
    }

    public void setPageWidth(int n) {
        int n2 = this.pageWidth_;
        this.pageWidth_ = n;
        this.firePropertyChange("pageWidth", n2, n);
    }

    public void setPageHeight(int n) {
        int n2 = this.pageHeight_;
        this.pageHeight_ = n;
        this.firePropertyChange("pageHeight", n2, n);
    }

    public void setScreenMode(int n) {
        int n2 = this.screenMode_;
        this.screenMode_ = n;
        this.firePropertyChange("screenMode", n2, n);
    }

    public int getWidth() {
        return this.width_;
    }

    public int getHeight() {
        return this.height_;
    }

    public int getXPosition() {
        return this.xPosition_;
    }

    public int getYPosition() {
        return this.yPosition_;
    }

    public int getNbPlanes() {
        return this.nbPlanes_;
    }

    public int getNbPalettes() {
        block4: {
            int n;
            if (this.nbPalettes_ != -1 || (n = this.getFrameCount()) <= 0) break block4;
            ColorModel colorModel = this.getFrame(0).getColorModel();
            if (colorModel instanceof IndexColorModel) {
                IndexColorModel indexColorModel = (IndexColorModel)colorModel;
                int n2 = indexColorModel.getMapSize();
                byte[] byArray = new byte[n2];
                byte[] byArray2 = new byte[n2];
                byte[] byArray3 = new byte[n2];
                byte[] byArray4 = new byte[n2];
                byte[] byArray5 = new byte[n2];
                byte[] byArray6 = new byte[n2];
                indexColorModel.getReds(byArray);
                indexColorModel.getGreens(byArray2);
                indexColorModel.getBlues(byArray3);
                this.nbPalettes_ = 1;
                for (int i = 1; i < n; ++i) {
                    IndexColorModel indexColorModel2 = (IndexColorModel)this.getFrame(i).getColorModel();
                    if (indexColorModel2 == indexColorModel) continue;
                    indexColorModel2.getReds(byArray4);
                    indexColorModel2.getGreens(byArray5);
                    indexColorModel2.getBlues(byArray6);
                    if (ArrayUtil.equals(byArray4, byArray) && ArrayUtil.equals(byArray5, byArray2) && ArrayUtil.equals(byArray6, byArray3)) continue;
                    ++this.nbPalettes_;
                    indexColorModel = indexColorModel2;
                    System.arraycopy(byArray4, 0, byArray, 0, byArray4.length);
                    System.arraycopy(byArray5, 0, byArray2, 0, byArray5.length);
                    System.arraycopy(byArray6, 0, byArray3, 0, byArray6.length);
                }
            } else {
                this.nbPalettes_ = 1;
                ColorModel colorModel2 = colorModel;
                for (int i = 1; i < n; ++i) {
                    ColorModel colorModel3 = this.getFrame(i).getColorModel();
                    if (colorModel3 == colorModel2) continue;
                    ++this.nbPalettes_;
                    colorModel2 = colorModel3;
                }
            }
        }
        return this.nbPalettes_;
    }

    public int getMasking() {
        return this.masking_;
    }

    public int getTransparentColor() {
        return this.transparentColor_;
    }

    public int getXAspect() {
        return this.xAspect_;
    }

    public int getYAspect() {
        return this.yAspect_;
    }

    public int getPageWidth() {
        return this.pageWidth_;
    }

    public int getPageHeight() {
        return this.pageHeight_;
    }

    public int getScreenMode() {
        return this.screenMode_;
    }

    public int getJiffies() {
        return this.jiffies;
    }

    public int getCompression() {
        return this.compression_;
    }

    public int getDeltaOperation() {
        int n = this.frames_.size() - 1;
        if (n < 0) {
            return -1;
        }
        return ((ANIMFrame)this.frames_.elementAt(n)).getOperation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFrame(ANIMFrame aNIMFrame) {
        int n;
        ANIMMovieTrack aNIMMovieTrack = this;
        synchronized (aNIMMovieTrack) {
            n = this.frames_.size();
            this.frames_.addElement(aNIMFrame);
            this.totalDuration_ = -1L;
        }
        this.firePropertyChange("frameCount", n, n + 1);
    }

    public void addAudioClip(AudioClip audioClip) {
        int n = this.audioClips_.size();
        this.audioClips_.addElement(audioClip);
        this.firePropertyChange("audioClipCount", n, n + 1);
    }

    public int getAudioClipCount() {
        return this.audioClips_.size();
    }

    public AudioClip getAudioClip(int n) {
        return (AudioClip)this.audioClips_.elementAt(n);
    }

    public int getFrameCount() {
        int n = this.frames_.size();
        if (this.isPlayWrapupFrames) {
            return n;
        }
        return n > 3 ? n - 2 : n;
    }

    public ANIMFrame getFrame(int n) {
        return (ANIMFrame)this.frames_.elementAt(n);
    }

    public long getFrameDuration(int n) {
        return ((ANIMFrame)this.frames_.elementAt(n)).getRelTime();
    }

    public synchronized long getTotalDuration() {
        if (this.totalDuration_ == -1L) {
            this.totalDuration_ = 0L;
            for (int i = this.getFrameCount() - 1; i > -1; --i) {
                this.totalDuration_ += this.getFrameDuration(i) + 1L;
            }
        }
        return this.totalDuration_;
    }
}

