/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.media.anim;

import ch.randelshofer.gui.BoundedRangeModel;
import ch.randelshofer.gui.DefaultBoundedRangeModel;
import ch.randelshofer.gui.ImagePanelAWT;
import ch.randelshofer.gui.event.ChangeEvent;
import ch.randelshofer.gui.event.ChangeListener;
import ch.randelshofer.gui.image.Bitmap;
import ch.randelshofer.io.BoundedRangeInputStream;
import ch.randelshofer.media.AbstractPlayer;
import ch.randelshofer.media.MovieControlAqua;
import ch.randelshofer.media.anim.ANIMAudioCommand;
import ch.randelshofer.media.anim.ANIMDecoder;
import ch.randelshofer.media.anim.ANIMFrame;
import ch.randelshofer.media.anim.ANIMMovieTrack;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public class ANIMPlayer
extends AbstractPlayer
implements PropertyChangeListener,
ChangeListener,
MouseListener {
    private MemoryImageSource memoryImage;
    private BoundedRangeModel timeModel;
    private BoundedRangeInputStream cachingControlModel;
    private InputStream in;
    private ANIMMovieTrack track;
    private Bitmap bitmapEven;
    private Bitmap bitmapOdd;
    private int preparedEven;
    private int preparedOdd;
    private int fetchedEven;
    private int fetchedOdd;
    private int displayFrame = -1;
    private boolean isPlayEveryFrame = false;
    private volatile boolean isLoop = true;
    private float jiffieMillis = 16.666666f;
    private int globalFrameDuration = -1;
    private ImagePanelAWT visualComponent;
    private MovieControlAqua controlComponent;
    private Object decoderLock = new Object();
    private ColorModel preferredColorModel = null;
    private volatile boolean isCached = false;
    private ANIMAudioCommand[] audioChannels = new ANIMAudioCommand[4];
    private boolean isAudioEnabled = true;
    private boolean isLoadAudio;
    private int inputFileSize = -1;
    public boolean debug = false;
    private Hashtable properties;
    private boolean isAudioAvailable;
    private boolean isPingPong = true;
    private int playDirection = 1;

    public ANIMPlayer(InputStream inputStream) {
        this(inputStream, -1, true);
    }

    public ANIMPlayer(InputStream inputStream, int n, boolean bl) {
        this.in = inputStream;
        this.inputFileSize = n;
        this.isLoadAudio = bl;
    }

    public void setPreferredColorModel(ColorModel colorModel) {
        if (this.bitmapEven == null) {
            this.preferredColorModel = colorModel;
        }
    }

    public BoundedRangeModel getTimeModel() {
        return this.timeModel;
    }

    public void setAudioEnabled(boolean bl) {
        boolean bl2 = this.isAudioEnabled;
        this.isAudioEnabled = bl;
        this.propertyChangeSupport.firePropertyChange("audioEnabled", bl2 ? Boolean.TRUE : Boolean.FALSE, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isAudioEnabled() {
        return this.isAudioEnabled;
    }

    public void setSwapSpeakers(boolean bl) {
        boolean bl2 = this.track.isSwapSpeakers();
        this.track.setSwapSpeakers(bl);
        this.propertyChangeSupport.firePropertyChange("swapSpeakers", bl2 ? Boolean.TRUE : Boolean.FALSE, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isSwapSpeakers() {
        return this.track.isSwapSpeakers();
    }

    public BoundedRangeModel getCachingModel() {
        return this.cachingControlModel;
    }

    protected ImageProducer getImageProducer() {
        return this.memoryImage;
    }

    public ANIMMovieTrack getMovieTrack() {
        return this.track;
    }

    public synchronized Component getVisualComponent() {
        if (this.visualComponent == null) {
            this.visualComponent = new ImagePanelAWT();
            if (this.getImageProducer() != null) {
                this.visualComponent.setImage(this.visualComponent.getToolkit().createImage(this.getImageProducer()));
            }
            this.visualComponent.addMouseListener(this);
        }
        return this.visualComponent;
    }

    public synchronized Component getControlPanelComponent() {
        if (this.controlComponent == null) {
            this.controlComponent = new MovieControlAqua();
            this.controlComponent.setPlayer(this);
        }
        return this.controlComponent;
    }

    protected void doUnrealized() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRealizing() {
        String string;
        Object object;
        this.timeModel = new DefaultBoundedRangeModel(0, 0, 0, 0);
        this.timeModel.addChangeListener(this);
        this.cachingControlModel = new BoundedRangeInputStream(this.in);
        if (this.inputFileSize != -1) {
            this.cachingControlModel.setMaximum(this.inputFileSize);
        }
        this.track = new ANIMMovieTrack();
        this.track.addPropertyChangeListener(this);
        Runnable runnable = this;
        synchronized (runnable) {
            if (this.controlComponent != null) {
                this.controlComponent.setPlayer(this);
            }
        }
        runnable = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                block18: {
                    try {
                        ANIMDecoder aNIMDecoder = new ANIMDecoder(ANIMPlayer.this.cachingControlModel);
                        aNIMDecoder.produce(ANIMPlayer.this.track, 0, ANIMPlayer.this.isLoadAudio);
                        ANIMPlayer.this.isCached = true;
                        ANIMPlayer.this.cachingControlModel.setValue(ANIMPlayer.this.cachingControlModel.getMaximum());
                        ANIMPlayer.this.propertyChangeSupport.firePropertyChange("cached", Boolean.FALSE, Boolean.TRUE);
                        if (ANIMPlayer.this.track.getFrameCount() != 0) break block18;
                        Object object = ANIMPlayer.this.decoderLock;
                        synchronized (object) {
                            ANIMPlayer.this.setTargetState(-1);
                            ANIMPlayer.this.decoderLock.notifyAll();
                        }
                    }
                    catch (Throwable throwable) {
                        Object object = ANIMPlayer.this.decoderLock;
                        synchronized (object) {
                            if (ANIMPlayer.this.visualComponent != null) {
                                ANIMPlayer.this.visualComponent.setMessage(throwable.toString());
                            }
                            ANIMPlayer.this.setTargetState(-1);
                            ANIMPlayer.this.decoderLock.notifyAll();
                            throwable.printStackTrace();
                        }
                    }
                    finally {
                        try {
                            ANIMPlayer.this.in.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        };
        ((Thread)runnable).start();
        Object object2 = this.decoderLock;
        synchronized (object2) {
            while (this.track.getFrameCount() < 1 && this.getTargetState() != -1) {
                try {
                    this.decoderLock.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        int n = this.track.getWidth();
        int n2 = this.track.getHeight();
        int n3 = this.track.getNbPlanes();
        int n4 = this.track.getMasking();
        if (this.track.getFrameCount() > 0) {
            object = this.track.getFrame(0);
            object2 = ((ANIMFrame)object).getColorModel();
        } else {
            object2 = new DirectColorModel(24, 0xFF0000, 65280, 255);
        }
        this.bitmapEven = new Bitmap(n, n2, n3 + (n4 == 1 ? 1 : 0), (ColorModel)object2);
        this.bitmapOdd = new Bitmap(n, n2, n3 + (n4 == 1 ? 1 : 0), (ColorModel)object2);
        this.jiffieMillis = 1000.0f / (float)this.track.getJiffies();
        this.bitmapEven.setPreferredChunkyColorModel(this.preferredColorModel);
        this.bitmapOdd.setPreferredChunkyColorModel(this.preferredColorModel);
        this.properties = new Hashtable();
        this.properties.put("aspect", new Double((double)this.track.getXAspect() / (double)this.track.getYAspect()));
        object = this.track.getProperty("comment");
        if (object != null) {
            this.properties.put("comment", object);
        }
        switch (this.track.getScreenMode()) {
            case 0: {
                string = "Indexed Colors";
                break;
            }
            case 1: {
                string = "Direct Colors";
                break;
            }
            case 2: {
                string = "EHB";
                break;
            }
            case 3: {
                string = "HAM 6";
                break;
            }
            case 4: {
                string = "HAM 8";
                break;
            }
            default: {
                string = "unknown";
            }
        }
        this.properties.put("screenMode", string);
        this.properties.put("nbPlanes", "" + this.track.getNbPlanes());
        this.properties.put("jiffies", "" + this.track.getJiffies());
        if (this.bitmapEven.isEnforceDirectColors()) {
            object2 = this.preferredColorModel instanceof DirectColorModel ? this.preferredColorModel : new DirectColorModel(24, 0xFF0000, 65280, 255);
            this.memoryImage = new MemoryImageSource(n, n2, (ColorModel)object2, new int[n * n2], 0, n, this.properties);
        } else {
            this.memoryImage = object2 instanceof DirectColorModel ? new MemoryImageSource(n, n2, (ColorModel)object2, new int[n * n2], 0, n, this.properties) : new MemoryImageSource(n, n2, (ColorModel)object2, new byte[n * n2], 0, n, this.properties);
        }
        this.memoryImage.setAnimated(true);
        this.preparedOdd = Integer.MAX_VALUE;
        this.preparedEven = Integer.MAX_VALUE;
        this.fetchedOdd = Integer.MAX_VALUE;
        this.fetchedEven = Integer.MAX_VALUE;
        if (this.track.getFrameCount() > 0) {
            this.renderVideo(0);
            this.properties.put("renderMode", this.bitmapEven.getChunkyColorModel());
        }
        ANIMPlayer aNIMPlayer = this;
        synchronized (aNIMPlayer) {
            if (this.visualComponent != null) {
                this.visualComponent.setImage(this.visualComponent.getToolkit().createImage(this.getImageProducer()));
            }
        }
    }

    protected void doRealized() {
    }

    protected void doPrefetching() {
        this.renderVideo(this.timeModel.getValue());
    }

    protected void doPrefetched() {
    }

    public void setPlayEveryFrame(boolean bl) {
        this.isPlayEveryFrame = bl;
    }

    public void setPlayWrapupFrames(boolean bl) {
        this.track.setPlayWrapupFrames(bl);
        int n = this.track.getFrameCount();
        this.timeModel.setMaximum(n > 0 ? n - 1 : 0);
    }

    public boolean isPlayWrapupFrames() {
        return this.track.isPlayWrapupFrames();
    }

    public void setFramesPerSecond(float f) {
        if (f <= 0.0f) {
            this.setGlobalFrameDuration(-1);
        } else {
            this.setGlobalFrameDuration((int)(1000.0f / f));
        }
    }

    public void setGlobalFrameDuration(int n) {
        this.globalFrameDuration = n;
    }

    public boolean isPlayEveryFrame() {
        return this.isPlayEveryFrame;
    }

    public void setLoop(boolean bl) {
        boolean bl2 = this.isLoop;
        this.isLoop = bl;
        this.propertyChangeSupport.firePropertyChange("isLoop", new Boolean(bl2), new Boolean(bl));
    }

    public boolean isLoop() {
        return this.isLoop;
    }

    public String getDeltaOperationDescription() {
        String string;
        int n = this.track.getDeltaOperation();
        switch (n) {
            case 0: {
                string = "OP Direct";
                break;
            }
            case 1: {
                string = "XOR";
                break;
            }
            case 2: {
                string = "Long Delta";
                break;
            }
            case 3: {
                string = "Short Delta";
                break;
            }
            case 4: {
                string = "General Delta";
                break;
            }
            case 5: {
                string = "Byte Vertical";
                break;
            }
            case 6: {
                string = "Stereo Delta";
                break;
            }
            case 7: {
                string = "Vertical";
                break;
            }
            case 8: {
                string = "Vertical";
                break;
            }
            case 74: {
                string = "Eric Graham's compression";
                break;
            }
            default: {
                string = "unknown";
            }
        }
        return string + " OP(" + n + ")";
    }

    protected void doStarted() {
        long l = System.currentTimeMillis() + (long)this.jiffieMillis;
        if (this.timeModel.getValue() == this.timeModel.getMaximum()) {
            this.timeModel.setValue(this.timeModel.getMinimum());
        }
        while (this.getTargetState() == 5) {
            long l2;
            int n = this.timeModel.getValue();
            if (this.isPlayEveryFrame) {
                if (this.isAudioEnabled) {
                    this.prepareAudio(n);
                }
                this.prepareVideo(n);
                if (l > System.currentTimeMillis() && (l2 = l - System.currentTimeMillis()) > 0L) {
                    try {
                        Thread.sleep(l2);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                l = this.globalFrameDuration == -1 ? System.currentTimeMillis() + (long)((float)this.track.getFrameDuration(n) * this.jiffieMillis + this.jiffieMillis) : System.currentTimeMillis() + (long)this.globalFrameDuration;
                if (this.isAudioEnabled && !this.timeModel.getValueIsAdjusting()) {
                    this.renderAudio(n);
                } else {
                    this.muteAudio();
                }
                this.renderVideo(n);
                Thread.yield();
            } else if (l > System.currentTimeMillis()) {
                if (this.isAudioEnabled) {
                    this.prepareAudio(n);
                }
                this.prepareVideo(n);
                l2 = l - System.currentTimeMillis();
                if (l2 > 0L) {
                    try {
                        Thread.sleep(l2);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                l = this.globalFrameDuration == -1 ? (l += (long)((float)this.track.getFrameDuration(n) * this.jiffieMillis + this.jiffieMillis)) : (l += (long)this.globalFrameDuration);
                if (this.isAudioEnabled && !this.timeModel.getValueIsAdjusting()) {
                    this.renderAudio(n);
                } else {
                    this.muteAudio();
                }
                this.renderVideo(n);
                Thread.yield();
            } else {
                if (this.isAudioEnabled && !this.timeModel.getValueIsAdjusting()) {
                    this.renderAudio(n);
                } else {
                    this.muteAudio();
                }
                l = this.globalFrameDuration == -1 ? (l += (long)((float)this.track.getFrameDuration(n) * this.jiffieMillis + this.jiffieMillis)) : (l += (long)this.globalFrameDuration);
            }
            if (this.timeModel.getValueIsAdjusting()) continue;
            if (this.timeModel.getValue() == this.timeModel.getMaximum()) {
                if (this.isCached && this.isLoop && !this.isPingPong) {
                    this.timeModel.setValue(this.timeModel.getMinimum());
                    continue;
                }
                if (!this.isCached || !this.isPingPong || this.playDirection != 1) break;
                this.playDirection = -1;
                this.timeModel.setValue(this.timeModel.getValue() + this.playDirection);
                continue;
            }
            if (this.timeModel.getValue() == this.timeModel.getMinimum() && this.isPingPong && this.playDirection == -1) {
                this.playDirection = 1;
                this.timeModel.setValue(this.timeModel.getValue() + this.playDirection);
                continue;
            }
            this.timeModel.setValue(this.timeModel.getValue() + this.playDirection);
        }
        this.renderVideo(this.timeModel.getValue());
        this.muteAudio();
    }

    private void muteAudio() {
        for (int i = 0; i < this.audioChannels.length; ++i) {
            if (this.audioChannels[i] == null) continue;
            this.audioChannels[i].stop(this.track);
            this.audioChannels[i] = null;
        }
    }

    protected void doClosed() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.timeModel != null) {
            int n = this.track.getFrameCount();
            this.timeModel.setMaximum(n > 0 ? n - 1 : 0);
            Object object = this.decoderLock;
            synchronized (object) {
                this.decoderLock.notifyAll();
            }
        }
        if (propertyChangeEvent.getPropertyName().equals("audioClipCount")) {
            this.setAudioAvailable(this.track.getAudioClipCount() > 0);
        }
    }

    private void fetchFrame(int n) {
        Bitmap bitmap;
        int n2;
        ANIMFrame aNIMFrame = null;
        if ((n & 1) == 0) {
            if (this.fetchedEven == n) {
                return;
            }
            n2 = this.fetchedEven;
            bitmap = this.bitmapEven;
            this.fetchedEven = n;
            if (this.isPingPong && n2 == n + 2) {
                aNIMFrame = this.track.getFrame(n2);
                aNIMFrame.decode(bitmap, this.track);
                return;
            }
            if (n2 > n) {
                aNIMFrame = this.track.getFrame(0);
                aNIMFrame.decode(bitmap, this.track);
                n2 = 0;
            }
        } else {
            if (this.fetchedOdd == n) {
                return;
            }
            n2 = this.fetchedOdd;
            this.fetchedOdd = n;
            bitmap = this.bitmapOdd;
            if (this.isPingPong && n2 == n + 2) {
                aNIMFrame = this.track.getFrame(n2);
                aNIMFrame.decode(bitmap, this.track);
                return;
            }
            if (n2 > n) {
                aNIMFrame = this.track.getFrame(0);
                aNIMFrame.decode(bitmap, this.track);
                aNIMFrame = this.track.getFrame(1);
                aNIMFrame.decode(bitmap, this.track);
                n2 = 1;
            }
        }
        for (int i = n2 + 2; i <= n; i += 2) {
            aNIMFrame = this.track.getFrame(i);
            aNIMFrame.decode(bitmap, this.track);
        }
    }

    private void prepareVideo(int n) {
        Bitmap bitmap;
        int n2;
        if ((n & 1) == 0) {
            if (this.preparedEven == n) {
                return;
            }
            n2 = this.preparedEven;
            this.preparedEven = n;
            bitmap = this.bitmapEven;
        } else {
            if (this.preparedOdd == n) {
                return;
            }
            n2 = this.preparedOdd;
            this.preparedOdd = n;
            bitmap = this.bitmapOdd;
        }
        this.fetchFrame(n);
        ANIMFrame aNIMFrame = this.track.getFrame(n);
        ColorModel colorModel = aNIMFrame.getColorModel();
        bitmap.setPlanarColorModel(colorModel);
        if (n2 == n - 2 && (bitmap.getPixelType() == 1 || colorModel == this.track.getFrame(n2).getColorModel())) {
            bitmap.convertToChunky(aNIMFrame.getTopBound(this.track), aNIMFrame.getLeftBound(this.track), aNIMFrame.getBottomBound(this.track), aNIMFrame.getRightBound(this.track));
        } else if (this.isPingPong && n2 == n + 2 && (bitmap.getPixelType() == 1 || colorModel == this.track.getFrame(n2).getColorModel())) {
            aNIMFrame = this.track.getFrame(n + 2);
            bitmap.convertToChunky(aNIMFrame.getTopBound(this.track), aNIMFrame.getLeftBound(this.track), aNIMFrame.getBottomBound(this.track), aNIMFrame.getRightBound(this.track));
        } else {
            bitmap.convertToChunky();
        }
    }

    private void prepareAudio(int n) {
        ANIMFrame aNIMFrame = this.track.getFrame(n);
        ANIMAudioCommand[] aNIMAudioCommandArray = aNIMFrame.getAudioCommands();
        if (aNIMAudioCommandArray != null) {
            for (int i = 0; i < aNIMAudioCommandArray.length; ++i) {
                aNIMAudioCommandArray[i].prepare(this.track);
            }
        }
    }

    private void renderVideo(int n) {
        int n2;
        Bitmap bitmap;
        if (this.displayFrame == n) {
            return;
        }
        if ((n & 1) == 0) {
            bitmap = this.bitmapEven;
            n2 = this.preparedEven;
            bitmap = this.bitmapEven;
        } else {
            bitmap = this.bitmapOdd;
            n2 = this.preparedOdd;
            bitmap = this.bitmapOdd;
        }
        this.prepareVideo(n);
        ANIMFrame aNIMFrame = this.track.getFrame(n);
        ColorModel colorModel = bitmap.getChunkyColorModel();
        if (bitmap.getPixelType() == 2) {
            this.memoryImage.newPixels(bitmap.getIntPixels(), colorModel, 0, this.track.getWidth());
        } else {
            this.memoryImage.newPixels(bitmap.getBytePixels(), colorModel, 0, this.track.getWidth());
        }
        this.displayFrame = n;
        if (this.debug && this.visualComponent != null) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("frame:");
            stringBuffer.append(n);
            stringBuffer.append(" duration:");
            stringBuffer.append(aNIMFrame.getRelTime());
            stringBuffer.append("jiffies");
            stringBuffer.append(", anim op:");
            stringBuffer.append(aNIMFrame.getOperation());
            ANIMAudioCommand[] aNIMAudioCommandArray = aNIMFrame.getAudioCommands();
            if (aNIMAudioCommandArray != null) {
                for (int i = 0; i < aNIMAudioCommandArray.length; ++i) {
                    switch (aNIMAudioCommandArray[i].getCommand()) {
                        case 1: {
                            stringBuffer.append("\nplay");
                            break;
                        }
                        case 2: {
                            stringBuffer.append("\nstop");
                            break;
                        }
                        case 3: {
                            stringBuffer.append("\nfreqvol");
                            break;
                        }
                        default: {
                            stringBuffer.append("ILLEGAL COMMAND:");
                            stringBuffer.append(aNIMAudioCommandArray[i].getCommand());
                        }
                    }
                    stringBuffer.append(" sound:");
                    stringBuffer.append(aNIMAudioCommandArray[i].getSound());
                    stringBuffer.append(" freq:");
                    stringBuffer.append(aNIMAudioCommandArray[i].getFrequency());
                    stringBuffer.append(" vol:");
                    stringBuffer.append(aNIMAudioCommandArray[i].getVolume());
                    stringBuffer.append(" channels:");
                    int n3 = aNIMAudioCommandArray[i].getChannelMask();
                    boolean bl = true;
                    for (int j = 0; j < 4; ++j) {
                        if ((1 << j & n3) == 0) continue;
                        if (!bl) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(j);
                        stringBuffer.append(j % 2 == 0 ? "(l)" : "(r)");
                        bl = false;
                    }
                }
            }
            this.visualComponent.setMessage(stringBuffer.toString());
        }
    }

    private synchronized void renderAudio(int n) {
        ANIMFrame aNIMFrame;
        ANIMAudioCommand[] aNIMAudioCommandArray;
        this.prepareAudio(n);
        if (this.isActive() && (aNIMAudioCommandArray = (aNIMFrame = this.track.getFrame(n)).getAudioCommands()) != null) {
            for (int i = 0; i < aNIMAudioCommandArray.length; ++i) {
                aNIMAudioCommandArray[i].doCommand(this.track, this.audioChannels);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.timeModel) {
            if (this.getState() == 5) {
                ANIMPlayer aNIMPlayer = this;
                synchronized (aNIMPlayer) {
                    this.notifyAll();
                }
            } else {
                this.dispatcher.dispatch(new Runnable(){

                    public void run() {
                        ANIMPlayer.this.renderVideo(ANIMPlayer.this.getTimeModel().getValue());
                    }
                });
            }
        }
    }

    public long getTotalDuration() {
        if (this.globalFrameDuration == -1) {
            return (long)((float)this.track.getTotalDuration() * this.jiffieMillis);
        }
        return this.track.getFrameCount() * this.globalFrameDuration;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.getState() != -1 && mouseEvent.getModifiers() == 16) {
            if (this.getState() == 5 && this.getTargetState() == 5 && mouseEvent.getClickCount() == 1) {
                this.stop();
            } else if (this.getState() != 5 && this.getTargetState() != 5 && mouseEvent.getClickCount() == 2) {
                this.start();
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public boolean isCached() {
        return this.isCached;
    }

    public boolean isAudioAvailable() {
        return this.isAudioAvailable;
    }

    private void setAudioAvailable(boolean bl) {
        Boolean bl2 = this.isAudioAvailable ? Boolean.TRUE : Boolean.FALSE;
        this.isAudioAvailable = bl;
        this.propertyChangeSupport.firePropertyChange("audioAvailable", bl2, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setPingPong(boolean bl) {
        Boolean bl2 = this.isPingPong ? Boolean.TRUE : Boolean.FALSE;
        this.isPingPong = bl;
        if (!bl) {
            this.playDirection = 1;
        }
        this.propertyChangeSupport.firePropertyChange("pingPong", bl2, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean isPingPong() {
        return this.isPingPong;
    }
}

