/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.media.eightsvx;

import ch.randelshofer.media.eightsvx.LoopableAudioClip;
import java.io.InputStream;
import sun.audio.AudioData;
import sun.audio.AudioDataStream;
import sun.audio.AudioPlayer;
import sun.audio.ContinuousAudioDataStream;

public class JDK10AudioClip
implements LoopableAudioClip {
    private int sampleRate;
    private byte[] samples;
    private AudioDataStream audioStream;

    public JDK10AudioClip(byte[] byArray, int n) {
        this.samples = byArray;
        this.sampleRate = n;
    }

    public synchronized void play() {
        this.stop();
        byte[] byArray = new byte[this.samples.length + 24];
        JDK10AudioClip.writeSunAudioHeader(byArray, this.sampleRate, this.samples.length);
        System.arraycopy(this.samples, 0, byArray, 24, this.samples.length);
        AudioData audioData = new AudioData(byArray);
        this.audioStream = new AudioDataStream(audioData);
        AudioPlayer.player.start((InputStream)this.audioStream);
    }

    public synchronized void loop() {
        this.stop();
        byte[] byArray = new byte[this.samples.length + 24];
        JDK10AudioClip.writeSunAudioHeader(byArray, this.sampleRate, this.samples.length);
        System.arraycopy(this.samples, 0, byArray, 24, this.samples.length);
        AudioData audioData = new AudioData(byArray);
        ContinuousAudioDataStream continuousAudioDataStream = new ContinuousAudioDataStream(audioData);
        AudioPlayer.player.start((InputStream)continuousAudioDataStream);
    }

    public void loop(int n) {
        if (n == 1 || n == 0) {
            this.play();
        } else if (n == -1) {
            this.loop();
        } else {
            this.stop();
            byte[] byArray = new byte[this.samples.length * n + 24];
            JDK10AudioClip.writeSunAudioHeader(byArray, this.sampleRate, this.samples.length * n);
            for (int i = 0; i < n; ++i) {
                System.arraycopy(this.samples, 0, byArray, 24 + i * this.samples.length, this.samples.length);
            }
            AudioData audioData = new AudioData(byArray);
            ContinuousAudioDataStream continuousAudioDataStream = new ContinuousAudioDataStream(audioData);
            AudioPlayer.player.start((InputStream)continuousAudioDataStream);
        }
    }

    public synchronized void stop() {
        if (this.audioStream != null) {
            AudioPlayer.player.stop((InputStream)this.audioStream);
            this.audioStream = null;
        }
    }

    public static void writeSunAudioHeader(byte[] byArray, int n, int n2) {
        int n3 = 24;
        byte[] byArray2 = new byte[]{46, 115, 110, 100, (byte)(n3 >>> 24 & 0xFF), (byte)(n3 >>> 16 & 0xFF), (byte)(n3 >>> 8 & 0xFF), (byte)(n3 & 0xFF), (byte)(n2 >>> 24 & 0xFF), (byte)(n2 >>> 16 & 0xFF), (byte)(n2 >>> 8 & 0xFF), (byte)(n2 & 0xFF), 0, 0, 0, 1, (byte)(n >>> 24 & 0xFF), (byte)(n >>> 16 & 0xFF), (byte)(n >>> 8 & 0xFF), (byte)(n & 0xFF), 0, 0, 0, 1};
        System.arraycopy(byArray2, 0, byArray, 0, n3);
    }
}

