/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.util;

import ch.randelshofer.util.StateEvent;
import ch.randelshofer.util.StateListener;
import ch.randelshofer.util.StateModel;

public class StateTracker
implements StateListener {
    private StateModel model_;
    private int[] targetStates_;
    private int targetStateIndex_;

    public StateTracker(StateModel stateModel) {
        this.setStateModel(stateModel);
    }

    public void setStateModel(StateModel stateModel) {
        if (this.model_ != null) {
            this.model_.removeStateListener(this);
        }
        this.model_ = stateModel;
        if (this.model_ != null) {
            this.model_.addStateListener(this);
        }
    }

    public void waitForState(int n) {
        int[] nArray = new int[]{n};
        this.waitForState(nArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitForState(int[] nArray) {
        StateTracker stateTracker = this;
        synchronized (stateTracker) {
            this.targetStates_ = nArray;
            this.targetStateIndex_ = -1;
            int n = this.model_.getState();
            for (int i = 0; i < this.targetStates_.length; ++i) {
                if (n != this.targetStates_[i]) continue;
                return this.targetStates_[i];
            }
            while (this.targetStateIndex_ == -1) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return this.targetStates_[this.targetStateIndex_];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(StateEvent stateEvent) {
        StateTracker stateTracker = this;
        synchronized (stateTracker) {
            if (this.targetStates_ != null && this.targetStateIndex_ == -1) {
                int n = stateEvent.getNewState();
                for (int i = 0; i < this.targetStates_.length; ++i) {
                    if (n != this.targetStates_[i]) continue;
                    this.targetStateIndex_ = i;
                    this.notifyAll();
                    break;
                }
            }
        }
    }
}

