/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.app;

import ch.randelshofer.gui.ImagePanelAWT;
import ch.randelshofer.io.SuspendableInputStream;
import ch.randelshofer.media.MovieControlAqua;
import ch.randelshofer.media.anim.ANIMMovieTrack;
import ch.randelshofer.media.anim.ANIMPlayer;
import ch.randelshofer.util.Applets;
import ch.randelshofer.util.StateTracker;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.image.ColorModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ANIMApplet
extends Applet
implements Runnable,
PropertyChangeListener {
    private static final String version = "3.4 2008-04-05";
    private MovieControlAqua controllerPanel;
    private ImagePanelAWT imagePanel;
    private ANIMPlayer player;
    private Thread loaderThread;
    private boolean isPlaying;
    private String[] messages;
    private SuspendableInputStream suspendableInputStream;
    private boolean debug;

    public void init() {
        this.debug = Applets.getParameter((Applet)this, "debug", false);
        this.setLayout(new BorderLayout());
        this.setBackground(Applets.getParameter((Applet)this, "boxBgColor", Color.white));
        this.setForeground(Applets.getParameter((Applet)this, "boxFgColor", Color.black));
    }

    public void paint(Graphics graphics) {
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n = fontMetrics.getAscent();
        int n2 = fontMetrics.getHeight();
        if (this.messages == null) {
            graphics.drawString("Loading ANIMApplet 3.4 2008-04-05", 0, n);
            graphics.drawString("\u00a9 Werner Randelshofer", 0, n + n2);
        } else if (this.messages != null) {
            int n3 = 0;
            for (int i = 0; i < this.messages.length; ++i) {
                int n4 = fontMetrics.stringWidth(this.messages[i]);
                graphics.drawString(this.messages[i], 0, n3 + n);
                n3 += n2;
            }
        }
    }

    public void run() {
        try {
            FilterInputStream filterInputStream;
            int n;
            Object object;
            URLConnection uRLConnection;
            Object object2;
            String string = Applets.getParameter((Applet)this, "animSource", Applets.getParameter((Applet)this, "imageSource", ""));
            String string2 = Applets.getParameter((Applet)this, "animArchive", Applets.getParameter((Applet)this, "imageArchive", (String)null));
            String string3 = Applets.getParameter((Applet)this, "anim", Applets.getParameter((Applet)this, "image", (String)null));
            if (string.length() > 0 && string.charAt(string.length() - 1) != '/') {
                string = string + '/';
            }
            if (string2 != null) {
                ZipEntry zipEntry;
                object2 = new URL(this.getDocumentBase(), string + string2);
                uRLConnection = ((URL)object2).openConnection();
                uRLConnection.connect();
                this.suspendableInputStream = new SuspendableInputStream(uRLConnection.getInputStream());
                object = new ZipInputStream(this.suspendableInputStream){

                    public long skip(long l) throws IOException {
                        long l2;
                        long l3;
                        for (l2 = 0L; l2 < l; l2 += l3) {
                            l3 = super.skip(Math.min(l - l2, 512L));
                            if (l3 != -1L) continue;
                            if (l2 != 0L) break;
                            l2 = -1L;
                            break;
                        }
                        return l2;
                    }
                };
                while (!(zipEntry = ((ZipInputStream)object).getNextEntry()).getName().equals(string3)) {
                }
                n = (int)zipEntry.getSize();
                if (n == -1) {
                    System.err.println("ANIMApplet Warning:\n  Unable to show an accurate progress bar while loading the ANIM file.\n  Please recompress the Zip archive with a tool that stores the file size at the beginning of the Zip entries.\n  Zip Archive: " + object2);
                    n = uRLConnection.getContentLength();
                    if (n != -1) {
                        n *= 2;
                    }
                }
                filterInputStream = object;
            } else {
                object2 = new URL(this.getDocumentBase(), string + string3);
                uRLConnection = ((URL)object2).openConnection();
                uRLConnection.connect();
                n = uRLConnection.getContentLength();
                filterInputStream = this.suspendableInputStream = new SuspendableInputStream(uRLConnection.getInputStream());
            }
            this.player = new ANIMPlayer(filterInputStream, n, Applets.getParameter((Applet)this, "audio", true));
            this.player.debug = this.debug;
            if (Applets.getParameter((Applet)this, "renderAsTrueColor", true)) {
                this.player.setPreferredColorModel(ColorModel.getRGBdefault());
            }
            this.controllerPanel = (MovieControlAqua)this.player.getControlPanelComponent();
            if (Applets.getParameter((Applet)this, "controller", true)) {
                this.add("South", this.controllerPanel);
            }
            this.imagePanel = (ImagePanelAWT)this.player.getVisualComponent();
            object2 = Applets.getParameter((Applet)this, "scale", "toFit").toLowerCase();
            if (((String)object2).equals("tofit")) {
                this.imagePanel.setImageScalePolicy(1);
            } else if (((String)object2).equals("aspect")) {
                this.imagePanel.setImageScalePolicy(2);
            } else {
                this.imagePanel.setImageScalePolicy(0);
                try {
                    double d = Double.valueOf((String)object2);
                    this.imagePanel.setScaleFactor(d, d);
                }
                catch (NumberFormatException numberFormatException) {
                    this.imagePanel.setMessage("Invalid property: scale=" + (String)object2);
                    this.imagePanel.setImageScalePolicy(1);
                }
            }
            this.add("Center", this.imagePanel);
            StateTracker stateTracker = new StateTracker(this.player);
            this.player.realize();
            object = new int[]{2, -1};
            stateTracker.waitForState((int[])object);
            stateTracker.setStateModel(null);
            this.player.setLoop(Applets.getParameter((Applet)this, "loop", true));
            this.player.setPingPong(Applets.getParameter((Applet)this, "pingPong", false));
            this.player.getMovieTrack().setPlayWrapupFrames(Applets.getParameter((Applet)this, "playWrapupFrames", false));
            object2 = this.getParameter("framesPerSecond");
            if (object2 != null) {
                try {
                    this.player.setFramesPerSecond(Float.valueOf((String)object2).floatValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.doLayout();
            this.repaint();
            this.player.addPropertyChangeListener(this);
            if (Applets.getParameter((Applet)this, "autoStart", true) && this.player.isCached()) {
                this.player.start();
            }
        }
        catch (Throwable throwable) {
            this.setMessage(throwable.toString() + "\n" + throwable.getMessage());
            this.removeAll();
            this.doLayout();
            this.repaint();
            throwable.printStackTrace();
        }
    }

    public void start() {
        if (this.loaderThread == null) {
            this.loaderThread = new Thread(this);
            try {
                this.loaderThread.setPriority(1);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.loaderThread.start();
        }
        if (this.suspendableInputStream != null) {
            this.suspendableInputStream.resume();
        }
        if (this.isPlaying && this.player != null) {
            this.player.start();
        }
    }

    public void stop() {
        if (this.suspendableInputStream != null) {
            this.suspendableInputStream.suspend();
        }
        if (this.player != null) {
            this.isPlaying = this.player.isActive();
            this.player.stop();
        }
    }

    public void destroy() {
        if (this.suspendableInputStream != null) {
            this.suspendableInputStream.abort();
        }
        try {
            if (this.loaderThread != null) {
                this.loaderThread.interrupt();
                this.loaderThread = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.player != null) {
            this.player.stop();
            this.player = null;
        }
    }

    public String getAppletInfo() {
        return "ANIMApplet 3.4 2008-04-05 \u00a9 1999-2005 Werner Randelshofer, Staldenmattweg 2, CH-6405 Immensee, Switzerland";
    }

    public String[][] getParameterInfo() {
        return new String[][]{{"animSource", "URL", "Anim directory."}, {"animArchive", "URL", "Anim zip file."}, {"anim", "URL", "Anim file"}, {"boxMessage", "String", "Text shown in status bar while applet is being loaded."}, {"boxBgColor", "Color", "Background color, e.g. '#ffffff', '0xffffff', 'white', or '255,255,255'. Default depends on browser settings."}, {"boxFgColor", "Color", "Foreground color, e.g. '#000000', '0x000000', 'black', or '0,0,0'. Default depends on browser settings."}, {"renderAsTrueColor", "boolean", "Renders the animation using a 24 bit direct color model if set to 'true'. Default value is 'true'."}, {"image", "URL", "Image shown while applet is being loaded."}, {"scale", "float|'toFit'|'aspect'", "float: scale factor e.g. '2.0'=doubles the size. 'toFit' scales the animation to the bounding box of the view area. 'aspect' scales to fit while maintaining the aspect ratio. Default is 'tofit'."}, {"audio", "boolean", "'true' enables audio playback. Default is 'true'."}, {"framesPerSecond", "float", "Number of frames per second. '0' use animation settings. Default is '0'."}, {"playEveryFrame", "boolean", "'true' plays every frame of the animation. Default is 'false'."}, {"playWrapupFrames", "boolean", "'true' treats wrapup frames like regular frames. Default is 'false'."}, {"controller", "boolean", "'true' shows the controller. Default is 'true'."}, {"autoPlay", "boolean", "'true' starts playing after the animation has been loaded. Default is 'true'."}, {"loop", "boolean", "'true' makes the animation play continuously. Default is 'true'."}, {"pingPong", "boolean", "'true' makes the animation play forward and backwards. Default is 'false'."}, {"info", "boolean", "'true' Displays information about the animation. Default is 'false'"}, {"debug", "boolean", "'true' turns output of debugging info on. Default is 'false'."}};
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("cached")) {
            if (Applets.getParameter((Applet)this, "autoStart", true)) {
                this.player.start();
            }
            if (Applets.getParameter((Applet)this, "info", false)) {
                ANIMMovieTrack aNIMMovieTrack = this.player.getMovieTrack();
                double d = (double)aNIMMovieTrack.getXAspect() / (double)aNIMMovieTrack.getYAspect();
                Dimension dimension = new Dimension(aNIMMovieTrack.getWidth(), aNIMMovieTrack.getHeight());
                if (d > 1.0) {
                    dimension.width = (int)Math.floor((double)aNIMMovieTrack.getWidth() * d);
                } else {
                    dimension.height = (int)Math.ceil((double)aNIMMovieTrack.getHeight() / d);
                }
                Dimension dimension2 = this.getSize();
                String string = "Movie\n  Duration: " + (float)this.player.getTotalDuration() / 60.0f + "sec";
                if (this.getParameter("framesPerSecond") != null) {
                    string = string + " (" + (float)aNIMMovieTrack.getTotalDuration() / 60.0f + "sec)";
                }
                string = string + "\n  Jiffies: " + aNIMMovieTrack.getJiffies();
                string = string + "\n  Frame Count: " + aNIMMovieTrack.getFrameCount();
                if (Applets.getParameter((Applet)this, "playWrapupFrames", false)) {
                    string = string + " (" + (aNIMMovieTrack.getFrameCount() - 2) + ")";
                }
                if (aNIMMovieTrack.getProperty("copyright") != null) {
                    string = string + "\n  Copyright: \"" + aNIMMovieTrack.getProperty("copyright") + "\"";
                }
                if (aNIMMovieTrack.getProperty("author") != null) {
                    string = string + "\n  Author: \"" + aNIMMovieTrack.getProperty("author") + "\"";
                }
                if (aNIMMovieTrack.getProperty("annotation") != null) {
                    string = string + "\n  Annotation: \"" + aNIMMovieTrack.getProperty("annotation") + "\"";
                }
                string = string + "\nImage\n  Screen Mode: " + this.imagePanel.getImage().getProperty("screenMode", this) + "\n  Plane Count: " + aNIMMovieTrack.getNbPlanes() + "\n  Pixel Aspect x:" + aNIMMovieTrack.getXAspect() + " y:" + aNIMMovieTrack.getYAspect() + "\n  Size w:" + dimension2.width + " h:" + dimension2.height + " (w:" + aNIMMovieTrack.getWidth() + " h:" + aNIMMovieTrack.getHeight() + ")" + "\n  Aspect Corrected Size w:" + dimension.width + " h:" + dimension.height;
                if (aNIMMovieTrack.getAudioClipCount() > 0) {
                    string = string + "\n \nSound\n  Clip Count: " + aNIMMovieTrack.getAudioClipCount();
                }
                string = string + "\nANIMApplet 3.4 2008-04-05\n  Preferred Size w:" + this.getPreferredSize().width + " h:" + this.getPreferredSize().height;
                this.imagePanel.setMessage(string);
            }
        }
    }

    public void setMessage(String string) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        this.messages = new String[vector.size()];
        vector.copyInto(this.messages);
        this.repaint();
    }
}

