/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.gui;

import ch.randelshofer.gui.Icon;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.net.URL;

public class ImageIconAWT
implements Icon {
    transient Image image;
    transient int loadStatus = 0;
    ImageObserver imageObserver;
    protected static final Component component = new Component(){};
    protected static final MediaTracker tracker = new MediaTracker(component);
    private static int mediaTrackerID;
    int width = -1;
    int height = -1;

    public ImageIconAWT(String string) {
        this.image = Toolkit.getDefaultToolkit().getImage(string);
        if (this.image == null) {
            return;
        }
        this.loadImage(this.image);
    }

    public ImageIconAWT(URL uRL) {
        this.image = Toolkit.getDefaultToolkit().getImage(uRL);
        if (this.image == null) {
            return;
        }
        this.loadImage(this.image);
    }

    public ImageIconAWT(Image image) {
        this.image = image;
        this.loadImage(image);
    }

    public ImageIconAWT(byte[] byArray) {
        this.image = Toolkit.getDefaultToolkit().createImage(byArray);
        if (this.image == null) {
            return;
        }
        this.loadImage(this.image);
    }

    public ImageIconAWT() {
    }

    protected void loadImage(Image image) {
        int n = ++mediaTrackerID;
        tracker.addImage(image, n);
        try {
            tracker.waitForID(n, 0L);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("INTERRUPTED while loading Image");
        }
        this.loadStatus = tracker.statusID(n, false);
        tracker.removeImage(image, n);
        this.width = image.getWidth(this.imageObserver);
        this.height = image.getHeight(this.imageObserver);
    }

    public int getImageLoadStatus() {
        return this.loadStatus;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        this.loadImage(image);
    }

    public synchronized void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.imageObserver == null) {
            graphics.drawImage(this.image, n, n2, component);
        } else {
            graphics.drawImage(this.image, n, n2, this.imageObserver);
        }
    }

    public int getIconWidth() {
        return this.width;
    }

    public int getIconHeight() {
        return this.height;
    }

    public void setImageObserver(ImageObserver imageObserver) {
        this.imageObserver = imageObserver;
    }

    public ImageObserver getImageObserver() {
        return this.imageObserver;
    }
}

