/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.gui.image;

import ch.randelshofer.gui.image.HAMColorModel;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;

public class Bitmap
implements Cloneable {
    private byte[] bitmap_;
    private int width_;
    private int height_;
    private int depth_;
    private int bitplaneStride_;
    private int scanlineStride_;
    private ColorModel planarColorModel_;
    private ColorModel preferredChunkyColorModel_;
    private ColorModel currentChunkyColorModel_;
    private ColorModel lastPixelColorModel_;
    private int pixelType_;
    public static final int BYTE_PIXEL = 1;
    public static final int INT_PIXEL = 2;
    public static final int NO_PIXEL = 0;
    private byte[] bytePixels_;
    private int[] intPixels_;
    private boolean enforceDirectColors_ = false;

    public void setEnforceDirectColors(boolean bl) {
        this.enforceDirectColors_ = bl;
    }

    public boolean isEnforceDirectColors() {
        return this.enforceDirectColors_;
    }

    public Bitmap(int n, int n2, int n3, ColorModel colorModel) {
        this(n, n2, n3, colorModel, true);
    }

    public Bitmap(int n, int n2, int n3, ColorModel colorModel, boolean bl) {
        this.width_ = n;
        this.height_ = n2;
        this.depth_ = n3;
        this.planarColorModel_ = colorModel;
        if (bl) {
            this.bitplaneStride_ = (this.width_ + 15) / 16 * 2;
            this.scanlineStride_ = this.bitplaneStride_ * this.depth_;
            this.bitmap_ = new byte[this.scanlineStride_ * this.height_];
        } else {
            this.scanlineStride_ = (this.width_ + 15) / 16 * 2;
            this.bitplaneStride_ = this.scanlineStride_ * this.depth_;
            this.bitmap_ = new byte[this.bitplaneStride_ * this.height_];
        }
        this.pixelType_ = 0;
    }

    public Bitmap(int n, int n2, int n3, ColorModel colorModel, int n4, int n5) {
        this.width_ = n;
        this.height_ = n2;
        this.depth_ = n3;
        this.planarColorModel_ = colorModel;
        this.bitplaneStride_ = n4;
        this.scanlineStride_ = n5;
        this.bitmap_ = this.bitplaneStride_ < this.scanlineStride_ ? new byte[this.scanlineStride_ * this.height_] : new byte[this.bitplaneStride_ * this.height_];
        this.pixelType_ = 0;
    }

    public int getWidth() {
        return this.width_;
    }

    public int getHeight() {
        return this.height_;
    }

    public int getDepth() {
        return this.depth_;
    }

    public int getScanlineStride() {
        return this.scanlineStride_;
    }

    public int getBitplaneStride() {
        return this.bitplaneStride_;
    }

    public void setPlanarColorModel(ColorModel colorModel) {
        this.planarColorModel_ = colorModel;
    }

    public ColorModel getPlanarColorModel() {
        return this.planarColorModel_;
    }

    public void setPreferredChunkyColorModel(ColorModel colorModel) {
        this.preferredChunkyColorModel_ = colorModel;
    }

    public ColorModel getChunkyColorModel() {
        if (this.currentChunkyColorModel_ == null) {
            this.convertToChunky(0, 0, 0, 0);
        }
        return this.currentChunkyColorModel_;
    }

    public byte[] getBitmap() {
        return this.bitmap_;
    }

    public byte[] getBytePixels() {
        if (this.pixelType_ == 1) {
            return this.bytePixels_;
        }
        return null;
    }

    public int[] getIntPixels() {
        if (this.pixelType_ == 2) {
            return this.intPixels_;
        }
        return null;
    }

    public int getPixelType() {
        return this.pixelType_;
    }

    public Object clone() {
        try {
            Bitmap bitmap = (Bitmap)super.clone();
            bitmap.bitmap_ = (byte[])this.bitmap_.clone();
            if (this.getPixelType() == 1) {
                bitmap.bytePixels_ = (byte[])this.bytePixels_.clone();
            }
            if (this.getPixelType() == 2) {
                bitmap.intPixels_ = (int[])this.intPixels_.clone();
            }
            return bitmap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public int convertToChunky() {
        return this.convertToChunky(0, 0, this.getHeight() - 1, this.getWidth() - 1);
    }

    public int convertToChunky(int n, int n2, int n3, int n4) {
        this.pixelType_ = 0;
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 > this.getHeight() - 1) {
            n3 = this.getHeight() - 1;
        }
        if (n4 > this.getWidth() - 1) {
            n4 = this.getWidth() - 1;
        }
        if (this.planarColorModel_ instanceof HAMColorModel) {
            if (this.intPixels_ == null || this.intPixels_.length != this.getWidth() * this.getHeight()) {
                this.bytePixels_ = null;
                this.intPixels_ = new int[this.getWidth() * this.getHeight()];
            }
            this.currentChunkyColorModel_ = this.planarColorModel_;
            if (((HAMColorModel)this.planarColorModel_).getHAMType() == 6) {
                this.ham6PlanesToDirectPixels(n, n2, n3, n4);
            } else if (((HAMColorModel)this.planarColorModel_).getHAMType() == 8) {
                this.ham8PlanesToDirectPixels(n, n2, n3, n4);
            } else {
                throw new InternalError("unsupported ham model:" + this.planarColorModel_);
            }
            this.pixelType_ = 2;
        } else if (this.planarColorModel_ instanceof IndexColorModel) {
            if (this.enforceDirectColors_ || this.preferredChunkyColorModel_ instanceof DirectColorModel) {
                if (this.intPixels_ == null || this.intPixels_.length != this.getWidth() * this.getHeight()) {
                    this.bytePixels_ = null;
                    this.intPixels_ = new int[this.getWidth() * this.getHeight()];
                }
                this.currentChunkyColorModel_ = this.preferredChunkyColorModel_ != null && this.preferredChunkyColorModel_ instanceof DirectColorModel ? this.preferredChunkyColorModel_ : ColorModel.getRGBdefault();
                this.currentChunkyColorModel_ = new DirectColorModel(24, 0xFF0000, 65280, 255);
                this.indexPlanesToDirectPixels(n, n2, n3, n4);
                this.pixelType_ = 2;
            } else {
                if (this.bytePixels_ == null || this.bytePixels_.length != this.getWidth() * this.getHeight()) {
                    this.intPixels_ = null;
                    this.bytePixels_ = new byte[this.getWidth() * this.getHeight()];
                }
                this.currentChunkyColorModel_ = this.planarColorModel_;
                this.indexPlanesToIndexPixels(n, n2, n3, n4);
                this.pixelType_ = 1;
            }
        } else if (this.planarColorModel_ instanceof DirectColorModel) {
            if (this.intPixels_ == null || this.intPixels_.length != this.getWidth() * this.getHeight()) {
                this.bytePixels_ = null;
                this.intPixels_ = new int[this.getWidth() * this.getHeight()];
            }
            this.currentChunkyColorModel_ = this.planarColorModel_;
            this.directPlanesToDirectPixels(n, n2, n3, n4);
            this.pixelType_ = 2;
        } else {
            throw new InternalError("unsupported color model:" + this.planarColorModel_);
        }
        return this.pixelType_;
    }

    public void flushPixels() {
        this.pixelType_ = 0;
        this.intPixels_ = null;
        this.bytePixels_ = null;
    }

    private void indexPlanesToIndexPixels(int n, int n2, int n3, int n4) {
        ++n3;
        int n5 = this.getScanlineStride();
        int n6 = this.getBitplaneStride();
        int n7 = this.getDepth();
        int n8 = this.getWidth();
        int n9 = n8 - ++n4 + n2;
        int n10 = n3 * n5;
        int n11 = n * n8 + n2;
        int n12 = 0;
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        byte by5 = 0;
        byte by6 = 0;
        byte by7 = 0;
        byte by8 = 0;
        int n13 = n6;
        int n14 = n6 * 2;
        int n15 = n6 * 3;
        int n16 = n6 * 4;
        int n17 = n6 * 5;
        int n18 = n6 * 6;
        int n19 = n6 * 7;
        switch (n7) {
            case 1: {
                for (int i = n * n5; i < n10; i += n5) {
                    for (int j = n2; j < n4; ++j) {
                        this.bytePixels_[n11++] = (byte)((this.bitmap_[i + (j >>> 3)] << (j & 7) & 0x80) >>> 7);
                    }
                    n11 += n9;
                }
                break;
            }
            case 2: {
                for (int i = n * n5; i < n10; i += n5) {
                    for (int j = n2; j < n4; ++j) {
                        int n20 = j & 7;
                        int n21 = 128 >>> n20;
                        int n22 = i + (j >>> 3);
                        this.bytePixels_[n11++] = (byte)((this.bitmap_[n22] & n21 | (this.bitmap_[n22 + n13] & n21) << 1) >>> 7 - n20);
                    }
                    n11 += n9;
                }
                break;
            }
            case 3: {
                for (int i = n * n5; i < n10; i += n5) {
                    for (int j = n2; j < n4; ++j) {
                        int n23 = j & 7;
                        int n24 = 128 >>> n23;
                        int n25 = i + (j >>> 3);
                        this.bytePixels_[n11++] = (byte)((this.bitmap_[n25] & n24 | (this.bitmap_[n25 + n13] & n24) << 1 | (this.bitmap_[n25 + n14] & n24) << 2) >>> 7 - n23);
                    }
                    n11 += n9;
                }
                break;
            }
            case 4: {
                for (int i = n * n5; i < n10; i += n5) {
                    for (int j = n2; j < n4; ++j) {
                        int n26 = j & 7;
                        int n27 = 128 >>> n26;
                        int n28 = i + (j >>> 3);
                        this.bytePixels_[n11++] = (byte)((this.bitmap_[n28] & n27 | (this.bitmap_[n28 + n13] & n27) << 1 | (this.bitmap_[n28 + n14] & n27) << 2 | (this.bitmap_[n28 + n15] & n27) << 3) >>> 7 - n26);
                    }
                    n11 += n9;
                }
                break;
            }
            case 5: {
                for (int i = n * n5; i < n10; i += n5) {
                    for (int j = n2; j < n4; ++j) {
                        int n29 = j & 7;
                        int n30 = 128 >>> n29;
                        int n31 = i + (j >>> 3);
                        if (n29 == 0) {
                            by8 = this.bitmap_[n31];
                            by7 = this.bitmap_[n31 + n6];
                            by6 = this.bitmap_[n31 + n14];
                            by5 = this.bitmap_[n31 + n15];
                            by4 = this.bitmap_[n31 + n16];
                        }
                        this.bytePixels_[n11++] = (byte)((by8 & n30 | (by7 & n30) << 1 | (by6 & n30) << 2 | (by5 & n30) << 3 | (by4 & n30) << 4) >>> 7 - n29);
                    }
                    n11 += n9;
                }
                break;
            }
            case 6: {
                for (int i = n * n5; i < n10; i += n5) {
                    for (int j = n2; j < n4; ++j) {
                        int n32 = j & 7;
                        int n33 = 128 >>> n32;
                        int n34 = i + (j >>> 3);
                        if (n32 == 0) {
                            by8 = this.bitmap_[n34];
                            by7 = this.bitmap_[n34 + n6];
                            by6 = this.bitmap_[n34 + n14];
                            by5 = this.bitmap_[n34 + n15];
                            by4 = this.bitmap_[n34 + n16];
                            by3 = this.bitmap_[n34 + n17];
                        }
                        this.bytePixels_[n11++] = (byte)((by8 & n33 | (by7 & n33) << 1 | (by6 & n33) << 2 | (by5 & n33) << 3 | (by4 & n33) << 4 | (by3 & n33) << 5) >>> 7 - n32);
                    }
                    n11 += n9;
                }
                break;
            }
            case 7: {
                for (int i = n * n5; i < n10; i += n5) {
                    for (int j = n2; j < n4; ++j) {
                        int n35 = j & 7;
                        int n36 = 128 >>> n35;
                        int n37 = i + (j >>> 3);
                        if (n35 == 0) {
                            by8 = this.bitmap_[n37];
                            by7 = this.bitmap_[n37 + n6];
                            by6 = this.bitmap_[n37 + n14];
                            by5 = this.bitmap_[n37 + n15];
                            by4 = this.bitmap_[n37 + n16];
                            by3 = this.bitmap_[n37 + n17];
                            by2 = this.bitmap_[n37 + n18];
                        }
                        this.bytePixels_[n11++] = (byte)((by8 & n36 | (by7 & n36) << 1 | (by6 & n36) << 2 | (by5 & n36) << 3 | (by4 & n36) << 4 | (by3 & n36) << 5 | (by2 & n36) << 6) >>> 7 - n35);
                    }
                    n11 += n9;
                }
                break;
            }
            case 8: {
                for (int i = n * n5; i < n10; i += n5) {
                    for (int j = n2; j < n4; ++j) {
                        int n38 = j & 7;
                        int n39 = 128 >>> n38;
                        int n40 = i + (j >>> 3);
                        if (n38 == 0) {
                            by8 = this.bitmap_[n40];
                            by7 = this.bitmap_[n40 + n6];
                            by6 = this.bitmap_[n40 + n14];
                            by5 = this.bitmap_[n40 + n15];
                            by4 = this.bitmap_[n40 + n16];
                            by3 = this.bitmap_[n40 + n17];
                            by2 = this.bitmap_[n40 + n18];
                            by = this.bitmap_[n40 + n19];
                        }
                        this.bytePixels_[n11++] = (byte)((by8 & n39 | (by7 & n39) << 1 | (by6 & n39) << 2 | (by5 & n39) << 3 | (by4 & n39) << 4 | (by3 & n39) << 5 | (by2 & n39) << 6 | (by & n39) << 7) >>> 7 - n38);
                    }
                    n11 += n9;
                }
                break;
            }
            default: {
                for (int i = n * n5 + n5; i <= n10; i += n5) {
                    for (int j = n2; j < n4; ++j) {
                        int n41 = j & 7;
                        int n42 = 128 >>> n41;
                        int n43 = i + (j >>> 3);
                        n12 = 0;
                        for (int k = 0; k < n7; ++k) {
                            n12 = n12 << 1 | this.bitmap_[n43 -= n6] & n42;
                        }
                        this.bytePixels_[n11++] = (byte)(n12 >>> 7 - n41);
                    }
                    n11 += n9;
                }
            }
        }
    }

    private void indexPlanesToDirectPixels(int n, int n2, int n3, int n4) {
        int n5;
        IndexColorModel indexColorModel = (IndexColorModel)this.planarColorModel_;
        int[] nArray = new int[indexColorModel.getMapSize()];
        IndexColorModel indexColorModel2 = (IndexColorModel)this.planarColorModel_;
        byte[] byArray = new byte[nArray.length];
        byte[] byArray2 = new byte[nArray.length];
        byte[] byArray3 = new byte[nArray.length];
        indexColorModel2.getReds(byArray);
        indexColorModel2.getGreens(byArray2);
        indexColorModel2.getBlues(byArray3);
        for (n5 = 0; n5 < nArray.length; ++n5) {
            nArray[n5] = 0xFF000000 | (byArray[n5] & 0xFF) << 16 | (byArray2[n5] & 0xFF) << 8 | byArray3[n5] & 0xFF;
        }
        if (nArray.length < 1 << this.getDepth()) {
            throw new IndexOutOfBoundsException("Clut must not be smaller than depth");
        }
        ++n3;
        n5 = this.getScanlineStride();
        int n6 = this.getBitplaneStride();
        int n7 = this.getDepth();
        int n8 = this.getWidth();
        int n9 = n8 - ++n4 + n2;
        int n10 = n3 * n5;
        int n11 = n * n8 + n2;
        int n12 = 0;
        int n13 = n6;
        int n14 = n6 * 2;
        int n15 = n6 * 3;
        int n16 = n6 * 4;
        int n17 = n6 * 5;
        int n18 = n6 * 6;
        int n19 = n6 * 7;
        byte by = 0;
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        byte by5 = 0;
        byte by6 = 0;
        byte by7 = 0;
        byte by8 = 0;
        switch (n7) {
            case 1: {
                for (int i = n * n5; i < n10; i += n5) {
                    for (int j = n2; j < n4; ++j) {
                        this.intPixels_[n11++] = nArray[(this.bitmap_[i + (j >>> 3)] << (j & 7) & 0x80) >>> 7];
                    }
                    n11 += n9;
                }
                break;
            }
            case 2: {
                for (int i = n * n5; i < n10; i += n5) {
                    for (int j = n2; j < n4; ++j) {
                        int n20 = j & 7;
                        int n21 = 128 >>> n20;
                        int n22 = i + (j >>> 3);
                        this.intPixels_[n11++] = nArray[(this.bitmap_[n22] & n21 | (this.bitmap_[n22 + n13] & n21) << 1) >>> 7 - n20];
                    }
                    n11 += n9;
                }
                break;
            }
            case 3: {
                for (int i = n * n5; i < n10; i += n5) {
                    for (int j = n2; j < n4; ++j) {
                        int n23 = j & 7;
                        int n24 = 128 >>> n23;
                        int n25 = i + (j >>> 3);
                        this.intPixels_[n11++] = nArray[(this.bitmap_[n25] & n24 | (this.bitmap_[n25 + n13] & n24) << 1 | (this.bitmap_[n25 + n14] & n24) << 2) >>> 7 - n23];
                    }
                    n11 += n9;
                }
                break;
            }
            case 4: {
                for (int i = n * n5; i < n10; i += n5) {
                    for (int j = n2; j < n4; ++j) {
                        int n26 = j & 7;
                        int n27 = 128 >>> n26;
                        int n28 = i + (j >>> 3);
                        this.intPixels_[n11++] = nArray[(this.bitmap_[n28] & n27 | (this.bitmap_[n28 + n13] & n27) << 1 | (this.bitmap_[n28 + n14] & n27) << 2 | (this.bitmap_[n28 + n15] & n27) << 3) >>> 7 - n26];
                    }
                    n11 += n9;
                }
                break;
            }
            case 5: {
                for (int i = n * n5; i < n10; i += n5) {
                    for (int j = n2; j < n4; ++j) {
                        int n29 = j & 7;
                        int n30 = 128 >>> n29;
                        int n31 = i + (j >>> 3);
                        if (n29 == 0) {
                            by8 = this.bitmap_[n31];
                            by7 = this.bitmap_[n31 + n6];
                            by6 = this.bitmap_[n31 + n14];
                            by5 = this.bitmap_[n31 + n15];
                            by4 = this.bitmap_[n31 + n16];
                        }
                        this.intPixels_[n11++] = nArray[(by8 & n30 | (by7 & n30) << 1 | (by6 & n30) << 2 | (by5 & n30) << 3 | (by4 & n30) << 4) >>> 7 - n29];
                    }
                    n11 += n9;
                }
                break;
            }
            case 6: {
                for (int i = n * n5; i < n10; i += n5) {
                    for (int j = n2; j < n4; ++j) {
                        int n32 = j & 7;
                        int n33 = 128 >>> n32;
                        int n34 = i + (j >>> 3);
                        if (n32 == 0) {
                            by8 = this.bitmap_[n34];
                            by7 = this.bitmap_[n34 + n6];
                            by6 = this.bitmap_[n34 + n14];
                            by5 = this.bitmap_[n34 + n15];
                            by4 = this.bitmap_[n34 + n16];
                            by3 = this.bitmap_[n34 + n17];
                        }
                        this.intPixels_[n11++] = nArray[(by8 & n33 | (by7 & n33) << 1 | (by6 & n33) << 2 | (by5 & n33) << 3 | (by4 & n33) << 4 | (by3 & n33) << 5) >>> 7 - n32];
                    }
                    n11 += n9;
                }
                break;
            }
            case 7: {
                for (int i = n * n5; i < n10; i += n5) {
                    for (int j = n2; j < n4; ++j) {
                        int n35 = j & 7;
                        int n36 = 128 >>> n35;
                        int n37 = i + (j >>> 3);
                        if (n35 == 0) {
                            by8 = this.bitmap_[n37];
                            by7 = this.bitmap_[n37 + n6];
                            by6 = this.bitmap_[n37 + n14];
                            by5 = this.bitmap_[n37 + n15];
                            by4 = this.bitmap_[n37 + n16];
                            by3 = this.bitmap_[n37 + n17];
                            by2 = this.bitmap_[n37 + n18];
                        }
                        this.intPixels_[n11++] = nArray[(by8 & n36 | (by7 & n36) << 1 | (by6 & n36) << 2 | (by5 & n36) << 3 | (by4 & n36) << 4 | (by3 & n36) << 5 | (by2 & n36) << 6) >>> 7 - n35];
                    }
                    n11 += n9;
                }
                break;
            }
            case 8: {
                for (int i = n * n5; i < n10; i += n5) {
                    for (int j = n2; j < n4; ++j) {
                        int n38 = j & 7;
                        int n39 = 128 >>> n38;
                        int n40 = i + (j >>> 3);
                        if (n38 == 0) {
                            by8 = this.bitmap_[n40];
                            by7 = this.bitmap_[n40 + n6];
                            by6 = this.bitmap_[n40 + n14];
                            by5 = this.bitmap_[n40 + n15];
                            by4 = this.bitmap_[n40 + n16];
                            by3 = this.bitmap_[n40 + n17];
                            by2 = this.bitmap_[n40 + n18];
                            by = this.bitmap_[n40 + n19];
                        }
                        this.intPixels_[n11++] = nArray[(by8 & n39 | (by7 & n39) << 1 | (by6 & n39) << 2 | (by5 & n39) << 3 | (by4 & n39) << 4 | (by3 & n39) << 5 | (by2 & n39) << 6 | (by & n39) << 7) >>> 7 - n38];
                    }
                    n11 += n9;
                }
                break;
            }
            default: {
                for (int i = n * n5 + n5; i <= n10; i += n5) {
                    for (int j = n2; j < n4; ++j) {
                        int n41 = j & 7;
                        int n42 = 128 >>> n41;
                        int n43 = i + (j >>> 3);
                        n12 = 0;
                        for (int k = 0; k < n7; ++k) {
                            n12 = n12 << 1 | this.bitmap_[n43 -= n6] & n42;
                        }
                        this.intPixels_[n11++] = nArray[n12 >>> 7 - n41];
                    }
                    n11 += n9;
                }
            }
        }
    }

    private void directPlanesToDirectPixels(int n, int n2, int n3, int n4) {
        ++n3;
        int n5 = this.getScanlineStride();
        int n6 = this.getBitplaneStride();
        int n7 = this.getDepth();
        int n8 = this.getWidth();
        int n9 = n8 - ++n4 + n2;
        int n10 = n3 * n5;
        int n11 = n * n8 + n2;
        boolean bl = false;
        int n12 = n6 * 2;
        int n13 = n6 * 3;
        int n14 = n6 * 4;
        int n15 = n6 * 5;
        int n16 = n6 * 6;
        int n17 = n6 * 7;
        int n18 = n6 * 8;
        int n19 = n6 * 9;
        int n20 = n6 * 10;
        int n21 = n6 * 11;
        int n22 = n6 * 12;
        int n23 = n6 * 13;
        int n24 = n6 * 14;
        int n25 = n6 * 15;
        int n26 = n6 * 16;
        int n27 = n6 * 17;
        int n28 = n6 * 18;
        int n29 = n6 * 19;
        int n30 = n6 * 20;
        int n31 = n6 * 21;
        int n32 = n6 * 22;
        int n33 = n6 * 23;
        int n34 = n * n5 + n2 / 8;
        byte by = this.bitmap_[n34];
        byte by2 = this.bitmap_[n34 + n6];
        byte by3 = this.bitmap_[n34 + n12];
        byte by4 = this.bitmap_[n34 + n14];
        byte by5 = this.bitmap_[n34 + n14];
        byte by6 = this.bitmap_[n34 + n15];
        byte by7 = this.bitmap_[n34 + n16];
        byte by8 = this.bitmap_[n34 + n17];
        byte by9 = this.bitmap_[n34 + n18];
        byte by10 = this.bitmap_[n34 + n19];
        byte by11 = this.bitmap_[n34 + n20];
        byte by12 = this.bitmap_[n34 + n21];
        byte by13 = this.bitmap_[n34 + n22];
        byte by14 = this.bitmap_[n34 + n23];
        byte by15 = this.bitmap_[n34 + n24];
        byte by16 = this.bitmap_[n34 + n25];
        byte by17 = this.bitmap_[n34 + n26];
        byte by18 = this.bitmap_[n34 + n27];
        byte by19 = this.bitmap_[n34 + n28];
        byte by20 = this.bitmap_[n34 + n29];
        byte by21 = this.bitmap_[n34 + n30];
        byte by22 = this.bitmap_[n34 + n31];
        byte by23 = this.bitmap_[n34 + n32];
        byte by24 = this.bitmap_[n34 + n33];
        for (int i = n * n5; i < n10; i += n5) {
            for (int j = n2; j < n4; ++j) {
                int n35 = j & 7;
                int n36 = 128 >>> n35;
                n34 = i + (j >>> 3);
                if (n35 == 0) {
                    by = this.bitmap_[n34];
                    by2 = this.bitmap_[n34 + n6];
                    by3 = this.bitmap_[n34 + n12];
                    by4 = this.bitmap_[n34 + n13];
                    by5 = this.bitmap_[n34 + n14];
                    by6 = this.bitmap_[n34 + n15];
                    by7 = this.bitmap_[n34 + n16];
                    by8 = this.bitmap_[n34 + n17];
                    by9 = this.bitmap_[n34 + n18];
                    by10 = this.bitmap_[n34 + n19];
                    by11 = this.bitmap_[n34 + n20];
                    by12 = this.bitmap_[n34 + n21];
                    by13 = this.bitmap_[n34 + n22];
                    by14 = this.bitmap_[n34 + n23];
                    by15 = this.bitmap_[n34 + n24];
                    by16 = this.bitmap_[n34 + n25];
                    by17 = this.bitmap_[n34 + n26];
                    by18 = this.bitmap_[n34 + n27];
                    by19 = this.bitmap_[n34 + n28];
                    by20 = this.bitmap_[n34 + n29];
                    by21 = this.bitmap_[n34 + n30];
                    by22 = this.bitmap_[n34 + n31];
                    by23 = this.bitmap_[n34 + n32];
                    by24 = this.bitmap_[n34 + n33];
                }
                this.intPixels_[n11++] = ((by & n36) << 16 | (by2 & n36) << 17 | (by3 & n36) << 18 | (by4 & n36) << 19 | (by5 & n36) << 20 | (by6 & n36) << 21 | (by7 & n36) << 22 | (by8 & n36) << 23 | (by9 & n36) << 8 | (by10 & n36) << 9 | (by11 & n36) << 10 | (by12 & n36) << 11 | (by13 & n36) << 12 | (by14 & n36) << 13 | (by15 & n36) << 14 | (by16 & n36) << 15 | by17 & n36 | (by18 & n36) << 1 | (by19 & n36) << 2 | (by20 & n36) << 3 | (by21 & n36) << 4 | (by22 & n36) << 5 | (by23 & n36) << 6 | (by24 & n36) << 7) >>> 7 - n35;
            }
            n11 += n9;
        }
    }

    private void ham6PlanesToDirectPixels(int n, int n2, int n3, int n4) {
        ++n3;
        ++n4;
        int[] nArray = new int[((HAMColorModel)this.planarColorModel_).getMapSize()];
        ((HAMColorModel)this.planarColorModel_).getRGBs(nArray);
        int n5 = this.getScanlineStride();
        int n6 = this.getBitplaneStride();
        int n7 = this.getDepth();
        int n8 = this.getWidth();
        int n9 = n8 - n4 + n2;
        int n10 = n3 * n5;
        int n11 = n * n8 + n2;
        int n12 = n * n8 + n2 - 1;
        int n13 = 0;
        int n14 = n6;
        int n15 = n6 * 2;
        int n16 = n6 * 3;
        int n17 = n6 * 4;
        int n18 = n6 * 5;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        int n22 = 0;
        int n23 = 0;
        int n24 = 0;
        for (int i = n * n5; i < n10; i += n5) {
            int n25;
            if (n2 == 0) {
                n25 = -16777216;
            } else {
                n25 = this.intPixels_[n12];
                n12 += n8;
            }
            block6: for (int j = n2; j < n4; ++j) {
                int n26 = j & 7;
                int n27 = 128 >>> n26;
                int n28 = i + (j >>> 3);
                if (n26 == 0) {
                    n24 = this.bitmap_[n28];
                    n23 = this.bitmap_[n28 + n6];
                    n22 = this.bitmap_[n28 + n15];
                    n21 = this.bitmap_[n28 + n16];
                    n20 = this.bitmap_[n28 + n17];
                    n19 = this.bitmap_[n28 + n18];
                }
                n13 = (n24 & n27 | (n23 & n27) << 1 | (n22 & n27) << 2 | (n21 & n27) << 3) >>> 7 - n26;
                switch ((n20 & n27 | (n19 & n27) << 1) >>> 7 - n26) {
                    case 0: {
                        this.intPixels_[n11++] = n25 = nArray[n13];
                        continue block6;
                    }
                    case 1: {
                        this.intPixels_[n11++] = n25 = n25 & 0xFFFFFF00 | n13 | n13 << 4;
                        continue block6;
                    }
                    case 2: {
                        this.intPixels_[n11++] = n25 = n25 & 0xFF00FFFF | n13 << 16 | n13 << 20;
                        continue block6;
                    }
                    default: {
                        this.intPixels_[n11++] = n25 = n25 & 0xFFFF00FF | n13 << 8 | n13 << 12;
                    }
                }
            }
            n11 += n9;
        }
    }

    private void ham8PlanesToDirectPixels(int n, int n2, int n3, int n4) {
        ++n3;
        ++n4;
        int[] nArray = new int[((HAMColorModel)this.planarColorModel_).getMapSize()];
        ((HAMColorModel)this.planarColorModel_).getRGBs(nArray);
        int n5 = this.getScanlineStride();
        int n6 = this.getBitplaneStride();
        int n7 = this.getDepth();
        int n8 = this.getWidth();
        int n9 = n8 - n4 + n2;
        int n10 = n3 * n5;
        int n11 = n * n8 + n2;
        int n12 = n * n8 + n2 - 1;
        int n13 = 0;
        int n14 = n6;
        int n15 = n6 * 2;
        int n16 = n6 * 3;
        int n17 = n6 * 4;
        int n18 = n6 * 5;
        int n19 = n6 * 6;
        int n20 = n6 * 7;
        int n21 = n * n5 + n2 / 8;
        int n22 = 0;
        int n23 = 0;
        int n24 = 0;
        int n25 = 0;
        int n26 = 0;
        int n27 = 0;
        int n28 = 0;
        int n29 = 0;
        for (int i = n * n5; i < n10; i += n5) {
            int n30;
            if (n2 == 0) {
                n30 = -16777216;
            } else {
                n30 = this.intPixels_[n12];
                n12 += n8;
            }
            block6: for (int j = n2; j < n4; ++j) {
                int n31 = j & 7;
                int n32 = 128 >>> n31;
                n21 = i + (j >>> 3);
                if (n31 == 0) {
                    n29 = this.bitmap_[n21];
                    n28 = this.bitmap_[n21 + n6];
                    n27 = this.bitmap_[n21 + n15];
                    n26 = this.bitmap_[n21 + n16];
                    n25 = this.bitmap_[n21 + n17];
                    n24 = this.bitmap_[n21 + n18];
                    n23 = this.bitmap_[n21 + n19];
                    n22 = this.bitmap_[n21 + n20];
                }
                n13 = (n29 & n32 | (n28 & n32) << 1 | (n27 & n32) << 2 | (n26 & n32) << 3 | (n25 & n32) << 4 | (n24 & n32) << 5) >>> 7 - n31;
                switch ((n23 & n32 | (n22 & n32) << 1) >>> 7 - n31) {
                    case 0: {
                        this.intPixels_[n11++] = n30 = nArray[n13];
                        continue block6;
                    }
                    case 1: {
                        this.intPixels_[n11++] = n30 = n30 & 0xFFFFFF00 | n13 << 2 | n13 >>> 4;
                        continue block6;
                    }
                    case 2: {
                        this.intPixels_[n11++] = n30 = n30 & 0xFF00FFFF | n13 << 18 | (n13 & 3) << 16;
                        continue block6;
                    }
                    default: {
                        this.intPixels_[n11++] = n30 = n30 & 0xFFFF00FF | n13 << 10 | (n13 & 3) << 8;
                    }
                }
            }
            n11 += n9;
        }
    }
}

