/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.iff;

import ch.randelshofer.iff.IFFParser;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class IFFChunk {
    private int id_;
    private int type_;
    private long size_;
    private long scan_;
    private byte[] data_;
    private Hashtable propertyChunks_;
    private Vector collectionChunks_;

    public IFFChunk(int n, int n2) {
        this.id_ = n2;
        this.type_ = n;
        this.size_ = -1L;
        this.scan_ = -1L;
    }

    public IFFChunk(int n, int n2, long l, long l2) {
        this.id_ = n2;
        this.type_ = n;
        this.size_ = l;
        this.scan_ = l2;
    }

    public IFFChunk(int n, int n2, long l, long l2, IFFChunk iFFChunk) {
        this.id_ = n2;
        this.type_ = n;
        this.size_ = l;
        this.scan_ = l2;
        if (iFFChunk != null) {
            if (iFFChunk.propertyChunks_ != null) {
                this.propertyChunks_ = (Hashtable)iFFChunk.propertyChunks_.clone();
            }
            if (iFFChunk.collectionChunks_ != null) {
                this.collectionChunks_ = (Vector)iFFChunk.collectionChunks_.clone();
            }
        }
    }

    public int getID() {
        return this.id_;
    }

    public int getType() {
        return this.type_;
    }

    public long getSize() {
        return this.size_;
    }

    public long getScan() {
        return this.scan_;
    }

    public void putPropertyChunk(IFFChunk iFFChunk) {
        if (this.propertyChunks_ == null) {
            this.propertyChunks_ = new Hashtable();
        }
        this.propertyChunks_.put(iFFChunk, iFFChunk);
    }

    public IFFChunk getPropertyChunk(int n) {
        if (this.propertyChunks_ == null) {
            return null;
        }
        IFFChunk iFFChunk = new IFFChunk(this.type_, n);
        return (IFFChunk)this.propertyChunks_.get(iFFChunk);
    }

    public Enumeration propertyChunks() {
        if (this.propertyChunks_ == null) {
            this.propertyChunks_ = new Hashtable();
        }
        return this.propertyChunks_.keys();
    }

    public void addCollectionChunk(IFFChunk iFFChunk) {
        if (this.collectionChunks_ == null) {
            this.collectionChunks_ = new Vector();
        }
        this.collectionChunks_.addElement(iFFChunk);
    }

    public IFFChunk[] getCollectionChunks(int n) {
        IFFChunk[] iFFChunkArray;
        if (this.collectionChunks_ == null) {
            return new IFFChunk[0];
        }
        Enumeration enumeration = this.collectionChunks_.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            iFFChunkArray = (IFFChunk)enumeration.nextElement();
            if (iFFChunkArray.id_ != n) continue;
            ++n2;
        }
        iFFChunkArray = new IFFChunk[n2];
        n2 = 0;
        enumeration = this.collectionChunks_.elements();
        while (enumeration.hasMoreElements()) {
            IFFChunk iFFChunk = (IFFChunk)enumeration.nextElement();
            if (iFFChunk.id_ != n) continue;
            iFFChunkArray[n2++] = iFFChunk;
        }
        return iFFChunkArray;
    }

    public Enumeration collectionChunks() {
        if (this.collectionChunks_ == null) {
            this.collectionChunks_ = new Vector();
        }
        return this.collectionChunks_.elements();
    }

    public void setData(byte[] byArray) {
        this.data_ = byArray;
    }

    public byte[] getData() {
        return this.data_;
    }

    public boolean equals(Object object) {
        if (object instanceof IFFChunk) {
            IFFChunk iFFChunk = (IFFChunk)object;
            return iFFChunk.id_ == this.id_ && iFFChunk.type_ == this.type_;
        }
        return false;
    }

    public int hashCode() {
        return this.id_;
    }

    public String toString() {
        return super.toString() + "{" + IFFParser.idToString(this.getType()) + "," + IFFParser.idToString(this.getID()) + "}";
    }
}

