/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.iff;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MC68000InputStream
extends FilterInputStream {
    private long scan_;
    private long mark_;

    public MC68000InputStream(InputStream inputStream) {
        super(inputStream);
    }

    public int readUBYTE() throws IOException {
        int n = this.in.read();
        if (n == -1) {
            throw new EOFException();
        }
        ++this.scan_;
        return n & 0xFF;
    }

    public short readWORD() throws IOException {
        int n = this.in.read();
        int n2 = this.in.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        this.scan_ += 2L;
        return (short)((n & 0xFF) << 8 | n2 & 0xFF);
    }

    public int readUWORD() throws IOException {
        return this.readWORD() & 0xFFFF;
    }

    public int readLONG() throws IOException {
        int n = this.in.read();
        int n2 = this.in.read();
        int n3 = this.in.read();
        int n4 = this.in.read();
        if (n4 == -1) {
            throw new EOFException();
        }
        this.scan_ += 4L;
        return (n & 0xFF) << 24 | (n2 & 0xFF) << 16 | (n3 & 0xFF) << 8 | n4 & 0xFF;
    }

    public long readULONG() throws IOException {
        return (long)this.readLONG() & 0xFFFFFFFFFFFFFFFFL;
    }

    public void align() throws IOException {
        if (this.scan_ % 2L == 1L) {
            this.in.skip(1L);
            ++this.scan_;
        }
    }

    public long getScan() {
        return this.scan_;
    }

    public int read() throws IOException {
        int n = this.in.read();
        ++this.scan_;
        return n;
    }

    public int readFully(byte[] byArray, int n, int n2) throws IOException {
        return this.read(byArray, n, n2);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        for (n3 = 0; n3 < n2; n3 += this.in.read(byArray, n + n3, n2 - n3)) {
        }
        this.scan_ += (long)n3;
        return n3;
    }

    public void mark(int n) {
        this.in.mark(n);
        this.mark_ = this.scan_;
    }

    public void reset() throws IOException {
        this.in.reset();
        this.scan_ = this.mark_;
    }

    public long skip(long l) throws IOException {
        long l2 = this.in.skip(l);
        this.scan_ += l2;
        return l2;
    }

    public void skipFully(long l) throws IOException {
        int n = 0;
        int n2 = 0;
        while ((long)n < l && (n2 = (int)this.in.skip(l - (long)n)) > 0) {
            n += n2;
        }
        if (n2 == 0) {
            throw new EOFException();
        }
        this.scan_ += (long)n;
    }
}

