/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.media.anim;

import ch.randelshofer.media.anim.ANIMMovieTrack;
import ch.randelshofer.media.eightsvx.EightSVXAudioClip;
import ch.randelshofer.media.eightsvx.LoopableAudioClip;

public class ANIMAudioCommand {
    public static final int COMMAND_PLAY_SOUND = 1;
    public static final int COMMAND_STOP_SOUND = 2;
    public static final int COMMAND_SET_FREQVOL = 3;
    public static final int FLAG_NO_INTERRUPT = 1;
    private int command;
    private int volume;
    private int sound;
    private int repeats;
    private int channelMask;
    private static final int CHANNEL0_MASK = 1;
    private static final int CHANNEL1_MASK = 2;
    private static final int CHANNEL2_MASK = 4;
    private static final int CHANNEL3_MASK = 8;
    private static final int CHANNEL_LEFT_MASK = 5;
    private static final int CHANNEL_RIGHT_MASK = 10;
    private int frequency;
    private int flags;
    private int activeChannelMask;
    private LoopableAudioClip audioClip;

    public ANIMAudioCommand(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.command = n;
        this.volume = n2;
        this.sound = n3;
        this.repeats = n4;
        this.channelMask = n5;
        this.frequency = n6;
        this.flags = n7;
    }

    public int getChannelMask() {
        return this.channelMask;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public int getSound() {
        return this.sound;
    }

    public int getVolume() {
        return this.volume;
    }

    public int getCommand() {
        return this.command;
    }

    public void prepare(ANIMMovieTrack aNIMMovieTrack) {
        if (this.command == 1 && this.audioClip == null) {
            float f = (this.channelMask & 5) != 0 && (this.channelMask & 0xA) == 0 ? -1.0f : ((this.channelMask & 0xA) != 0 && (this.channelMask & 5) == 0 ? 1.0f : 0.0f);
            EightSVXAudioClip eightSVXAudioClip = (EightSVXAudioClip)aNIMMovieTrack.getAudioClip(this.sound - 1);
            this.audioClip = eightSVXAudioClip.createAudioClip(this.frequency == 0 ? eightSVXAudioClip.getSampleRate() : this.frequency, this.volume, aNIMMovieTrack.isSwapSpeakers() ? -f : f);
        }
    }

    public void play(ANIMMovieTrack aNIMMovieTrack) {
        this.prepare(aNIMMovieTrack);
        if (this.audioClip != null) {
            if (this.repeats < 2) {
                this.audioClip.play();
            } else {
                this.audioClip.loop(this.repeats);
            }
        }
        this.activeChannelMask = this.channelMask;
    }

    public void stop(ANIMMovieTrack aNIMMovieTrack) {
        this.activeChannelMask = 0;
        if (this.audioClip != null) {
            this.audioClip.stop();
        }
    }

    public void stop(ANIMMovieTrack aNIMMovieTrack, int n) {
        this.activeChannelMask &= ~n;
        if (this.activeChannelMask == 0) {
            this.audioClip.stop();
        }
    }

    public void doCommand(ANIMMovieTrack aNIMMovieTrack, ANIMAudioCommand[] aNIMAudioCommandArray) {
        switch (this.command) {
            case 1: {
                boolean bl = false;
                for (int i = 0; i < 4; ++i) {
                    if ((this.channelMask & 1 << i) == 0) continue;
                    if (aNIMAudioCommandArray[i] != null) {
                        aNIMAudioCommandArray[i].stop(aNIMMovieTrack, 1 << i);
                    }
                    if (!bl) {
                        bl = true;
                        this.play(aNIMMovieTrack);
                    }
                    aNIMAudioCommandArray[i] = this;
                }
                break;
            }
            case 2: {
                for (int i = 0; i < 4; ++i) {
                    if ((this.channelMask & 1 << i) == 0 || aNIMAudioCommandArray[i] == null) continue;
                    aNIMAudioCommandArray[i].stop(aNIMMovieTrack, 1 << i);
                    aNIMAudioCommandArray[i] = null;
                }
                break;
            }
        }
    }

    public void dispose() {
        if (this.audioClip != null) {
            this.audioClip = null;
        }
    }
}

