/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.media.eightsvx;

import ch.randelshofer.media.eightsvx.JDK10AudioClip;
import ch.randelshofer.media.eightsvx.JDK13AppletAudioClip;
import ch.randelshofer.media.eightsvx.LoopableAudioClip;
import java.io.IOException;
import java.io.OutputStream;

public class EightSVXAudioClip
implements LoopableAudioClip {
    private String name_ = "";
    private String author_ = "";
    private String copyright_ = "";
    private String remark_ = "";
    private byte[] body_;
    private long oneShotHiSamples_;
    private long repeatHiSamples_;
    private long samplesPerHiCycle_;
    private int sampleRate_;
    private int ctOctave_;
    public static final int S_CMP_NONE = 0;
    public static final int S_CMP_FIB_DELTA = 1;
    private int sCompression_;
    private static final double UNITY = 65536.0;
    private int volume_;
    private LoopableAudioClip cachedAudioClip_;
    private int cachedSampleRate_;
    public static final int RIGHT = 4;
    public static final int LEFT = 2;
    public static final int STEREO = 6;
    private int sampleType_;
    private static Boolean javaxAudioIsPresent;
    private static final byte[] CODE_TO_DELTA;
    private static final boolean ZEROTRAP = true;
    private static final short BIAS = 132;
    private static final int CLIP = 32635;
    private static final int[] exp_lut1;

    protected void setName(String string) {
        this.name_ = string;
    }

    protected String getName() {
        return this.name_;
    }

    protected void setAuthor(String string) {
        this.author_ = string;
    }

    protected String getAuthor() {
        return this.author_;
    }

    protected void setCopyright(String string) {
        this.copyright_ = string;
    }

    protected String getCopyright() {
        return this.copyright_;
    }

    protected void setRemark(String string) {
        this.remark_ = string;
    }

    protected String getRemark() {
        return this.remark_;
    }

    public void set8SVXBody(byte[] byArray) {
        this.body_ = byArray;
        this.cachedAudioClip_ = null;
    }

    public byte[] get8SVXBody() {
        return this.body_;
    }

    public void setOneShotHiSamples(long l) {
        this.oneShotHiSamples_ = l;
    }

    public void setRepeatHiSamples(long l) {
        this.repeatHiSamples_ = l;
    }

    public void setSamplesPerHiCycle(long l) {
        this.samplesPerHiCycle_ = l;
    }

    public void setSampleType(int n) {
        this.sampleType_ = n;
    }

    public void setSampleRate(int n) {
        this.sampleRate_ = n;
    }

    public void setCtOctave(int n) {
        this.ctOctave_ = n;
    }

    public void setSCompression(int n) {
        this.sCompression_ = n;
    }

    public void setVolume(int n) {
        this.volume_ = n;
    }

    public long getOneShotHiSamples() {
        return this.oneShotHiSamples_;
    }

    public long getRepeatHiSamples() {
        return this.repeatHiSamples_;
    }

    public long getSamplesPerHiCycle() {
        return this.samplesPerHiCycle_;
    }

    public long getSampleType() {
        return this.sampleType_;
    }

    public int getSampleRate() {
        return this.sampleRate_;
    }

    public int getCtOctave() {
        return this.ctOctave_;
    }

    public int getVolume() {
        return this.volume_;
    }

    public int getSCompression() {
        return this.sCompression_;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getName().length() == 0) {
            stringBuffer.append("<unnamed>");
        } else {
            stringBuffer.append(this.getName());
        }
        if (this.getAuthor().length() != 0) {
            stringBuffer.append(", ");
            stringBuffer.append(this.getAuthor());
        }
        if (this.getCopyright().length() != 0) {
            stringBuffer.append(", \u00a9 ");
            stringBuffer.append(this.getCopyright());
        }
        stringBuffer.append(' ');
        stringBuffer.append(Integer.toString(this.getSampleRate()));
        stringBuffer.append(" Hz");
        return stringBuffer.toString();
    }

    public LoopableAudioClip createAudioClip() {
        return this.createAudioClip(this.getSampleRate(), this.volume_, 0.0f);
    }

    public LoopableAudioClip createAudioClip(int n, int n2, float f) {
        if (javaxAudioIsPresent == null || javaxAudioIsPresent == Boolean.TRUE) {
            try {
                LoopableAudioClip loopableAudioClip = this.createJDK13AudioClip(n, n2, f);
                javaxAudioIsPresent = Boolean.TRUE;
                return loopableAudioClip;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                javaxAudioIsPresent = Boolean.FALSE;
            }
        }
        return this.createJDK10AudioClip(n);
    }

    public LoopableAudioClip createJDK13AudioClip(int n, int n2, float f) {
        Object var4_4 = null;
        if (this.sCompression_ == 1) {
            this.body_ = EightSVXAudioClip.unpackFibonacciDeltaCompression(this.body_);
            this.sCompression_ = 0;
        }
        if (this.sampleType_ == 6) {
            double d = EightSVXAudioClip.computeStereoVolumeCorrection(this.body_);
            this.body_ = EightSVXAudioClip.linear8StereoToMono(this.body_, d);
            this.sampleType_ = 2;
        }
        try {
            return new JDK13AppletAudioClip(this.get8SVXBody(), n, n2, f);
        }
        catch (IOException iOException) {
            throw new InternalError(iOException.toString());
        }
    }

    public LoopableAudioClip createJDK10AudioClip(int n) {
        Object var2_2 = null;
        if (this.sCompression_ == 1) {
            this.body_ = EightSVXAudioClip.unpackFibonacciDeltaCompression(this.body_);
            this.sCompression_ = 0;
        }
        if (this.sampleType_ == 6) {
            double d = EightSVXAudioClip.computeStereoVolumeCorrection(this.body_);
            this.body_ = EightSVXAudioClip.linear8StereoToMono(this.body_, d);
            this.sampleType_ = 2;
        }
        byte[] byArray = this.get8SVXBody();
        byArray = EightSVXAudioClip.resample(byArray, n, 8000);
        byArray = EightSVXAudioClip.linear8ToULaw(byArray);
        return new JDK10AudioClip(byArray, 8000);
    }

    public void play() {
        this.stop();
        if (this.cachedAudioClip_ == null) {
            this.cachedAudioClip_ = this.createAudioClip();
        }
        this.cachedAudioClip_.play();
    }

    public void loop() {
        this.stop();
        if (this.cachedAudioClip_ == null) {
            this.cachedAudioClip_ = this.createAudioClip();
        }
        this.cachedAudioClip_.loop();
    }

    public void stop() {
        if (this.cachedAudioClip_ != null) {
            this.cachedAudioClip_.stop();
        }
    }

    public void prepare() {
        if (this.cachedAudioClip_ == null) {
            this.cachedAudioClip_ = this.createAudioClip();
        }
    }

    public static double computeStereoVolumeCorrection(byte[] byArray) {
        int n = byArray.length / 2;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = Math.max(n2, Math.abs(byArray[i] + byArray[n + i]));
        }
        if (n2 < 128) {
            return 1.0;
        }
        return 128.0 / (double)n2;
    }

    public static byte[] linear8StereoToMono(byte[] byArray, double d) {
        int n = byArray.length / 2;
        byte[] byArray2 = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray2[i] = (byte)((double)(byArray[i] + byArray[n + i]) * d);
        }
        return byArray2;
    }

    public static byte[] resample(byte[] byArray, int n, int n2) {
        if (n == n2) {
            return byArray;
        }
        if (n > n2) {
            float f = (float)n / (float)n2;
            byte[] byArray2 = new byte[(int)Math.floor((float)byArray.length / f)];
            for (int i = 0; i < byArray2.length; ++i) {
                byArray2[i] = byArray[(int)((float)i * f)];
            }
            return byArray2;
        }
        float f = (float)n / (float)n2;
        byte[] byArray3 = new byte[(int)Math.ceil((float)byArray.length / f)];
        for (int i = 0; i < byArray3.length; ++i) {
            byArray3[i] = byArray[(int)((float)i * f)];
        }
        return byArray3;
    }

    public static byte[] linear8ToULaw(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[i] = EightSVXAudioClip.linear16ToULaw(byArray[i] << 8);
        }
        return byArray2;
    }

    public static byte[] linear16ToULaw(int[] nArray) {
        byte[] byArray = new byte[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            byArray[i] = EightSVXAudioClip.linear16ToULaw(nArray[i]);
        }
        return byArray;
    }

    public static byte[] unpackFibonacciDeltaCompression(byte[] byArray) {
        int n = byArray.length - 2;
        int n2 = n * 2;
        byte[] byArray2 = new byte[n2];
        int n3 = byArray[1];
        int n4 = 0;
        for (int i = 2; i < n; ++i) {
            byte by = byArray[i];
            byArray2[n4++] = (byte)(n3 += CODE_TO_DELTA[by >> 4 & 0xF]);
            byArray2[n4++] = (byte)(n3 += CODE_TO_DELTA[by & 0xF]);
        }
        return byArray2;
    }

    public static void writeSunAudioHeader(OutputStream outputStream, int n, int n2, int n3) throws IOException {
        EightSVXAudioClip.wrulong(outputStream, 779316836);
        EightSVXAudioClip.wrulong(outputStream, 24);
        EightSVXAudioClip.wrulong(outputStream, n);
        EightSVXAudioClip.wrulong(outputStream, 1);
        EightSVXAudioClip.wrulong(outputStream, n2);
        EightSVXAudioClip.wrulong(outputStream, n3 == 6 ? 2 : 1);
    }

    public static void wrulong(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n >> 24 & 0xFF);
        outputStream.write(n >> 16 & 0xFF);
        outputStream.write(n >> 8 & 0xFF);
        outputStream.write(n >> 0 & 0xFF);
    }

    private static byte linear16ToULaw(int n) {
        int n2;
        int n3;
        int n4;
        if (n > Short.MAX_VALUE) {
            n = Short.MAX_VALUE;
        } else if (n < Short.MIN_VALUE) {
            n = Short.MIN_VALUE;
        }
        int n5 = n >> 8 & 0x80;
        if (n5 != 0) {
            n = -n;
        }
        if (n > 32635) {
            n = 32635;
        }
        if ((n4 = ~(n5 | (n3 = exp_lut1[(n += 132) >> 7 & 0xFF]) << 4 | (n2 = n >> n3 + 3 & 0xF))) == 0) {
            n4 = 2;
        }
        return (byte)n4;
    }

    public void loop(int n) {
        this.stop();
        if (this.cachedAudioClip_ == null) {
            this.cachedAudioClip_ = this.createAudioClip();
        }
        this.cachedAudioClip_.loop(n);
    }

    static {
        CODE_TO_DELTA = new byte[]{-34, -21, -13, -8, -5, -3, -2, -1, 0, 1, 2, 3, 5, 8, 13, 21};
        exp_lut1 = new int[]{0, 0, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7};
    }
}

