/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.media.eightsvx;

import ch.randelshofer.iff.IFFChunk;
import ch.randelshofer.iff.IFFParser;
import ch.randelshofer.iff.IFFVisitor;
import ch.randelshofer.iff.MC68000InputStream;
import ch.randelshofer.iff.ParseException;
import ch.randelshofer.media.eightsvx.EightSVXAudioClip;
import ch.randelshofer.util.AbortException;
import java.applet.AudioClip;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class EightSVXDecoder
implements IFFVisitor {
    public static final int EIGHT_SVX_ID = IFFParser.stringToID("8SVX");
    public static final int VHDR_ID = IFFParser.stringToID("VHDR");
    public static final int NAME_ID = IFFParser.stringToID("NAME");
    public static final int COPYRIGHT_ID = IFFParser.stringToID("(c) ");
    public static final int ANNO_ID = IFFParser.stringToID("ANNO");
    public static final int AUTH_ID = IFFParser.stringToID("AUTH");
    public static final int CHAN_ID = IFFParser.stringToID("CHAN");
    public static final int BODY_ID = IFFParser.stringToID("BODY");
    private Vector samples_ = new Vector();
    private boolean within8SVXGroup_ = false;

    public EightSVXDecoder(InputStream inputStream) throws IOException {
        try {
            IFFParser iFFParser = new IFFParser();
            this.registerChunks(iFFParser);
            iFFParser.parse(inputStream, this);
        }
        catch (ParseException parseException) {
            throw new IOException(parseException.toString());
        }
        catch (AbortException abortException) {
            throw new IOException(abortException.toString());
        }
        finally {
            inputStream.close();
        }
    }

    public EightSVXDecoder() {
    }

    public Vector getSamples() {
        return this.samples_;
    }

    public void registerChunks(IFFParser iFFParser) {
        iFFParser.declareGroupChunk(EIGHT_SVX_ID, 1179603533);
        iFFParser.declarePropertyChunk(EIGHT_SVX_ID, VHDR_ID);
        iFFParser.declarePropertyChunk(EIGHT_SVX_ID, NAME_ID);
        iFFParser.declarePropertyChunk(EIGHT_SVX_ID, COPYRIGHT_ID);
        iFFParser.declareCollectionChunk(EIGHT_SVX_ID, ANNO_ID);
        iFFParser.declarePropertyChunk(EIGHT_SVX_ID, AUTH_ID);
        iFFParser.declarePropertyChunk(EIGHT_SVX_ID, CHAN_ID);
        iFFParser.declareDataChunk(EIGHT_SVX_ID, BODY_ID);
    }

    public void enterGroup(IFFChunk iFFChunk) {
        if (iFFChunk.getType() == EIGHT_SVX_ID) {
            this.within8SVXGroup_ = true;
        }
    }

    public void leaveGroup(IFFChunk iFFChunk) {
        if (iFFChunk.getType() == EIGHT_SVX_ID) {
            this.within8SVXGroup_ = false;
        }
    }

    public void visitChunk(IFFChunk iFFChunk, IFFChunk iFFChunk2) throws ParseException {
        if (this.within8SVXGroup_ && iFFChunk2.getID() == BODY_ID) {
            if (iFFChunk.getPropertyChunk(VHDR_ID) == null) {
                throw new ParseException("Sorry: Without 8SVX.VHDR-Chunk no sound possible");
            }
            EightSVXAudioClip eightSVXAudioClip = new EightSVXAudioClip();
            this.decodeVHDR(eightSVXAudioClip, iFFChunk.getPropertyChunk(VHDR_ID));
            this.decodeCHAN(eightSVXAudioClip, iFFChunk.getPropertyChunk(CHAN_ID));
            this.decodeNAME(eightSVXAudioClip, iFFChunk.getPropertyChunk(NAME_ID));
            this.decodeCOPYRIGHT(eightSVXAudioClip, iFFChunk.getPropertyChunk(COPYRIGHT_ID));
            this.decodeAUTH(eightSVXAudioClip, iFFChunk.getPropertyChunk(COPYRIGHT_ID));
            this.decodeANNO(eightSVXAudioClip, iFFChunk.getCollectionChunks(ANNO_ID));
            this.decodeBODY(eightSVXAudioClip, iFFChunk2);
            this.addAudioClip(eightSVXAudioClip);
        }
    }

    public void addAudioClip(AudioClip audioClip) {
        this.samples_.addElement(audioClip);
    }

    protected void decodeVHDR(EightSVXAudioClip eightSVXAudioClip, IFFChunk iFFChunk) throws ParseException {
        try {
            if (iFFChunk != null) {
                MC68000InputStream mC68000InputStream = new MC68000InputStream(new ByteArrayInputStream(iFFChunk.getData()));
                eightSVXAudioClip.setOneShotHiSamples(mC68000InputStream.readULONG());
                eightSVXAudioClip.setRepeatHiSamples(mC68000InputStream.readULONG());
                eightSVXAudioClip.setSamplesPerHiCycle(mC68000InputStream.readULONG());
                eightSVXAudioClip.setSampleRate(mC68000InputStream.readUWORD());
                eightSVXAudioClip.setCtOctave(mC68000InputStream.readUBYTE());
                eightSVXAudioClip.setSCompression(mC68000InputStream.readUBYTE());
                eightSVXAudioClip.setVolume(mC68000InputStream.readLONG());
            }
        }
        catch (IOException iOException) {
            throw new ParseException("Error parsing 8SVX VHDR:" + iOException.getMessage());
        }
    }

    protected void decodeCHAN(EightSVXAudioClip eightSVXAudioClip, IFFChunk iFFChunk) throws ParseException {
        if (iFFChunk != null) {
            eightSVXAudioClip.setSampleType(iFFChunk.getData()[3]);
        }
    }

    protected void decodeNAME(EightSVXAudioClip eightSVXAudioClip, IFFChunk iFFChunk) throws ParseException {
        if (iFFChunk != null) {
            eightSVXAudioClip.setName(new String(iFFChunk.getData()));
        }
    }

    protected void decodeCOPYRIGHT(EightSVXAudioClip eightSVXAudioClip, IFFChunk iFFChunk) throws ParseException {
        if (iFFChunk != null) {
            eightSVXAudioClip.setCopyright(new String(iFFChunk.getData()));
        }
    }

    protected void decodeAUTH(EightSVXAudioClip eightSVXAudioClip, IFFChunk iFFChunk) throws ParseException {
        if (iFFChunk != null) {
            eightSVXAudioClip.setAuthor(new String(iFFChunk.getData()));
        }
    }

    protected void decodeANNO(EightSVXAudioClip eightSVXAudioClip, IFFChunk[] iFFChunkArray) throws ParseException {
        if (iFFChunkArray != null) {
            for (int i = 0; i < iFFChunkArray.length; ++i) {
                IFFChunk iFFChunk = iFFChunkArray[i];
                eightSVXAudioClip.setRemark(eightSVXAudioClip.getRemark() + new String(iFFChunk.getData()));
            }
        }
    }

    protected void decodeBODY(EightSVXAudioClip eightSVXAudioClip, IFFChunk iFFChunk) throws ParseException {
        if (iFFChunk != null) {
            byte[] byArray = iFFChunk.getData();
            eightSVXAudioClip.set8SVXBody(byArray);
        }
    }
}

