/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.media.eightsvx;

import ch.randelshofer.media.eightsvx.LoopableAudioClip;
import java.io.IOException;
import java.util.Vector;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;

public class JDK13AppletAudioClip
implements LoopableAudioClip,
Runnable {
    private byte[] samples;
    private static Mixer mixer;
    private static Vector lines;
    private volatile Thread workerThread;
    private int loopCount;
    private int volume;
    private int sampleRate;
    private float pan;
    private int loopStart;
    private int loopEnd;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

    public JDK13AppletAudioClip(byte[] byArray, int n, int n2, float f) throws IOException {
        this.samples = byArray;
        this.volume = n2;
        this.pan = f;
        this.loopStart = 0;
        this.loopEnd = byArray.length;
        this.sampleRate = n;
        try {
            JDK13AppletAudioClip.getMixer();
        }
        catch (LineUnavailableException lineUnavailableException) {
            throw new IOException(lineUnavailableException.toString());
        }
    }

    private static Mixer getMixer() throws LineUnavailableException {
        if (mixer == null) {
            int n;
            mixer = AudioSystem.getMixer(AudioSystem.getMixerInfo()[0]);
            SourceDataLine[] sourceDataLineArray = new SourceDataLine[16];
            for (n = 0; n < 16; ++n) {
                sourceDataLineArray[n] = JDK13AppletAudioClip.aquireLine();
            }
            for (n = 0; n < 16; ++n) {
                JDK13AppletAudioClip.poolLine(sourceDataLineArray[n]);
            }
        }
        return mixer;
    }

    private static synchronized SourceDataLine aquireLine() throws LineUnavailableException {
        SourceDataLine sourceDataLine;
        if (lines.size() > 0) {
            sourceDataLine = (SourceDataLine)lines.elementAt(0);
            lines.removeElementAt(0);
        } else {
            AudioFormat audioFormat = new AudioFormat(8000.0f, 8, 1, true, true);
            DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = JDK13AppletAudioClip.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, audioFormat);
            sourceDataLine = (SourceDataLine)JDK13AppletAudioClip.getMixer().getLine(info);
            sourceDataLine.open();
            sourceDataLine.start();
        }
        return sourceDataLine;
    }

    private static synchronized void poolLine(SourceDataLine sourceDataLine) {
        if (lines.size() < 16) {
            lines.addElement(sourceDataLine);
        } else {
            sourceDataLine.close();
        }
    }

    public void setLoopPoints(int n, int n2) {
        if (n < 0 || n >= this.samples.length || n2 < n && n2 != -1 || n2 >= this.samples.length) {
            throw new IllegalArgumentException("start:" + n + " end:" + n2);
        }
        this.loopStart = n;
        this.loopEnd = n2 == -1 ? this.samples.length : n2 + 1;
    }

    public void loop() {
        this.loop(-1);
    }

    public synchronized void loop(int n) {
        this.stop();
        this.loopCount = n;
        this.workerThread = new Thread((Runnable)this, this.toString());
        this.workerThread.setPriority(6);
        this.workerThread.start();
    }

    public void play() {
        this.loop(0);
    }

    public synchronized void stop() {
        if (this.workerThread != null) {
            Thread thread = this.workerThread;
            this.workerThread = null;
        }
    }

    private void configureDataLine(DataLine dataLine) {
        FloatControl floatControl;
        if (dataLine.isControlSupported(FloatControl.Type.PAN)) {
            floatControl = (FloatControl)dataLine.getControl(FloatControl.Type.PAN);
            floatControl.setValue(this.pan);
        }
        if (dataLine.isControlSupported(FloatControl.Type.VOLUME)) {
            floatControl = (FloatControl)dataLine.getControl(FloatControl.Type.VOLUME);
            floatControl.setValue((float)this.volume / 64.0f);
        }
        if (dataLine.isControlSupported(FloatControl.Type.SAMPLE_RATE)) {
            floatControl = (FloatControl)dataLine.getControl(FloatControl.Type.SAMPLE_RATE);
            floatControl.setValue(this.sampleRate);
        }
    }

    public void run() {
        int n;
        long l = System.currentTimeMillis();
        long l2 = this.samples.length * Math.max(this.loopCount, 1) / 8;
        SourceDataLine sourceDataLine = null;
        try {
            sourceDataLine = JDK13AppletAudioClip.aquireLine();
        }
        catch (LineUnavailableException lineUnavailableException) {
            lineUnavailableException.printStackTrace();
            return;
        }
        this.configureDataLine(sourceDataLine);
        byte[] byArray = new byte[100];
        if (this.loopCount > 0 && n < this.loopEnd) {
            while (this.workerThread == Thread.currentThread() && (this.loopCount > 0 || this.loopCount == -1)) {
                while (this.workerThread == Thread.currentThread() && n < this.loopEnd) {
                    System.arraycopy(this.samples, n, byArray, 0, Math.min(byArray.length, this.loopEnd - n));
                    n += sourceDataLine.write(byArray, 0, Math.min(byArray.length, this.loopEnd - n));
                }
                if (this.workerThread != Thread.currentThread() || this.loopCount <= 0 && this.loopCount != -1 || this.loopCount == -1) continue;
                --this.loopCount;
                if (this.loopCount == 0) continue;
                n = this.loopStart;
            }
            while (this.workerThread == Thread.currentThread() && n < this.samples.length) {
                System.arraycopy(this.samples, n, byArray, 0, Math.min(byArray.length, this.samples.length - n));
                n += sourceDataLine.write(byArray, 0, Math.min(byArray.length, this.samples.length - n));
            }
        } else {
            for (n = 0; this.workerThread == Thread.currentThread() && n < this.samples.length; n += sourceDataLine.write(byArray, 0, Math.min(byArray.length, this.samples.length - n))) {
                System.arraycopy(this.samples, n, byArray, 0, Math.min(byArray.length, this.samples.length - n));
            }
        }
        long l3 = System.currentTimeMillis();
        long l4 = l3 - l;
        while (this.workerThread == Thread.currentThread() && l2 > l4) {
            try {
                Thread.sleep(Math.max(1L, Math.min(l2 - l4, 100L)));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            l4 = System.currentTimeMillis() - l;
        }
        if (this.workerThread != Thread.currentThread()) {
            sourceDataLine.flush();
        }
        JDK13AppletAudioClip.poolLine(sourceDataLine);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        lines = new Vector();
    }
}

