/*
 * @(#)IFFVisitor.java  1.0  1999-10-19
 *
 * Copyright (c) 1999 Werner Randelshofer
 * Staldenmattweg 2, CH-6405 Immensee, Switzerland
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of 
 * Werner Randelshofer. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Werner Randelshofer.
 */
package ch.randelshofer.iff;

import ch.randelshofer.util.*;

/**
IFFVisitor is notified each time the IFFParser visits
a data chunk and when a group is entered or leaved.

@version  1.0  1999-10-19
*/
public interface IFFVisitor
  {
  public void enterGroup(IFFChunk group)
  throws ParseException, AbortException;

  public void leaveGroup(IFFChunk group)
  throws ParseException, AbortException;

  public void visitChunk(IFFChunk group, IFFChunk chunk)
  throws ParseException, AbortException;
  }
