/*
 * @(#)MovieControlAqua.java  1.1  2005-07-10
 *
 * Copyright (c) 2003-2005 Werner Randelshofer
 * Staldenmattweg 2, CH-6405 Immensee, Switzerland
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * Werner Randelshofer. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Werner Randelshofer.
 */

package ch.randelshofer.media;

import java.awt.*;
import java.beans.*;
//import ch.randelshofer.beans.*;
import ch.randelshofer.media.*;
import ch.randelshofer.gui.*;
import ch.randelshofer.gui.event.*;
import ch.randelshofer.util.*;

import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeEvent;

/**
 * The MovieControlAqua contains an audio on/off button, a start/stop button,
 * a slider, a forward and a rewind button.
 *
 * @author  Werner Randelshofer, Staldenmattweg 2, CH-6405 Immensee, Switzerland
 * @version 1.1 2005-07-10 Load image resources only once for all instances.
 * <br>1.0.1 2003-04-26 Revised.
 * <br>1.0 April 22, 2003 Created.
 */
public class MovieControlAqua extends Panel //JPanel
implements ActionListener, ItemListener, ChangeListener, PropertyChangeListener {
    private Player player;
    private MovieSliderAqua slider;
    private AbstractButton forwardButton, rewindButton;
    private ToggleButton startButton, audioButton;
    private BoundedRangeModel boundedRangeModel;
    
    private final static Image bgWest = Toolkit.getDefaultToolkit().getImage(MovieControlAqua.class.getResource("images/moviecontrol_bg_west.gif"));
    private final static Image bgEast = Toolkit.getDefaultToolkit().getImage(MovieControlAqua.class.getResource("images/moviecontrol_bg_east.gif"));
    private final static Image bgWestPressed = Toolkit.getDefaultToolkit().getImage(MovieControlAqua.class.getResource("images/moviecontrol_bg_west_pressed.gif"));
    private final static Image bgEastPressed = Toolkit.getDefaultToolkit().getImage(MovieControlAqua.class.getResource("images/moviecontrol_bg_east_pressed.gif"));
    private final static ImageIconAWT icnAudio = new ImageIconAWT(MovieControlAqua.class.getResource("images/icn_audio.gif"));
    private final static ImageIconAWT icnAudioSelected = new ImageIconAWT(MovieControlAqua.class.getResource("images/icn_audio_selected.gif"));
    private final static ImageIconAWT icnPlay= new ImageIconAWT(MovieControlAqua.class.getResource("images/icn_play.gif"));
    private final static ImageIconAWT icnPause = new ImageIconAWT(MovieControlAqua.class.getResource("images/icn_pause.gif"));
    private final static ImageIconAWT icnBack = new ImageIconAWT(MovieControlAqua.class.getResource("images/icn_back.gif"));
    private final static ImageIconAWT icnNext = new ImageIconAWT(MovieControlAqua.class.getResource("images/icn_next.gif"));
    
    
    public MovieControlAqua() {
        // Set the background color to the border color of the buttons.
        // This way the toolbar won't look too ugly when the buttons
        // are displayed before they have been loaded completely.
        setBackground(new Color(118,118,118));
        
        Dimension buttonSize = new Dimension(16,16);
        GridBagLayout gridbag = new GridBagLayout();
        setLayout(gridbag);
        GridBagConstraints c;
        
        audioButton = new ToggleButton();
        
        audioButton.addItemListener(this);
        audioButton.setPreferredSize(buttonSize);
        audioButton.setMinimumSize(buttonSize);
        audioButton.setVisible(false);
        c = new GridBagConstraints();
        //c.gridx = 0;
        //c.gridy = 0;
        gridbag.setConstraints(audioButton, c);
        add(audioButton);
        
        
        startButton = new ToggleButton();
        startButton.addItemListener(this);
        startButton.setPreferredSize(buttonSize);
        startButton.setMinimumSize(buttonSize);
        c = new GridBagConstraints();
        c.gridx = 1;
        //c.gridy = 0;
        gridbag.setConstraints(startButton, c);
        add(startButton);
        
        slider = new MovieSliderAqua();
        c = new GridBagConstraints();
        c.gridx = 2;
        //c.gridy = 0;
        c.fill = GridBagConstraints.HORIZONTAL;
        c.weightx = 1.0;
        gridbag.setConstraints(slider, c);
        add(slider);
        
        rewindButton = new AbstractButton();
        rewindButton.setPreferredSize(buttonSize);
        rewindButton.setMinimumSize(buttonSize);
        c = new GridBagConstraints();
        c.gridx = 3;
        //c.gridy = 0;
        gridbag.setConstraints(rewindButton, c);
        add(rewindButton);
        rewindButton.addActionListener(this);
        
        forwardButton = new AbstractButton();
        buttonSize = new Dimension(17,16);
        forwardButton.setPreferredSize(buttonSize);
        forwardButton.setMinimumSize(buttonSize);
        c = new GridBagConstraints();
        c.gridx = 4;
        //c.gridy = 0;
        gridbag.setConstraints(forwardButton, c);
        add(forwardButton);
        forwardButton.addActionListener(this);
        
        Image image = bgWest;
        startButton.setEnabledBackgroundImage(image);
        audioButton.setEnabledBackgroundImage(image);
        rewindButton.setEnabledBackgroundImage(image);
        image = bgEast;
        forwardButton.setEnabledBackgroundImage(image);
        image = bgWestPressed;
        rewindButton.setPressedBackgroundImage(image);
        startButton.setPressedBackgroundImage(image);
        audioButton.setPressedBackgroundImage(image);
        image = bgEastPressed;
        forwardButton.setPressedBackgroundImage(image);
        
        audioButton.setUnselectedIcon(icnAudio);
        audioButton.setSelectedIcon(icnAudioSelected);
        startButton.setUnselectedIcon(icnPlay);
        startButton.setSelectedIcon(icnPause);
        rewindButton.setIcon(icnBack);
        forwardButton.setIcon(icnNext);
        
    }
    
    public synchronized void setPlayer(Player player) {
        if (this.player != null) {
            this.player.removeChangeListener(this);
            player.removePropertyChangeListener(this);
        }
        this.player = player;
        //        boundedRangeModel = player == null ? null : player.getBoundedRangeModel();
        boundedRangeModel = player == null ? null : player.getTimeModel();
        slider.setModel(boundedRangeModel);
        if (player != null) {
            slider.setProgressModel(player.getCachingModel());
            startButton.setSelected(player.isActive());
            player.addChangeListener(this);
            player.addPropertyChangeListener(this);
            audioButton.setVisible(player.isAudioAvailable());
            audioButton.setSelected(player.isAudioEnabled());
            validate();
            repaint();
            BoundedRangeModel cachingControlModel = slider.getProgressModel();
        }
    }
    
    public void setProgressModel(BoundedRangeModel brm) {
        slider.setProgressModel(brm);
    }
    
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (boundedRangeModel != null) {
            int value = boundedRangeModel.getValue();
            if (source == forwardButton) {
                boundedRangeModel.setValue( value == boundedRangeModel.getMaximum() ? boundedRangeModel.getMinimum() : value + 1);
            }
            else if (source == rewindButton) {
                boundedRangeModel.setValue( value == boundedRangeModel.getMinimum() ? boundedRangeModel.getMaximum() : value - 1);
            }
        }
    }
    
    public void itemStateChanged(ItemEvent event) {
        if (player == null) {
            return;
        }
        
        if (startButton.isSelected() != player.isActive()) {
            if (startButton.isSelected()) {
                player.start();
            } else {
                player.stop();
            }
        }
        
        player.setAudioEnabled(audioButton.isSelected());
    }
    
    public void stateChanged(ChangeEvent event) {
        startButton.setSelected(player.isActive());
    }
    
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("audioEnabled")) {
            audioButton.setSelected(player.isAudioEnabled());
        }
        if (evt.getPropertyName().equals("audioAvailable")) {
            audioButton.setVisible(player.isAudioAvailable());
            validate();
            repaint();
        }
        if (evt.getPropertyName().equals("cached")) {
            BoundedRangeModel cachingControlModel = slider.getProgressModel();
        }
    }
    
}

