/*
 * @(#)MovieSliderAqua.java  2.0.1  2008-04-05
 *
 * Copyright (c) 2003-2008 Werner Randelshofer
 * Staldenmattweg 2, CH-6405 Immensee, Switzerland
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * Werner Randelshofer. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Werner Randelshofer.
 */

package ch.randelshofer.media;

import java.awt.Toolkit;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Event;
import ch.randelshofer.gui.event.*;
import ch.randelshofer.gui.*;
import ch.randelshofer.util.*;

import java.awt.event.MouseListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
/*
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
*/
/**
 * MovieSliderAqua.
 *
 * @author  Werner Randelshofer, Staldenmattweg 2, CH-6405 Immensee, Switzerland
 * @version 2.0.1 2008-04-05 Replaced thumb .gif by .png. 
 * <br>2.0 2005-07-10 Use double buffering to avoid flicker on Windows.
 * <br>1.2 2005-07-09 Set valueIsAdjusting to true while mouse button is
 * pressed.
 * <br>1.1 2003-04-25 Thumb position was not computed correctly.
 * <br>1.0 April 22, 2003 Created.
 */

public class MovieSliderAqua extends Canvas //JComponent
implements ChangeListener, MouseListener, MouseMotionListener {
    private final static int THUMB_WIDTH = 16, THUMB_HEIGHT = 16;
    private final static int HALF_THUMB_WIDTH = THUMB_WIDTH / 2;
    
    private BoundedRangeModel model_;
    protected int thumbPos_ = 0;
    private int progressPos_ = 0;
    private BoundedRangeModel progressModel_;
    private boolean isPressed, isArmed;
    private static Image trackEastImage, trackCenterImage, trackWestImage;
    private static Image trackEastUnloadedImage, trackCenterUnloadedImage, trackWestUnloadedImage;
    private static Image thumbImage, thumbPressedImage;
    
    protected Graphics backGfx;
    protected Image backImg;
    protected Dimension backSize = new Dimension(0, 0);
    
    public MovieSliderAqua() {
        model_ = new DefaultBoundedRangeModel();
        model_.addChangeListener(this);
        progressModel_ = new DefaultBoundedRangeModel();
        progressModel_.setValue(progressModel_.getMaximum());
        progressModel_.addChangeListener(this);
        setBackground(Color.lightGray);
        addMouseListener(this);
        addMouseMotionListener(this);
        
        if (trackEastImage == null) {
            Toolkit t = getToolkit();
            Class c = getClass();
            
            trackEastImage = t.getImage(c.getResource("images/slider_track_east.gif"));
            trackCenterImage = t.getImage(c.getResource("images/slider_track_center.gif"));
            trackWestImage = t.getImage(c.getResource("images/slider_track_west.gif"));
            trackEastUnloadedImage = t.getImage(c.getResource("images/slider_track_east_unloaded.gif"));
            trackCenterUnloadedImage = t.getImage(c.getResource("images/slider_track_center_unloaded.gif"));
            trackWestUnloadedImage = t.getImage(c.getResource("images/slider_track_west_unloaded.gif"));
            thumbImage = t.getImage(c.getResource("images/slider_thumb.png"));
            thumbPressedImage = t.getImage(c.getResource("images/slider_thumb_pressed.png"));
            
            MediaTracker tracker = new MediaTracker(this);
            tracker.addImage(trackEastImage, 0);
            tracker.addImage(trackCenterImage, 0);
            tracker.addImage(trackWestImage, 0);
            tracker.addImage(trackEastUnloadedImage, 0);
            tracker.addImage(trackCenterUnloadedImage, 0);
            tracker.addImage(trackWestUnloadedImage, 0);
            tracker.addImage(thumbImage, 0);
            tracker.addImage(thumbPressedImage, 0);
            tracker.checkAll(true);
        }
        
    }
    
    public synchronized void setModel(BoundedRangeModel m) {
        //   public synchronized void setModel(BoundedRangeModel m) {
        if (model_ != null) {
            model_.removeChangeListener(this);
        }
        model_ = m == null ? new DefaultBoundedRangeModel() : m;
        if (model_ != null) {
            model_.addChangeListener(this);
        }
        repaint();
    }
    
    public Dimension getPreferredSize() {
        return new Dimension(100, 16);
    }
    
    public Dimension getMinimumSize() {
        return new Dimension(16, 16);
    }
    /*
    public boolean mouseDown(Event e, int x, int y) {
        isPressed = true;
        moveThumb(x);
        repaint();
        return true;
    }
    public boolean mouseDrag(Event e, int x, int y) {
        moveThumb(x);
        return true;
    }
    public boolean mouseUp(Event e, int x, int y) {
        isPressed = false;
        moveThumb(x);
        return true;
    }
    public boolean mouseEnter(Event e, int x, int y) {
        isArmed = true;
        if (isPressed) repaint();
        return true;
    }
    public boolean mouseExit(Event e, int x, int y) {
        isArmed = false;
        if (isPressed) repaint();
        return true;
    }*/
    
    protected void moveThumb(int mousePosition) {
        int width = getSize().width;
        float mouseValue = (mousePosition - HALF_THUMB_WIDTH) / (float) (width - THUMB_WIDTH);
        model_.setValue((int)(mouseValue * (model_.getMaximum() - model_.getMinimum())));
    }
    
    protected int computeThumbPos() {
        BoundedRangeModel m = model_;
        if (m == null) { return 0; }
        int width = getSize().width - THUMB_WIDTH;
        //int width = computeProgressPos() - THUMB_WIDTH;
        float thumbPos = Math.max(0f,m.getValue() / (float)((m.getMaximum() - m.getMinimum())));
        return (int) (width * thumbPos);
    }
    
    public synchronized void setProgressModel(BoundedRangeModel brm) {
        if (progressModel_ != null) {
            progressModel_.removeChangeListener(this);
        }
        progressModel_ = (brm == null) ? new DefaultBoundedRangeModel() : brm;
        if (progressModel_ != null) {
            progressModel_.addChangeListener(this);
        }
    }
    public BoundedRangeModel getProgressModel() {
        return progressModel_;
    }
    
    
    public void update(Graphics g) {
        paint(g);
    }
    
    public void paint(Graphics g) {
        if (((Object) this) instanceof Canvas) {
            // Create an image for double buffering
            Dimension s = getSize();
            if (backGfx == null || backSize.width != s.width || backSize.height != s.height) {
                if (s.width <= 0 || s.height <= 0) {
                    return;
                }
                backImg = createImage(s.width, s.height);
                backGfx = backImg.getGraphics();
                backSize = s;
            }
            
            thumbPos_ = computeThumbPos();
            progressPos_ = computeProgressPos();
            paintTrack(backGfx, progressPos_);
            paintThumb(backGfx, thumbPos_);
            
            // Draw the back buffer on screen
            g.drawImage(backImg, 0, 0, this);
        } else {
            thumbPos_ = computeThumbPos();
            progressPos_ = computeProgressPos();
            paintTrack(g, progressPos_);
            paintThumb(g, thumbPos_);
        }
    }
    
    private void paintTrack(Graphics g, int progressPos) {
        Dimension s = getSize();
        int width = s.width;
        int height = s.height;
        
        // Draw west
        Image image;
        if (progressModel_.getValue() == progressModel_.getMinimum()) {
            image = trackWestUnloadedImage;
        } else {
            image = trackWestImage;
        }
        g.drawImage(image, 0, 0, this);
        
        // Draw center
        int trackWidth = width - trackEastImage.getWidth(this) - trackWestImage.getWidth(this);
        int imageWidth = Math.min(
        trackWidth,
        progressPos - trackWestImage.getWidth(this)
        );
        if (imageWidth > 0) {
            g.drawImage(trackCenterImage, trackWestImage.getWidth(this), 0,
            imageWidth,
            trackCenterImage.getHeight(this),
            this);
        }
        imageWidth = trackWidth - imageWidth;
        if (imageWidth > 0) {
            g.drawImage(trackCenterUnloadedImage, width - trackEastImage.getWidth(this) - imageWidth, 0,
            imageWidth,
            trackCenterUnloadedImage.getHeight(this),
            this);
        }
        
        // Draw east
        if (progressModel_.getValue() < progressModel_.getMaximum() - progressModel_.getExtent()) {
            image = trackEastUnloadedImage;
        } else {
            image = trackEastImage;
        }
        g.drawImage(image, width - image.getWidth(this), 0, this);
    }
    public void paintThumb(Graphics g, int thumbPos) {
        Dimension s = getSize();
        int width = s.width;
        int height = s.height;
        
        Image image;
        if (isPressed && isArmed) {
            image = thumbPressedImage;
        } else {
            image = thumbImage;
        }
        
        // thumb
        g.drawImage(image, thumbPos, 1, this);
    }
    
    protected int computeProgressPos() {
        BoundedRangeModel m = progressModel_;
        if (m == null) { return 0; }
        int trackWidth = getSize().width - trackEastImage.getWidth(this) - trackWestImage.getWidth(this);
        float thumbPos = Math.max(0f,m.getValue() / (float)((m.getMaximum() - m.getMinimum())));
        return (int) (trackWidth * thumbPos) + trackWestImage.getWidth(this);
    }
    
    public void stateChanged(ChangeEvent event) {
        BoundedRangeModel progress = progressModel_;
        if (progress != null && event.getSource() == progress) {
            //System.out.println("MovieSliderAqua progress:"+progress.getValue());
            if (computeProgressPos() != progressPos_) {
                repaint();
            }
        } else {
            //System.out.println("MovieSliderAqua time:"+model_.getValue());
            if (computeThumbPos() != thumbPos_) {
                repaint();
            }
        }
    }
    
    public void mouseClicked(java.awt.event.MouseEvent mouseEvent) {
    }
    
    public void mouseEntered(java.awt.event.MouseEvent mouseEvent) {
        isArmed = true;
        repaint();
    }
    
    public void mouseExited(java.awt.event.MouseEvent mouseEvent) {
        isArmed = false;
        repaint();
    }
    
    public void mousePressed(java.awt.event.MouseEvent mouseEvent) {
        model_.setValueIsAdjusting(true);
        isPressed = true;
        moveThumb(mouseEvent.getX());
        repaint();
    }
    
    public void mouseReleased(java.awt.event.MouseEvent mouseEvent) {
        isPressed = false;
        model_.setValueIsAdjusting(false);
        moveThumb(mouseEvent.getX());
        repaint();
    }
    
    public void mouseDragged(java.awt.event.MouseEvent mouseEvent) {
        moveThumb(mouseEvent.getX());
    }
    
    public void mouseMoved(java.awt.event.MouseEvent mouseEvent) {
    }
    
}