/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.gui.border;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.border.Border;

public class ButtonStateBorder
implements Border {
    public static final int E = 0;
    public static final int EP = 1;
    public static final int ES = 2;
    public static final int EPS = 3;
    public static final int D = 4;
    public static final int DS = 5;
    public static final int I = 6;
    public static final int IS = 7;
    public static final int DI = 8;
    public static final int DIS = 9;
    public static final int DEFAULT = 10;
    private Border[] borders;
    private Image tiledImage;
    private int tileCount;
    private boolean isTiledHorizontaly;
    private Insets borderInsets;
    private boolean fill;
    private Insets imageInsets;

    public ButtonStateBorder(Border e, Border es) {
        this.borders = new Border[11];
        this.borders[0] = e;
        this.borders[1] = es;
        this.borders[2] = es;
        this.borders[3] = es;
        this.borders[4] = e;
        this.borders[5] = es;
        this.borders[6] = e;
        this.borders[7] = es;
        this.borders[8] = es;
        this.borders[9] = es;
    }

    public ButtonStateBorder(Border e, Border ep, Border es, Border eps, Border d, Border ds, Border i, Border is, Border di, Border dis) {
        this.borders = new Border[11];
        this.borders[0] = e;
        this.borders[1] = ep;
        this.borders[2] = es;
        this.borders[3] = eps;
        this.borders[4] = d;
        this.borders[5] = ds;
        this.borders[6] = i;
        this.borders[7] = is;
        this.borders[8] = dis;
        this.borders[9] = dis;
    }

    public ButtonStateBorder(Border[] borders) {
        this.borders = new Border[11];
        System.arraycopy(borders, 0, this.borders, 0, Math.min(borders.length, this.borders.length));
    }

    public ButtonStateBorder(Image tiledImage, int tileCount, boolean isTiledHorizontaly, Insets imageInsets, Insets borderInsets, boolean fill) {
        this.tiledImage = tiledImage;
        this.tileCount = tileCount;
        this.isTiledHorizontaly = isTiledHorizontaly;
        this.imageInsets = imageInsets;
        this.borderInsets = borderInsets;
        this.fill = fill;
    }

    public void setBorder(int key, Border b) {
        this.borders[key] = b;
    }

    public Insets getBorderInsets(Component c) {
        if (this.borderInsets != null) {
            return (Insets)this.borderInsets.clone();
        }
        return (Insets)this.borders[0].getBorderInsets(c).clone();
    }

    public boolean isBorderOpaque() {
        return this.borders[0].isBorderOpaque();
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Border border = this.getBorder(c);
        if (border != null) {
            border.paintBorder(c, g, x, y, width, height);
        }
    }

    protected Border getBorder(Component c) {
        Border border;
        boolean isActive = true;
        if (c instanceof AbstractButton) {
            ButtonModel model = ((AbstractButton)c).getModel();
            border = isActive ? (model.isEnabled() ? (model.isPressed() && model.isArmed() ? (model.isSelected() ? this.borders[3] : this.borders[1]) : (model.isSelected() ? this.borders[2] : (!model.isPressed() && this.borders[10] != null && c instanceof JButton && ((JButton)c).isDefaultButton() ? this.borders[10] : this.borders[0]))) : (model.isSelected() ? this.borders[5] : this.borders[4])) : (model.isEnabled() ? (model.isSelected() ? this.borders[7] : this.borders[6]) : (model.isSelected() ? this.borders[9] : this.borders[8]));
        } else {
            border = isActive ? (c.isEnabled() ? this.borders[0] : this.borders[4]) : (c.isEnabled() ? this.borders[6] : this.borders[8]);
        }
        return border;
    }
}

