/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.gui.image;

import ch.randelshofer.gui.image.HAMColorModel;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;

public class Bitmap
implements Cloneable {
    private byte[] bitmap_;
    private int width_;
    private int height_;
    private int depth_;
    private int bitplaneStride_;
    private int scanlineStride_;
    private ColorModel planarColorModel_;
    private ColorModel preferredChunkyColorModel_;
    private ColorModel currentChunkyColorModel_;
    private ColorModel lastPixelColorModel_;
    private int pixelType_;
    public static final int BYTE_PIXEL = 1;
    public static final int INT_PIXEL = 2;
    public static final int NO_PIXEL = 0;
    private byte[] bytePixels_;
    private int[] intPixels_;
    private boolean enforceDirectColors_ = false;

    public void setEnforceDirectColors(boolean b) {
        this.enforceDirectColors_ = b;
    }

    public boolean isEnforceDirectColors() {
        return this.enforceDirectColors_;
    }

    public Bitmap(int width, int height, int depth, ColorModel colorModel) {
        this(width, height, depth, colorModel, true);
    }

    public Bitmap(int width, int height, int depth, ColorModel colorModel, boolean isInterleaved) {
        this.width_ = width;
        this.height_ = height;
        this.depth_ = depth;
        this.planarColorModel_ = colorModel;
        if (isInterleaved) {
            this.bitplaneStride_ = (this.width_ + 15) / 16 * 2;
            this.scanlineStride_ = this.bitplaneStride_ * this.depth_;
            this.bitmap_ = new byte[this.scanlineStride_ * this.height_];
        } else {
            this.scanlineStride_ = (this.width_ + 15) / 16 * 2;
            this.bitplaneStride_ = this.scanlineStride_ * this.depth_;
            this.bitmap_ = new byte[this.bitplaneStride_ * this.height_];
        }
        this.pixelType_ = 0;
    }

    public Bitmap(int width, int height, int depth, ColorModel colorModel, int bitStride, int scanlineStride) {
        this.width_ = width;
        this.height_ = height;
        this.depth_ = depth;
        this.planarColorModel_ = colorModel;
        this.bitplaneStride_ = bitStride;
        this.scanlineStride_ = scanlineStride;
        this.bitmap_ = this.bitplaneStride_ < this.scanlineStride_ ? new byte[this.scanlineStride_ * this.height_] : new byte[this.bitplaneStride_ * this.height_];
        this.pixelType_ = 0;
    }

    public int getWidth() {
        return this.width_;
    }

    public int getHeight() {
        return this.height_;
    }

    public int getDepth() {
        return this.depth_;
    }

    public int getScanlineStride() {
        return this.scanlineStride_;
    }

    public int getBitplaneStride() {
        return this.bitplaneStride_;
    }

    public void setPlanarColorModel(ColorModel colorModel) {
        this.planarColorModel_ = colorModel;
    }

    public ColorModel getPlanarColorModel() {
        return this.planarColorModel_;
    }

    public void setPreferredChunkyColorModel(ColorModel colorModel) {
        this.preferredChunkyColorModel_ = colorModel;
    }

    public ColorModel getChunkyColorModel() {
        if (this.currentChunkyColorModel_ == null) {
            this.convertToChunky(0, 0, 0, 0);
        }
        return this.currentChunkyColorModel_;
    }

    public byte[] getBitmap() {
        return this.bitmap_;
    }

    public byte[] getBytePixels() {
        if (this.pixelType_ == 1) {
            return this.bytePixels_;
        }
        return null;
    }

    public int[] getIntPixels() {
        if (this.pixelType_ == 2) {
            return this.intPixels_;
        }
        return null;
    }

    public int getPixelType() {
        return this.pixelType_;
    }

    public Object clone() {
        try {
            Bitmap theClone = (Bitmap)super.clone();
            theClone.bitmap_ = (byte[])this.bitmap_.clone();
            if (this.getPixelType() == 1) {
                theClone.bytePixels_ = (byte[])this.bytePixels_.clone();
            }
            if (this.getPixelType() == 2) {
                theClone.intPixels_ = (int[])this.intPixels_.clone();
            }
            return theClone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public int convertToChunky() {
        return this.convertToChunky(0, 0, this.getHeight() - 1, this.getWidth() - 1);
    }

    public int convertToChunky(int top, int left, int bottom, int right) {
        this.pixelType_ = 0;
        if (top < 0) {
            top = 0;
        }
        if (left < 0) {
            left = 0;
        }
        if (bottom > this.getHeight() - 1) {
            bottom = this.getHeight() - 1;
        }
        if (right > this.getWidth() - 1) {
            right = this.getWidth() - 1;
        }
        if (this.planarColorModel_ instanceof HAMColorModel) {
            if (this.intPixels_ == null || this.intPixels_.length != this.getWidth() * this.getHeight()) {
                this.bytePixels_ = null;
                this.intPixels_ = new int[this.getWidth() * this.getHeight()];
            }
            this.currentChunkyColorModel_ = this.planarColorModel_;
            if (((HAMColorModel)this.planarColorModel_).getHAMType() == 6) {
                this.ham6PlanesToDirectPixels(top, left, bottom, right);
            } else if (((HAMColorModel)this.planarColorModel_).getHAMType() == 8) {
                this.ham8PlanesToDirectPixels(top, left, bottom, right);
            } else {
                throw new InternalError("unsupported ham model:" + this.planarColorModel_);
            }
            this.pixelType_ = 2;
        } else if (this.planarColorModel_ instanceof IndexColorModel) {
            if (this.enforceDirectColors_ || this.preferredChunkyColorModel_ instanceof DirectColorModel) {
                if (this.intPixels_ == null || this.intPixels_.length != this.getWidth() * this.getHeight()) {
                    this.bytePixels_ = null;
                    this.intPixels_ = new int[this.getWidth() * this.getHeight()];
                }
                this.currentChunkyColorModel_ = this.preferredChunkyColorModel_ != null && this.preferredChunkyColorModel_ instanceof DirectColorModel ? this.preferredChunkyColorModel_ : ColorModel.getRGBdefault();
                this.currentChunkyColorModel_ = new DirectColorModel(24, 0xFF0000, 65280, 255);
                this.indexPlanesToDirectPixels(top, left, bottom, right);
                this.pixelType_ = 2;
            } else {
                if (this.bytePixels_ == null || this.bytePixels_.length != this.getWidth() * this.getHeight()) {
                    this.intPixels_ = null;
                    this.bytePixels_ = new byte[this.getWidth() * this.getHeight()];
                }
                this.currentChunkyColorModel_ = this.planarColorModel_;
                this.indexPlanesToIndexPixels(top, left, bottom, right);
                this.pixelType_ = 1;
            }
        } else if (this.planarColorModel_ instanceof DirectColorModel) {
            if (this.intPixels_ == null || this.intPixels_.length != this.getWidth() * this.getHeight()) {
                this.bytePixels_ = null;
                this.intPixels_ = new int[this.getWidth() * this.getHeight()];
            }
            this.currentChunkyColorModel_ = this.planarColorModel_;
            this.directPlanesToDirectPixels(top, left, bottom, right);
            this.pixelType_ = 2;
        } else {
            throw new InternalError("unsupported color model:" + this.planarColorModel_);
        }
        return this.pixelType_;
    }

    public void flushPixels() {
        this.pixelType_ = 0;
        this.intPixels_ = null;
        this.bytePixels_ = null;
    }

    private void indexPlanesToIndexPixels(int top, int left, int bottom, int right) {
        ++bottom;
        int scanlineStride = this.getScanlineStride();
        int bitplaneStride = this.getBitplaneStride();
        int depth = this.getDepth();
        int width = this.getWidth();
        int pixelLineStride = width - ++right + left;
        int bottomScanline = bottom * scanlineStride;
        int iPixel = top * width + left;
        int pixel = 0;
        byte b7 = 0;
        byte b6 = 0;
        byte b5 = 0;
        byte b4 = 0;
        byte b3 = 0;
        byte b2 = 0;
        byte b1 = 0;
        byte b0 = 0;
        int bitplaneStride1 = bitplaneStride;
        int bitplaneStride2 = bitplaneStride * 2;
        int bitplaneStride3 = bitplaneStride * 3;
        int bitplaneStride4 = bitplaneStride * 4;
        int bitplaneStride5 = bitplaneStride * 5;
        int bitplaneStride6 = bitplaneStride * 6;
        int bitplaneStride7 = bitplaneStride * 7;
        switch (depth) {
            case 1: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        this.bytePixels_[iPixel++] = (byte)((this.bitmap_[iScanline + (x >>> 3)] << (x & 7) & 0x80) >>> 7);
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            case 2: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        this.bytePixels_[iPixel++] = (byte)((this.bitmap_[iBitmap] & bitMask | (this.bitmap_[iBitmap + bitplaneStride1] & bitMask) << 1) >>> 7 - iBit);
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            case 3: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        this.bytePixels_[iPixel++] = (byte)((this.bitmap_[iBitmap] & bitMask | (this.bitmap_[iBitmap + bitplaneStride1] & bitMask) << 1 | (this.bitmap_[iBitmap + bitplaneStride2] & bitMask) << 2) >>> 7 - iBit);
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            case 4: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        this.bytePixels_[iPixel++] = (byte)((this.bitmap_[iBitmap] & bitMask | (this.bitmap_[iBitmap + bitplaneStride1] & bitMask) << 1 | (this.bitmap_[iBitmap + bitplaneStride2] & bitMask) << 2 | (this.bitmap_[iBitmap + bitplaneStride3] & bitMask) << 3) >>> 7 - iBit);
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            case 5: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        if (iBit == 0) {
                            b0 = this.bitmap_[iBitmap];
                            b1 = this.bitmap_[iBitmap + bitplaneStride];
                            b2 = this.bitmap_[iBitmap + bitplaneStride2];
                            b3 = this.bitmap_[iBitmap + bitplaneStride3];
                            b4 = this.bitmap_[iBitmap + bitplaneStride4];
                        }
                        this.bytePixels_[iPixel++] = (byte)((b0 & bitMask | (b1 & bitMask) << 1 | (b2 & bitMask) << 2 | (b3 & bitMask) << 3 | (b4 & bitMask) << 4) >>> 7 - iBit);
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            case 6: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        if (iBit == 0) {
                            b0 = this.bitmap_[iBitmap];
                            b1 = this.bitmap_[iBitmap + bitplaneStride];
                            b2 = this.bitmap_[iBitmap + bitplaneStride2];
                            b3 = this.bitmap_[iBitmap + bitplaneStride3];
                            b4 = this.bitmap_[iBitmap + bitplaneStride4];
                            b5 = this.bitmap_[iBitmap + bitplaneStride5];
                        }
                        this.bytePixels_[iPixel++] = (byte)((b0 & bitMask | (b1 & bitMask) << 1 | (b2 & bitMask) << 2 | (b3 & bitMask) << 3 | (b4 & bitMask) << 4 | (b5 & bitMask) << 5) >>> 7 - iBit);
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            case 7: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        if (iBit == 0) {
                            b0 = this.bitmap_[iBitmap];
                            b1 = this.bitmap_[iBitmap + bitplaneStride];
                            b2 = this.bitmap_[iBitmap + bitplaneStride2];
                            b3 = this.bitmap_[iBitmap + bitplaneStride3];
                            b4 = this.bitmap_[iBitmap + bitplaneStride4];
                            b5 = this.bitmap_[iBitmap + bitplaneStride5];
                            b6 = this.bitmap_[iBitmap + bitplaneStride6];
                        }
                        this.bytePixels_[iPixel++] = (byte)((b0 & bitMask | (b1 & bitMask) << 1 | (b2 & bitMask) << 2 | (b3 & bitMask) << 3 | (b4 & bitMask) << 4 | (b5 & bitMask) << 5 | (b6 & bitMask) << 6) >>> 7 - iBit);
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            case 8: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        if (iBit == 0) {
                            b0 = this.bitmap_[iBitmap];
                            b1 = this.bitmap_[iBitmap + bitplaneStride];
                            b2 = this.bitmap_[iBitmap + bitplaneStride2];
                            b3 = this.bitmap_[iBitmap + bitplaneStride3];
                            b4 = this.bitmap_[iBitmap + bitplaneStride4];
                            b5 = this.bitmap_[iBitmap + bitplaneStride5];
                            b6 = this.bitmap_[iBitmap + bitplaneStride6];
                            b7 = this.bitmap_[iBitmap + bitplaneStride7];
                        }
                        this.bytePixels_[iPixel++] = (byte)((b0 & bitMask | (b1 & bitMask) << 1 | (b2 & bitMask) << 2 | (b3 & bitMask) << 3 | (b4 & bitMask) << 4 | (b5 & bitMask) << 5 | (b6 & bitMask) << 6 | (b7 & bitMask) << 7) >>> 7 - iBit);
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            default: {
                for (int iScanline = top * scanlineStride + scanlineStride; iScanline <= bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        pixel = 0;
                        for (int iDepth = 0; iDepth < depth; ++iDepth) {
                            pixel = pixel << 1 | this.bitmap_[iBitmap -= bitplaneStride] & bitMask;
                        }
                        this.bytePixels_[iPixel++] = (byte)(pixel >>> 7 - iBit);
                    }
                    iPixel += pixelLineStride;
                }
            }
        }
    }

    private void indexPlanesToDirectPixels(int top, int left, int bottom, int right) {
        IndexColorModel colorModel = (IndexColorModel)this.planarColorModel_;
        int[] clut = new int[colorModel.getMapSize()];
        IndexColorModel icm = (IndexColorModel)this.planarColorModel_;
        byte[] reds = new byte[clut.length];
        byte[] greens = new byte[clut.length];
        byte[] blues = new byte[clut.length];
        icm.getReds(reds);
        icm.getGreens(greens);
        icm.getBlues(blues);
        for (int i = 0; i < clut.length; ++i) {
            clut[i] = 0xFF000000 | (reds[i] & 0xFF) << 16 | (greens[i] & 0xFF) << 8 | blues[i] & 0xFF;
        }
        if (clut.length < 1 << this.getDepth()) {
            throw new IndexOutOfBoundsException("Clut must not be smaller than depth");
        }
        ++bottom;
        int scanlineStride = this.getScanlineStride();
        int bitplaneStride = this.getBitplaneStride();
        int depth = this.getDepth();
        int width = this.getWidth();
        int pixelLineStride = width - ++right + left;
        int bottomScanline = bottom * scanlineStride;
        int iPixel = top * width + left;
        int pixel = 0;
        int bitplaneStride1 = bitplaneStride;
        int bitplaneStride2 = bitplaneStride * 2;
        int bitplaneStride3 = bitplaneStride * 3;
        int bitplaneStride4 = bitplaneStride * 4;
        int bitplaneStride5 = bitplaneStride * 5;
        int bitplaneStride6 = bitplaneStride * 6;
        int bitplaneStride7 = bitplaneStride * 7;
        byte b7 = 0;
        byte b6 = 0;
        byte b5 = 0;
        byte b4 = 0;
        byte b3 = 0;
        byte b2 = 0;
        byte b1 = 0;
        byte b0 = 0;
        switch (depth) {
            case 1: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        this.intPixels_[iPixel++] = clut[(this.bitmap_[iScanline + (x >>> 3)] << (x & 7) & 0x80) >>> 7];
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            case 2: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        this.intPixels_[iPixel++] = clut[(this.bitmap_[iBitmap] & bitMask | (this.bitmap_[iBitmap + bitplaneStride1] & bitMask) << 1) >>> 7 - iBit];
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            case 3: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        this.intPixels_[iPixel++] = clut[(this.bitmap_[iBitmap] & bitMask | (this.bitmap_[iBitmap + bitplaneStride1] & bitMask) << 1 | (this.bitmap_[iBitmap + bitplaneStride2] & bitMask) << 2) >>> 7 - iBit];
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            case 4: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        this.intPixels_[iPixel++] = clut[(this.bitmap_[iBitmap] & bitMask | (this.bitmap_[iBitmap + bitplaneStride1] & bitMask) << 1 | (this.bitmap_[iBitmap + bitplaneStride2] & bitMask) << 2 | (this.bitmap_[iBitmap + bitplaneStride3] & bitMask) << 3) >>> 7 - iBit];
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            case 5: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        if (iBit == 0) {
                            b0 = this.bitmap_[iBitmap];
                            b1 = this.bitmap_[iBitmap + bitplaneStride];
                            b2 = this.bitmap_[iBitmap + bitplaneStride2];
                            b3 = this.bitmap_[iBitmap + bitplaneStride3];
                            b4 = this.bitmap_[iBitmap + bitplaneStride4];
                        }
                        this.intPixels_[iPixel++] = clut[(b0 & bitMask | (b1 & bitMask) << 1 | (b2 & bitMask) << 2 | (b3 & bitMask) << 3 | (b4 & bitMask) << 4) >>> 7 - iBit];
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            case 6: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        if (iBit == 0) {
                            b0 = this.bitmap_[iBitmap];
                            b1 = this.bitmap_[iBitmap + bitplaneStride];
                            b2 = this.bitmap_[iBitmap + bitplaneStride2];
                            b3 = this.bitmap_[iBitmap + bitplaneStride3];
                            b4 = this.bitmap_[iBitmap + bitplaneStride4];
                            b5 = this.bitmap_[iBitmap + bitplaneStride5];
                        }
                        this.intPixels_[iPixel++] = clut[(b0 & bitMask | (b1 & bitMask) << 1 | (b2 & bitMask) << 2 | (b3 & bitMask) << 3 | (b4 & bitMask) << 4 | (b5 & bitMask) << 5) >>> 7 - iBit];
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            case 7: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        if (iBit == 0) {
                            b0 = this.bitmap_[iBitmap];
                            b1 = this.bitmap_[iBitmap + bitplaneStride];
                            b2 = this.bitmap_[iBitmap + bitplaneStride2];
                            b3 = this.bitmap_[iBitmap + bitplaneStride3];
                            b4 = this.bitmap_[iBitmap + bitplaneStride4];
                            b5 = this.bitmap_[iBitmap + bitplaneStride5];
                            b6 = this.bitmap_[iBitmap + bitplaneStride6];
                        }
                        this.intPixels_[iPixel++] = clut[(b0 & bitMask | (b1 & bitMask) << 1 | (b2 & bitMask) << 2 | (b3 & bitMask) << 3 | (b4 & bitMask) << 4 | (b5 & bitMask) << 5 | (b6 & bitMask) << 6) >>> 7 - iBit];
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            case 8: {
                for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        if (iBit == 0) {
                            b0 = this.bitmap_[iBitmap];
                            b1 = this.bitmap_[iBitmap + bitplaneStride];
                            b2 = this.bitmap_[iBitmap + bitplaneStride2];
                            b3 = this.bitmap_[iBitmap + bitplaneStride3];
                            b4 = this.bitmap_[iBitmap + bitplaneStride4];
                            b5 = this.bitmap_[iBitmap + bitplaneStride5];
                            b6 = this.bitmap_[iBitmap + bitplaneStride6];
                            b7 = this.bitmap_[iBitmap + bitplaneStride7];
                        }
                        this.intPixels_[iPixel++] = clut[(b0 & bitMask | (b1 & bitMask) << 1 | (b2 & bitMask) << 2 | (b3 & bitMask) << 3 | (b4 & bitMask) << 4 | (b5 & bitMask) << 5 | (b6 & bitMask) << 6 | (b7 & bitMask) << 7) >>> 7 - iBit];
                    }
                    iPixel += pixelLineStride;
                }
                break;
            }
            default: {
                for (int iScanline = top * scanlineStride + scanlineStride; iScanline <= bottomScanline; iScanline += scanlineStride) {
                    for (int x = left; x < right; ++x) {
                        int iBit = x & 7;
                        int bitMask = 128 >>> iBit;
                        int iBitmap = iScanline + (x >>> 3);
                        pixel = 0;
                        for (int iDepth = 0; iDepth < depth; ++iDepth) {
                            pixel = pixel << 1 | this.bitmap_[iBitmap -= bitplaneStride] & bitMask;
                        }
                        this.intPixels_[iPixel++] = clut[pixel >>> 7 - iBit];
                    }
                    iPixel += pixelLineStride;
                }
            }
        }
    }

    private void directPlanesToDirectPixels(int top, int left, int bottom, int right) {
        ++bottom;
        int scanlineStride = this.getScanlineStride();
        int bitplaneStride = this.getBitplaneStride();
        int depth = this.getDepth();
        int width = this.getWidth();
        int pixelLineStride = width - ++right + left;
        int bottomScanline = bottom * scanlineStride;
        int iPixel = top * width + left;
        boolean pixel = false;
        int bitplaneStride2 = bitplaneStride * 2;
        int bitplaneStride3 = bitplaneStride * 3;
        int bitplaneStride4 = bitplaneStride * 4;
        int bitplaneStride5 = bitplaneStride * 5;
        int bitplaneStride6 = bitplaneStride * 6;
        int bitplaneStride7 = bitplaneStride * 7;
        int bitplaneStride8 = bitplaneStride * 8;
        int bitplaneStride9 = bitplaneStride * 9;
        int bitplaneStride10 = bitplaneStride * 10;
        int bitplaneStride11 = bitplaneStride * 11;
        int bitplaneStride12 = bitplaneStride * 12;
        int bitplaneStride13 = bitplaneStride * 13;
        int bitplaneStride14 = bitplaneStride * 14;
        int bitplaneStride15 = bitplaneStride * 15;
        int bitplaneStride16 = bitplaneStride * 16;
        int bitplaneStride17 = bitplaneStride * 17;
        int bitplaneStride18 = bitplaneStride * 18;
        int bitplaneStride19 = bitplaneStride * 19;
        int bitplaneStride20 = bitplaneStride * 20;
        int bitplaneStride21 = bitplaneStride * 21;
        int bitplaneStride22 = bitplaneStride * 22;
        int bitplaneStride23 = bitplaneStride * 23;
        int iBitmap = top * scanlineStride + left / 8;
        byte b0 = this.bitmap_[iBitmap];
        byte b1 = this.bitmap_[iBitmap + bitplaneStride];
        byte b2 = this.bitmap_[iBitmap + bitplaneStride2];
        byte b3 = this.bitmap_[iBitmap + bitplaneStride4];
        byte b4 = this.bitmap_[iBitmap + bitplaneStride4];
        byte b5 = this.bitmap_[iBitmap + bitplaneStride5];
        byte b6 = this.bitmap_[iBitmap + bitplaneStride6];
        byte b7 = this.bitmap_[iBitmap + bitplaneStride7];
        byte b8 = this.bitmap_[iBitmap + bitplaneStride8];
        byte b9 = this.bitmap_[iBitmap + bitplaneStride9];
        byte b10 = this.bitmap_[iBitmap + bitplaneStride10];
        byte b11 = this.bitmap_[iBitmap + bitplaneStride11];
        byte b12 = this.bitmap_[iBitmap + bitplaneStride12];
        byte b13 = this.bitmap_[iBitmap + bitplaneStride13];
        byte b14 = this.bitmap_[iBitmap + bitplaneStride14];
        byte b15 = this.bitmap_[iBitmap + bitplaneStride15];
        byte b16 = this.bitmap_[iBitmap + bitplaneStride16];
        byte b17 = this.bitmap_[iBitmap + bitplaneStride17];
        byte b18 = this.bitmap_[iBitmap + bitplaneStride18];
        byte b19 = this.bitmap_[iBitmap + bitplaneStride19];
        byte b20 = this.bitmap_[iBitmap + bitplaneStride20];
        byte b21 = this.bitmap_[iBitmap + bitplaneStride21];
        byte b22 = this.bitmap_[iBitmap + bitplaneStride22];
        byte b23 = this.bitmap_[iBitmap + bitplaneStride23];
        for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
            for (int x = left; x < right; ++x) {
                int iBit = x & 7;
                int bitMask = 128 >>> iBit;
                iBitmap = iScanline + (x >>> 3);
                if (iBit == 0) {
                    b0 = this.bitmap_[iBitmap];
                    b1 = this.bitmap_[iBitmap + bitplaneStride];
                    b2 = this.bitmap_[iBitmap + bitplaneStride2];
                    b3 = this.bitmap_[iBitmap + bitplaneStride3];
                    b4 = this.bitmap_[iBitmap + bitplaneStride4];
                    b5 = this.bitmap_[iBitmap + bitplaneStride5];
                    b6 = this.bitmap_[iBitmap + bitplaneStride6];
                    b7 = this.bitmap_[iBitmap + bitplaneStride7];
                    b8 = this.bitmap_[iBitmap + bitplaneStride8];
                    b9 = this.bitmap_[iBitmap + bitplaneStride9];
                    b10 = this.bitmap_[iBitmap + bitplaneStride10];
                    b11 = this.bitmap_[iBitmap + bitplaneStride11];
                    b12 = this.bitmap_[iBitmap + bitplaneStride12];
                    b13 = this.bitmap_[iBitmap + bitplaneStride13];
                    b14 = this.bitmap_[iBitmap + bitplaneStride14];
                    b15 = this.bitmap_[iBitmap + bitplaneStride15];
                    b16 = this.bitmap_[iBitmap + bitplaneStride16];
                    b17 = this.bitmap_[iBitmap + bitplaneStride17];
                    b18 = this.bitmap_[iBitmap + bitplaneStride18];
                    b19 = this.bitmap_[iBitmap + bitplaneStride19];
                    b20 = this.bitmap_[iBitmap + bitplaneStride20];
                    b21 = this.bitmap_[iBitmap + bitplaneStride21];
                    b22 = this.bitmap_[iBitmap + bitplaneStride22];
                    b23 = this.bitmap_[iBitmap + bitplaneStride23];
                }
                this.intPixels_[iPixel++] = ((b0 & bitMask) << 16 | (b1 & bitMask) << 17 | (b2 & bitMask) << 18 | (b3 & bitMask) << 19 | (b4 & bitMask) << 20 | (b5 & bitMask) << 21 | (b6 & bitMask) << 22 | (b7 & bitMask) << 23 | (b8 & bitMask) << 8 | (b9 & bitMask) << 9 | (b10 & bitMask) << 10 | (b11 & bitMask) << 11 | (b12 & bitMask) << 12 | (b13 & bitMask) << 13 | (b14 & bitMask) << 14 | (b15 & bitMask) << 15 | b16 & bitMask | (b17 & bitMask) << 1 | (b18 & bitMask) << 2 | (b19 & bitMask) << 3 | (b20 & bitMask) << 4 | (b21 & bitMask) << 5 | (b22 & bitMask) << 6 | (b23 & bitMask) << 7) >>> 7 - iBit;
            }
            iPixel += pixelLineStride;
        }
    }

    private void ham6PlanesToDirectPixels(int top, int left, int bottom, int right) {
        ++bottom;
        ++right;
        int[] HAMColors = new int[((HAMColorModel)this.planarColorModel_).getMapSize()];
        ((HAMColorModel)this.planarColorModel_).getRGBs(HAMColors);
        int scanlineStride = this.getScanlineStride();
        int bitplaneStride = this.getBitplaneStride();
        int depth = this.getDepth();
        int width = this.getWidth();
        int pixelLineStride = width - right + left;
        int bottomScanline = bottom * scanlineStride;
        int iPixel = top * width + left;
        int iLastPixel = top * width + left - 1;
        int pixel = 0;
        int bitplaneStride1 = bitplaneStride;
        int bitplaneStride2 = bitplaneStride * 2;
        int bitplaneStride3 = bitplaneStride * 3;
        int bitplaneStride4 = bitplaneStride * 4;
        int bitplaneStride5 = bitplaneStride * 5;
        int b5 = 0;
        int b4 = 0;
        int b3 = 0;
        int b2 = 0;
        int b1 = 0;
        int b0 = 0;
        for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
            int lastPixel;
            if (left == 0) {
                lastPixel = -16777216;
            } else {
                lastPixel = this.intPixels_[iLastPixel];
                iLastPixel += width;
            }
            block6: for (int x = left; x < right; ++x) {
                int iBit = x & 7;
                int bitMask = 128 >>> iBit;
                int iBitmap = iScanline + (x >>> 3);
                if (iBit == 0) {
                    b0 = this.bitmap_[iBitmap];
                    b1 = this.bitmap_[iBitmap + bitplaneStride];
                    b2 = this.bitmap_[iBitmap + bitplaneStride2];
                    b3 = this.bitmap_[iBitmap + bitplaneStride3];
                    b4 = this.bitmap_[iBitmap + bitplaneStride4];
                    b5 = this.bitmap_[iBitmap + bitplaneStride5];
                }
                pixel = (b0 & bitMask | (b1 & bitMask) << 1 | (b2 & bitMask) << 2 | (b3 & bitMask) << 3) >>> 7 - iBit;
                switch ((b4 & bitMask | (b5 & bitMask) << 1) >>> 7 - iBit) {
                    case 0: {
                        this.intPixels_[iPixel++] = lastPixel = HAMColors[pixel];
                        continue block6;
                    }
                    case 1: {
                        this.intPixels_[iPixel++] = lastPixel = lastPixel & 0xFFFFFF00 | pixel | pixel << 4;
                        continue block6;
                    }
                    case 2: {
                        this.intPixels_[iPixel++] = lastPixel = lastPixel & 0xFF00FFFF | pixel << 16 | pixel << 20;
                        continue block6;
                    }
                    default: {
                        this.intPixels_[iPixel++] = lastPixel = lastPixel & 0xFFFF00FF | pixel << 8 | pixel << 12;
                    }
                }
            }
            iPixel += pixelLineStride;
        }
    }

    private void ham8PlanesToDirectPixels(int top, int left, int bottom, int right) {
        ++bottom;
        ++right;
        int[] HAMColors = new int[((HAMColorModel)this.planarColorModel_).getMapSize()];
        ((HAMColorModel)this.planarColorModel_).getRGBs(HAMColors);
        int scanlineStride = this.getScanlineStride();
        int bitplaneStride = this.getBitplaneStride();
        int depth = this.getDepth();
        int width = this.getWidth();
        int pixelLineStride = width - right + left;
        int bottomScanline = bottom * scanlineStride;
        int iPixel = top * width + left;
        int iLastPixel = top * width + left - 1;
        int pixel = 0;
        int bitplaneStride1 = bitplaneStride;
        int bitplaneStride2 = bitplaneStride * 2;
        int bitplaneStride3 = bitplaneStride * 3;
        int bitplaneStride4 = bitplaneStride * 4;
        int bitplaneStride5 = bitplaneStride * 5;
        int bitplaneStride6 = bitplaneStride * 6;
        int bitplaneStride7 = bitplaneStride * 7;
        int iBitmap = top * scanlineStride + left / 8;
        int b7 = 0;
        int b6 = 0;
        int b5 = 0;
        int b4 = 0;
        int b3 = 0;
        int b2 = 0;
        int b1 = 0;
        int b0 = 0;
        for (int iScanline = top * scanlineStride; iScanline < bottomScanline; iScanline += scanlineStride) {
            int lastPixel;
            if (left == 0) {
                lastPixel = -16777216;
            } else {
                lastPixel = this.intPixels_[iLastPixel];
                iLastPixel += width;
            }
            block6: for (int x = left; x < right; ++x) {
                int iBit = x & 7;
                int bitMask = 128 >>> iBit;
                iBitmap = iScanline + (x >>> 3);
                if (iBit == 0) {
                    b0 = this.bitmap_[iBitmap];
                    b1 = this.bitmap_[iBitmap + bitplaneStride];
                    b2 = this.bitmap_[iBitmap + bitplaneStride2];
                    b3 = this.bitmap_[iBitmap + bitplaneStride3];
                    b4 = this.bitmap_[iBitmap + bitplaneStride4];
                    b5 = this.bitmap_[iBitmap + bitplaneStride5];
                    b6 = this.bitmap_[iBitmap + bitplaneStride6];
                    b7 = this.bitmap_[iBitmap + bitplaneStride7];
                }
                pixel = (b0 & bitMask | (b1 & bitMask) << 1 | (b2 & bitMask) << 2 | (b3 & bitMask) << 3 | (b4 & bitMask) << 4 | (b5 & bitMask) << 5) >>> 7 - iBit;
                switch ((b6 & bitMask | (b7 & bitMask) << 1) >>> 7 - iBit) {
                    case 0: {
                        this.intPixels_[iPixel++] = lastPixel = HAMColors[pixel];
                        continue block6;
                    }
                    case 1: {
                        this.intPixels_[iPixel++] = lastPixel = lastPixel & 0xFFFFFF00 | pixel << 2 | pixel >>> 4;
                        continue block6;
                    }
                    case 2: {
                        this.intPixels_[iPixel++] = lastPixel = lastPixel & 0xFF00FFFF | pixel << 18 | (pixel & 3) << 16;
                        continue block6;
                    }
                    default: {
                        this.intPixels_[iPixel++] = lastPixel = lastPixel & 0xFFFF00FF | pixel << 10 | (pixel & 3) << 8;
                    }
                }
            }
            iPixel += pixelLineStride;
        }
    }
}

