/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.media.anim;

import ch.randelshofer.gui.image.HAMColorModel;
import ch.randelshofer.media.anim.ANIMAudioCommand;
import ch.randelshofer.media.anim.ANIMDeltaFrame;
import ch.randelshofer.media.anim.ANIMFrame;
import ch.randelshofer.media.anim.ANIMKeyFrame;
import ch.randelshofer.media.anim.ANIMMovieTrack;
import ch.randelshofer.media.eightsvx.EightSVXDecoder;
import ch.randelshofer.media.iff.IFFChunk;
import ch.randelshofer.media.iff.IFFParser;
import ch.randelshofer.media.iff.IFFVisitor;
import ch.randelshofer.media.iff.MC68000InputStream;
import ch.randelshofer.media.ilbm.CRNGColorCycle;
import ch.randelshofer.media.ilbm.DRNGColorCycle;
import ch.randelshofer.util.AbortException;
import ch.randelshofer.util.ParseException;
import java.applet.AudioClip;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;

public class ANIMDecoder
implements IFFVisitor {
    private static final int ILBM_ID = IFFParser.stringToID("ILBM");
    private static final int BMHD_ID = IFFParser.stringToID("BMHD");
    private static final int CMAP_ID = IFFParser.stringToID("CMAP");
    private static final int CAMG_ID = IFFParser.stringToID("CAMG");
    private static final int CRNG_ID = IFFParser.stringToID("CRNG");
    private static final int DRNG_ID = IFFParser.stringToID("DRNG");
    private static final int BODY_ID = IFFParser.stringToID("BODY");
    private static final int ANHD_ID = IFFParser.stringToID("ANHD");
    private static final int DLTA_ID = IFFParser.stringToID("DLTA");
    private static final int ANIM_ID = IFFParser.stringToID("ANIM");
    private static final int COPYRIGHT_ID = IFFParser.stringToID("(c) ");
    private static final int AUTH_ID = IFFParser.stringToID("AUTH");
    private static final int ANNO_ID = IFFParser.stringToID("ANNO");
    private static final int ANFI_ID = IFFParser.stringToID("ANFI");
    private static final int SCTL_ID = IFFParser.stringToID("SCTL");
    protected static final int MONITOR_ID_MASK = -61440;
    protected static final int DEFAULT_MONITOR_ID = 0;
    protected static final int NTSC_MONITOR_ID = 69632;
    protected static final int PAL_MONITOR_ID = 135168;
    protected static final int VGA_MONITOR_ID = 200704;
    protected static final int A2024_MONITOR_ID = 266240;
    protected static final int PROTO_MONITOR_ID = 331776;
    protected static final int EURO72_MONITOR_ID = 397312;
    protected static final int EURO36_MONITOR_ID = 462848;
    protected static final int SUPER72_MONITOR_ID = 528384;
    protected static final int DBLNTSC_MONITOR_ID = 593920;
    protected static final int DBLPAL_MONITOR_ID = 4096;
    protected static final int HAM_MASK = 2048;
    protected static final int EHB_MASK = 128;
    protected static final int HAM_KEY = 2048;
    protected static final int EXTRAHALFBRITE_KEY = 128;
    private InputStream inputStream_;
    private URL location_;
    private Vector sources_;
    private Hashtable properties_;
    private ColorModel cmapColorModel;
    private ANIMMovieTrack track;
    private int animCount;
    private int index;
    private EightSVXDecoder eightSVXDecoder;
    private byte[] previousCMAPdata_;
    private boolean isInANIM;
    private boolean isInILBM;

    public ANIMDecoder(InputStream inputStream) {
        this.inputStream_ = inputStream;
    }

    public ANIMDecoder(URL location) {
        this.location_ = location;
    }

    public void produce(ANIMMovieTrack track, int n, boolean loadAudio) throws IOException {
        InputStream in = null;
        this.track = track;
        this.index = n;
        this.animCount = 0;
        in = this.inputStream_ != null ? this.inputStream_ : this.location_.openStream();
        try {
            IFFParser iff = new IFFParser();
            this.registerChunks(iff, loadAudio);
            if (loadAudio) {
                this.eightSVXDecoder = new EightSVXDecoder(){

                    public void addAudioClip(AudioClip clip) {
                        super.addAudioClip(clip);
                        ANIMDecoder.this.track.addAudioClip(clip);
                    }
                };
                this.eightSVXDecoder.registerChunks(iff);
            }
            iff.parse(in, this);
        }
        catch (ParseException e) {
            throw new IOException(e.getMessage());
        }
        catch (AbortException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            in.close();
        }
    }

    public void registerChunks(IFFParser iff, boolean loadAudio) {
        iff.declarePropertyChunk(ILBM_ID, BMHD_ID);
        iff.declarePropertyChunk(ILBM_ID, CMAP_ID);
        iff.declarePropertyChunk(ILBM_ID, CAMG_ID);
        iff.declarePropertyChunk(ILBM_ID, ANHD_ID);
        iff.declareCollectionChunk(ILBM_ID, CRNG_ID);
        iff.declareCollectionChunk(ILBM_ID, DRNG_ID);
        if (loadAudio) {
            iff.declarePropertyChunk(ILBM_ID, ANFI_ID);
            iff.declareCollectionChunk(ILBM_ID, SCTL_ID);
        }
        iff.declareGroupChunk(ANIM_ID, 1179603533);
        iff.declareGroupChunk(ILBM_ID, 1179603533);
        iff.declareDataChunk(ILBM_ID, BODY_ID);
        iff.declareDataChunk(ILBM_ID, DLTA_ID);
        iff.declareCollectionChunk(ILBM_ID, AUTH_ID);
        iff.declareCollectionChunk(ILBM_ID, ANNO_ID);
        iff.declareCollectionChunk(ILBM_ID, COPYRIGHT_ID);
    }

    public void enterGroup(IFFChunk chunk) {
        if (chunk.getType() == ANIM_ID) {
            if (this.animCount++ == this.index) {
                this.isInANIM = true;
            }
        } else if (chunk.getType() == ILBM_ID) {
            this.isInILBM = true;
        }
        if (this.isInANIM && this.eightSVXDecoder != null) {
            this.eightSVXDecoder.enterGroup(chunk);
        }
    }

    public void leaveGroup(IFFChunk chunk) {
        if (this.isInANIM && this.eightSVXDecoder != null) {
            this.eightSVXDecoder.leaveGroup(chunk);
        }
        if (chunk.getType() == ANIM_ID) {
            this.isInANIM = false;
        }
        if (chunk.getType() == ILBM_ID) {
            this.isInILBM = false;
        }
    }

    public void visitChunk(IFFChunk group, IFFChunk chunk) throws ParseException, AbortException {
        if (Thread.currentThread().isInterrupted()) {
            throw new AbortException();
        }
        if (this.isInANIM) {
            if (this.eightSVXDecoder != null) {
                this.eightSVXDecoder.visitChunk(group, chunk);
            }
            if (group.getType() == ILBM_ID) {
                if (this.track.getWidth() == 0) {
                    this.decodeBMHD(group.getPropertyChunk(BMHD_ID), this.track);
                    this.decodeCAMG(group.getPropertyChunk(CAMG_ID), this.track);
                    this.decodeColorCycling(group.getCollectionChunks(CRNG_ID), group.getCollectionChunks(DRNG_ID), this.track);
                    this.decodeAUTH(group.getCollectionChunks(AUTH_ID), this.track);
                    this.decodeANNO(group.getCollectionChunks(ANNO_ID), this.track);
                    this.decodeCOPYRIGHT(group.getCollectionChunks(COPYRIGHT_ID), this.track);
                }
                this.track.setPlayWrapupFrames(false);
                ColorModel cm = this.decodeCMAP(group.getPropertyChunk(CMAP_ID), this.track);
                if (cm != null) {
                    this.cmapColorModel = cm;
                }
                if (chunk.getID() == BODY_ID) {
                    this.decodeBODY(this.cmapColorModel, group, chunk, this.track);
                } else if (chunk.getID() == DLTA_ID) {
                    this.decodeDLTA(this.cmapColorModel, group, chunk, this.track);
                }
            }
        } else if (this.isInILBM) {
            if (this.track.getWidth() == 0) {
                this.decodeBMHD(group.getPropertyChunk(BMHD_ID), this.track);
                this.decodeCAMG(group.getPropertyChunk(CAMG_ID), this.track);
                this.decodeColorCycling(group.getCollectionChunks(CRNG_ID), group.getCollectionChunks(DRNG_ID), this.track);
                this.decodeAUTH(group.getCollectionChunks(AUTH_ID), this.track);
                this.decodeANNO(group.getCollectionChunks(ANNO_ID), this.track);
                this.decodeCOPYRIGHT(group.getCollectionChunks(COPYRIGHT_ID), this.track);
            }
            this.track.setPlayWrapupFrames(true);
            ColorModel cm = this.decodeCMAP(group.getPropertyChunk(CMAP_ID), this.track);
            if (cm != null) {
                this.cmapColorModel = cm;
            }
            if (chunk.getID() == BODY_ID) {
                this.decodeBODY(this.cmapColorModel, group, chunk, this.track);
            }
        }
    }

    private void decodeBMHD(IFFChunk chunk, ANIMMovieTrack track) throws ParseException {
        try {
            MC68000InputStream in = new MC68000InputStream(new ByteArrayInputStream(chunk.getData()));
            track.setWidth(in.readUWORD());
            track.setHeight(in.readUWORD());
            track.setXPosition(in.readWORD());
            track.setYPosition(in.readWORD());
            track.setNbPlanes(in.readUBYTE());
            track.setMasking(in.readUBYTE());
            track.setCompression(in.readUBYTE());
            in.skip(1L);
            track.setTransparentColor(in.readUWORD());
            track.setXAspect(in.readUBYTE());
            track.setYAspect(in.readUBYTE());
            track.setPageWidth(in.readWORD());
            track.setPageHeight(in.readWORD());
            in.close();
        }
        catch (IOException e) {
            throw new ParseException(e.toString());
        }
    }

    private void decodeCAMG(IFFChunk chunk, ANIMMovieTrack track) throws ParseException {
        int camgJiffies;
        int camg = 0;
        if (chunk != null) {
            try {
                MC68000InputStream in = new MC68000InputStream(new ByteArrayInputStream(chunk.getData()));
                camg = in.readLONG();
                in.close();
            }
            catch (IOException e) {
                throw new ParseException(e.toString());
            }
        }
        switch (camg & 0x880) {
            case 128: {
                track.setScreenMode(2);
                break;
            }
            case 2048: {
                if (track.getNbPlanes() == 6) {
                    track.setScreenMode(3);
                    break;
                }
                if (track.getNbPlanes() == 8) {
                    track.setScreenMode(4);
                    break;
                }
                throw new ParseException("unsupported Ham Mode with " + track.getNbPlanes() + " bitplanes");
            }
            default: {
                if (track.getNbPlanes() <= 8) {
                    track.setScreenMode(0);
                    break;
                }
                track.setScreenMode(1);
            }
        }
        switch (camg & 0xFFFF1000) {
            case 0: {
                camgJiffies = 60;
                break;
            }
            case 69632: {
                camgJiffies = 60;
                break;
            }
            case 135168: {
                camgJiffies = 50;
                break;
            }
            case 200704: {
                camgJiffies = 58;
                break;
            }
            case 266240: {
                camgJiffies = 60;
                break;
            }
            case 331776: {
                camgJiffies = 60;
                break;
            }
            case 397312: {
                camgJiffies = 69;
                break;
            }
            case 462848: {
                camgJiffies = 73;
                break;
            }
            case 593920: {
                camgJiffies = 58;
                break;
            }
            case 4096: {
                camgJiffies = 48;
                break;
            }
            case 528384: {
                camgJiffies = 71;
                break;
            }
            default: {
                camgJiffies = 60;
            }
        }
        track.setJiffies(camgJiffies);
    }

    private ColorModel decodeCMAP(IFFChunk chunk, ANIMMovieTrack track) throws ParseException {
        int i;
        int size = 0;
        int colorsToRead = 0;
        if (chunk == null) {
            return null;
        }
        byte[] cmapData = chunk.getData();
        if (this.previousCMAPdata_ != null && Arrays.equals(cmapData, this.previousCMAPdata_)) {
            return null;
        }
        this.previousCMAPdata_ = cmapData;
        switch (track.getScreenMode()) {
            case 2: {
                size = 64;
                colorsToRead = Math.min(32, (int)chunk.getSize() / 3);
                break;
            }
            case 3: 
            case 4: {
                size = 1 << track.getNbPlanes() - 2;
                colorsToRead = Math.min(size, (int)chunk.getSize() / 3);
                break;
            }
            case 0: {
                size = 1 << track.getNbPlanes();
                colorsToRead = Math.min(size, (int)chunk.getSize() / 3);
                break;
            }
            case 1: {
                return new DirectColorModel(24, 0xFF0000, 65280, 255);
            }
        }
        byte[] red = new byte[size];
        byte[] green = new byte[size];
        byte[] blue = new byte[size];
        byte[] data = chunk.getData();
        int j = 0;
        for (i = 0; i < colorsToRead; ++i) {
            red[i] = data[j++];
            green[i] = data[j++];
            blue[i] = data[j++];
        }
        switch (track.getScreenMode()) {
            case 2: {
                j = 32;
                i = 0;
                while (i < 32) {
                    red[j] = (byte)((red[i] & 0xFF) / 2);
                    green[j] = (byte)((green[i] & 0xFF) / 2);
                    blue[j] = (byte)((blue[i] & 0xFF) / 2);
                    ++i;
                    ++j;
                }
                return new IndexColorModel(8, 64, red, green, blue, -1);
            }
            case 3: {
                return new HAMColorModel(6, 16, red, green, blue, false);
            }
            case 4: {
                return new HAMColorModel(8, 64, red, green, blue, false);
            }
            case 0: {
                return new IndexColorModel(8, Math.min(red.length, (int)chunk.getSize() / 3), red, green, blue, -1);
            }
        }
        throw new ParseException("ScreenMode not supported:" + track.getScreenMode());
    }

    protected void decodeCRNG(IFFChunk chunk, ANIMMovieTrack track) throws ParseException {
        try {
            MC68000InputStream in = new MC68000InputStream(new ByteArrayInputStream(chunk.getData()));
            int pad1 = in.readUWORD();
            int rate = in.readUWORD();
            int flags = in.readUWORD();
            int low = in.readUBYTE();
            int high = in.readUBYTE();
            CRNGColorCycle cc = new CRNGColorCycle(rate, 273, low, high, (flags & 1) != 0 && rate > 36 && high > low, (flags & 2) != 0, track.getScreenMode() == 2);
            if (cc.isActive()) {
                track.addColorCycle(cc);
            }
            in.close();
        }
        catch (IOException e) {
            throw new ParseException(e.toString());
        }
    }

    protected void decodeDRNG(IFFChunk chunk, ANIMMovieTrack track) throws ParseException {
        try {
            int cell;
            int i;
            MC68000InputStream in = new MC68000InputStream(new ByteArrayInputStream(chunk.getData()));
            int min = in.readUBYTE();
            int max = in.readUBYTE();
            int rate = in.readUWORD();
            int flags = in.readUWORD();
            int ntrue = in.readUBYTE();
            int nregs = in.readUBYTE();
            DRNGColorCycle.Cell[] cells = new DRNGColorCycle.Cell[ntrue + nregs];
            for (i = 0; i < ntrue; ++i) {
                cell = in.readUBYTE();
                int rgb = in.readUBYTE() << 16 | in.readUBYTE() << 8 | in.readUBYTE();
                cells[i] = new DRNGColorCycle.DColorCell(cell, rgb);
            }
            for (i = 0; i < nregs; ++i) {
                cell = in.readUBYTE();
                int index = in.readUBYTE();
                cells[i + ntrue] = new DRNGColorCycle.DIndexCell(cell, index);
            }
            DRNGColorCycle cc = new DRNGColorCycle(rate, 273, min, max, (flags & 1) != 0 && rate > 36 && min <= max && ntrue + nregs > 1, track.getScreenMode() == 2, cells);
            if (cc.isActive()) {
                track.addColorCycle(cc);
            }
            in.close();
        }
        catch (IOException e) {
            throw new ParseException(e.toString());
        }
    }

    protected void decodeColorCycling(IFFChunk[] crngChunks, IFFChunk[] drngChunks, ANIMMovieTrack track) throws ParseException {
        boolean activeCycles = false;
        int j = 0;
        int k = 0;
        int n = crngChunks.length + drngChunks.length;
        for (int i = 0; i < n; ++i) {
            if (j < crngChunks.length && (k >= drngChunks.length || crngChunks[j].getScan() < drngChunks[k].getScan())) {
                this.decodeCRNG(crngChunks[j], track);
                ++j;
                continue;
            }
            this.decodeDRNG(drngChunks[k], track);
            ++k;
        }
        track.setProperty("colorCycling", track.getColorCyclesCount());
    }

    private void decodeBODY(ColorModel colorModel, IFFChunk group, IFFChunk body, ANIMMovieTrack track) throws ParseException {
        ANIMKeyFrame frame = new ANIMKeyFrame();
        frame.setColorModel(colorModel);
        this.decodeANHD(group.getPropertyChunk(ANHD_ID), frame);
        if (group.getPropertyChunk(ANFI_ID) != null) {
            this.decodeANFI(group.getPropertyChunk(ANFI_ID), frame, track);
        }
        IFFChunk[] sctlChunks = group.getCollectionChunks(SCTL_ID);
        for (int i = 0; i < sctlChunks.length; ++i) {
            this.decodeSCTL(sctlChunks[i], frame, track);
        }
        frame.cleanUpAudioCommands();
        frame.setData(body.getData());
        frame.setCompressed(track.getCompression() == 1);
        track.addFrame(frame);
    }

    private void decodeDLTA(ColorModel colorModel, IFFChunk group, IFFChunk dlta, ANIMMovieTrack track) throws ParseException {
        ANIMDeltaFrame frame = new ANIMDeltaFrame();
        frame.setColorModel(colorModel);
        this.decodeANHD(group.getPropertyChunk(ANHD_ID), frame);
        if (group.getPropertyChunk(ANFI_ID) != null) {
            this.decodeANFI(group.getPropertyChunk(ANFI_ID), frame, track);
        }
        IFFChunk[] sctlChunks = group.getCollectionChunks(SCTL_ID);
        for (int i = 0; i < sctlChunks.length; ++i) {
            this.decodeSCTL(sctlChunks[i], frame, track);
        }
        frame.cleanUpAudioCommands();
        frame.setData(dlta.getData());
        track.addFrame(frame);
    }

    private void decodeANHD(IFFChunk chunk, ANIMFrame frame) throws ParseException {
        if (chunk != null) {
            try {
                MC68000InputStream in = new MC68000InputStream(new ByteArrayInputStream(chunk.getData()));
                frame.setOperation(in.readUBYTE());
                frame.setMask(in.readUBYTE());
                frame.setWidth(in.readUWORD());
                frame.setHeight(in.readUWORD());
                frame.setY(in.readWORD());
                frame.setX(in.readWORD());
                frame.setAbsTime(in.readULONG());
                frame.setRelTime(in.readULONG());
                frame.setInterleave(in.readUBYTE());
                in.skip(1L);
                frame.setBits((int)in.readULONG());
                in.close();
            }
            catch (IOException e) {
                throw new ParseException(e.toString());
            }
        }
    }

    private void decodeANFI(IFFChunk chunk, ANIMFrame frame, ANIMMovieTrack track) throws ParseException {
        try {
            MC68000InputStream in = new MC68000InputStream(new ByteArrayInputStream(chunk.getData()));
            for (int i = 0; i < 4; ++i) {
                int command = in.readUWORD();
                int frequency = in.readUWORD();
                int sound = in.readUBYTE();
                int channel = in.readUBYTE();
                int repeats = in.readUBYTE();
                repeats = repeats > 2 ? --repeats : 1;
                int volume = in.readUBYTE();
                if (command == 0) continue;
                ANIMAudioCommand audioCommand = new ANIMAudioCommand(1, volume - 1, sound, repeats, 1 << channel, 0, 0);
                frame.addAudioCommand(audioCommand);
                audioCommand.prepare(track);
            }
            in.close();
        }
        catch (IOException e) {
            throw new ParseException(e.toString());
        }
    }

    private void decodeSCTL(IFFChunk chunk, ANIMFrame frame, ANIMMovieTrack track) throws ParseException {
        try {
            MC68000InputStream in = new MC68000InputStream(new ByteArrayInputStream(chunk.getData()));
            int command = in.readUBYTE();
            int volume = in.readUBYTE();
            int sound = in.readUWORD();
            int repeats = in.readUWORD();
            int channel = in.readUWORD();
            int frequency = in.readUWORD();
            int flags = in.readUWORD();
            in.close();
            ANIMAudioCommand audioCommand = new ANIMAudioCommand(command, volume, sound, repeats, channel, frequency, flags);
            frame.addAudioCommand(audioCommand);
            audioCommand.prepare(track);
        }
        catch (IOException e) {
            throw new ParseException(e.toString());
        }
    }

    protected void decodeCOPYRIGHT(IFFChunk[] chunks, ANIMMovieTrack track) throws ParseException {
        for (int i = 0; i < chunks.length; ++i) {
            String copyright = new String(chunks[i].getData());
            this.appendProperty("copyright", copyright);
            this.appendProperty("comment", "\ufffd " + copyright);
        }
    }

    protected void decodeAUTH(IFFChunk[] chunks, ANIMMovieTrack track) throws ParseException {
        for (int i = 0; i < chunks.length; ++i) {
            String author = new String(chunks[i].getData());
            this.appendProperty("author", author);
            this.appendProperty("comment", "Author " + author);
        }
    }

    protected void decodeANNO(IFFChunk[] chunks, ANIMMovieTrack track) throws ParseException {
        for (int i = 0; i < chunks.length; ++i) {
            String anno = new String(chunks[i].getData());
            this.appendProperty("annotation", anno);
            this.appendProperty("comment", anno);
        }
    }

    private void appendProperty(String name, String value) {
        String oldValue = (String)this.track.getProperty(name);
        if (oldValue == null) {
            this.track.setProperty(name, value);
        } else {
            this.track.setProperty(name, oldValue + "\n" + value);
        }
    }
}

