/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.media.anim;

import ch.randelshofer.media.anim.ANIMAudioCommand;
import ch.randelshofer.media.anim.ANIMFrame;
import ch.randelshofer.media.ilbm.ColorCycle;
import java.applet.AudioClip;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ANIMMovieTrack {
    private int width_;
    private int height_;
    private int xPosition_;
    private int yPosition_;
    private int nbPlanes_;
    private int nbPalettes_ = -1;
    private int masking_;
    public static final int MSK_NONE = 0;
    public static final int MSK_HAS_MASK = 1;
    public static final int MSK_HAS_TRANSPARENT_COLOR = 2;
    public static final int MSK_LASSO = 3;
    private int transparentColor_;
    private int xAspect_;
    private int yAspect_;
    private int pageWidth_;
    private int pageHeight_;
    private int screenMode_;
    private int jiffies;
    private boolean isPlayWrapupFrames = false;
    private boolean isSwapSpeakers = false;
    public static final int MODE_INDEXED_COLORS = 0;
    public static final int MODE_DIRECT_COLORS = 1;
    public static final int MODE_EHB = 2;
    public static final int MODE_HAM6 = 3;
    public static final int MODE_HAM8 = 4;
    private int compression_;
    public static final int CMP_NONE = 0;
    public static final int CMP_BYTE_RUN_1 = 1;
    private long totalDuration_;
    private Hashtable properties_ = new Hashtable();
    private Vector frames_ = new Vector();
    private Vector audioClips_ = new Vector();
    private PropertyChangeSupport listeners_ = new PropertyChangeSupport(this);
    private ArrayList<ColorCycle> colorCycles = new ArrayList();

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listeners_.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.listeners_.removePropertyChangeListener(listener);
    }

    public void setProperty(String name, Object newValue) {
        Object oldValue = this.properties_.get(name);
        if (newValue == null) {
            this.properties_.remove(name);
        } else {
            this.properties_.put(name, newValue);
        }
        this.listeners_.firePropertyChange(name, oldValue, newValue);
    }

    public void setPlayWrapupFrames(boolean b) {
        this.isPlayWrapupFrames = b;
        this.nbPalettes_ = -1;
    }

    public boolean isPlayWrapupFrames() {
        return this.isPlayWrapupFrames();
    }

    public int getInterleave() {
        return this.frames_.size() > 0 && ((ANIMFrame)this.frames_.get(this.frames_.size() - 1)).getInterleave() == 1 ? 1 : 2;
    }

    public void setSwapSpeakers(boolean newValue) {
        boolean oldValue = this.isSwapSpeakers;
        this.isSwapSpeakers = newValue;
        if (newValue != oldValue) {
            Enumeration i = this.frames_.elements();
            while (i.hasMoreElements()) {
                ANIMAudioCommand[] aac = ((ANIMFrame)i.nextElement()).getAudioCommands();
                if (aac == null) continue;
                for (int j = 0; j < aac.length; ++j) {
                    aac[j].dispose();
                }
            }
        }
    }

    public boolean isSwapSpeakers() {
        return this.isSwapSpeakers;
    }

    public Object getProperty(String name) {
        return this.properties_.get(name);
    }

    private void firePropertyChange(String name, int oldValue, int newValue) {
        this.listeners_.firePropertyChange(name, new Integer(oldValue), new Integer(newValue));
    }

    public void setJiffies(int newValue) {
        int oldValue = this.jiffies;
        this.jiffies = newValue;
        this.firePropertyChange("jiffies", oldValue, newValue);
    }

    public void setCompression(int newValue) {
        int oldValue = this.compression_;
        this.compression_ = newValue;
        this.firePropertyChange("compression", oldValue, newValue);
    }

    public void setWidth(int newValue) {
        int oldValue = this.width_;
        this.width_ = newValue;
        this.firePropertyChange("width", oldValue, newValue);
    }

    public void setHeight(int newValue) {
        int oldValue = this.height_;
        this.height_ = newValue;
        this.firePropertyChange("height", oldValue, newValue);
    }

    public void setXPosition(int newValue) {
        int oldValue = this.xPosition_;
        this.xPosition_ = newValue;
        this.firePropertyChange("xPosition", oldValue, newValue);
    }

    public void setYPosition(int newValue) {
        int oldValue = this.yPosition_;
        this.yPosition_ = newValue;
        this.firePropertyChange("yPosition", oldValue, newValue);
    }

    public void setNbPlanes(int newValue) {
        int oldValue = this.nbPlanes_;
        this.nbPlanes_ = newValue;
        this.firePropertyChange("nbPlanes", oldValue, newValue);
    }

    public void setMasking(int newValue) {
        int oldValue = this.masking_;
        this.masking_ = newValue;
        this.firePropertyChange("masking", oldValue, newValue);
    }

    public void setTransparentColor(int newValue) {
        int oldValue = this.transparentColor_;
        this.transparentColor_ = newValue;
        this.firePropertyChange("transparentColor", oldValue, newValue);
    }

    public void setXAspect(int newValue) {
        int oldValue = this.xAspect_;
        this.xAspect_ = newValue;
        this.firePropertyChange("xAspect", oldValue, newValue);
    }

    public void setYAspect(int newValue) {
        int oldValue = this.yAspect_;
        this.yAspect_ = newValue;
        this.firePropertyChange("yAspect", oldValue, newValue);
    }

    public void setPageWidth(int newValue) {
        int oldValue = this.pageWidth_;
        this.pageWidth_ = newValue;
        this.firePropertyChange("pageWidth", oldValue, newValue);
    }

    public void setPageHeight(int newValue) {
        int oldValue = this.pageHeight_;
        this.pageHeight_ = newValue;
        this.firePropertyChange("pageHeight", oldValue, newValue);
    }

    public void setScreenMode(int newValue) {
        int oldValue = this.screenMode_;
        this.screenMode_ = newValue;
        this.firePropertyChange("screenMode", oldValue, newValue);
    }

    public int getWidth() {
        return this.width_;
    }

    public int getHeight() {
        return this.height_;
    }

    public int getXPosition() {
        return this.xPosition_;
    }

    public int getYPosition() {
        return this.yPosition_;
    }

    public int getNbPlanes() {
        return this.nbPlanes_;
    }

    public int getNbPalettes() {
        block4: {
            int n;
            if (this.nbPalettes_ != -1 || (n = this.getFrameCount()) <= 0) break block4;
            ColorModel cm = this.getFrame(0).getColorModel();
            if (cm instanceof IndexColorModel) {
                IndexColorModel prev = (IndexColorModel)cm;
                int size = prev.getMapSize();
                byte[] pr = new byte[size];
                byte[] pg = new byte[size];
                byte[] pb = new byte[size];
                byte[] cr = new byte[size];
                byte[] cg = new byte[size];
                byte[] cb = new byte[size];
                prev.getReds(pr);
                prev.getGreens(pg);
                prev.getBlues(pb);
                this.nbPalettes_ = 1;
                for (int i = 1; i < n; ++i) {
                    IndexColorModel cur = (IndexColorModel)this.getFrame(i).getColorModel();
                    if (cur == prev) continue;
                    cur.getReds(cr);
                    cur.getGreens(cg);
                    cur.getBlues(cb);
                    if (Arrays.equals(cr, pr) && Arrays.equals(cg, pg) && Arrays.equals(cb, pb)) continue;
                    ++this.nbPalettes_;
                    prev = cur;
                    System.arraycopy(cr, 0, pr, 0, cr.length);
                    System.arraycopy(cg, 0, pg, 0, cg.length);
                    System.arraycopy(cb, 0, pb, 0, cb.length);
                }
            } else {
                this.nbPalettes_ = 1;
                ColorModel prev = cm;
                for (int i = 1; i < n; ++i) {
                    ColorModel cur = this.getFrame(i).getColorModel();
                    if (cur == prev) continue;
                    ++this.nbPalettes_;
                    prev = cur;
                }
            }
        }
        return this.nbPalettes_;
    }

    public int getMasking() {
        return this.masking_;
    }

    public int getTransparentColor() {
        return this.transparentColor_;
    }

    public int getXAspect() {
        return this.xAspect_;
    }

    public int getYAspect() {
        return this.yAspect_;
    }

    public int getPageWidth() {
        return this.pageWidth_;
    }

    public int getPageHeight() {
        return this.pageHeight_;
    }

    public int getScreenMode() {
        return this.screenMode_;
    }

    public int getJiffies() {
        return this.jiffies;
    }

    public int getCompression() {
        return this.compression_;
    }

    public int getDeltaOperation() {
        int lastFrame = this.frames_.size() - 1;
        if (lastFrame < 0) {
            return -1;
        }
        return ((ANIMFrame)this.frames_.elementAt(lastFrame)).getOperation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFrame(ANIMFrame frame) {
        int oldValue;
        ANIMMovieTrack aNIMMovieTrack = this;
        synchronized (aNIMMovieTrack) {
            oldValue = this.frames_.size();
            this.frames_.addElement(frame);
            this.totalDuration_ = -1L;
        }
        this.firePropertyChange("frameCount", oldValue, oldValue + 1);
    }

    public void addAudioClip(AudioClip clip) {
        int oldValue = this.audioClips_.size();
        this.audioClips_.addElement(clip);
        this.firePropertyChange("audioClipCount", oldValue, oldValue + 1);
    }

    public int getAudioClipCount() {
        return this.audioClips_.size();
    }

    public AudioClip getAudioClip(int index) {
        return (AudioClip)this.audioClips_.elementAt(index);
    }

    public int getFrameCount() {
        int size = this.frames_.size();
        if (this.isPlayWrapupFrames) {
            return size;
        }
        int interleave = this.getInterleave();
        return size > 1 + interleave ? size - interleave : size;
    }

    public ANIMFrame getFrame(int index) {
        return (ANIMFrame)this.frames_.elementAt(index);
    }

    public long getFrameDuration(int index) {
        return ((ANIMFrame)this.frames_.elementAt(index)).getRelTime();
    }

    public synchronized long getTotalDuration() {
        if (this.totalDuration_ == -1L) {
            this.totalDuration_ = 0L;
            for (int i = this.getFrameCount() - 1; i > -1; --i) {
                this.totalDuration_ += this.getFrameDuration(i) + 1L;
            }
        }
        return this.totalDuration_;
    }

    public void addColorCycle(ColorCycle cc) {
        int oldCount = this.colorCycles.size();
        this.colorCycles.add(cc);
        this.firePropertyChange("colorCyclesCount", oldCount, this.colorCycles.size());
    }

    public List<ColorCycle> getColorCycles() {
        return this.colorCycles;
    }

    public int getColorCyclesCount() {
        return this.colorCycles.size();
    }
}

