/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.media.eightsvx;

import ch.randelshofer.media.eightsvx.LoopableAudioClip;
import java.io.InputStream;
import sun.audio.AudioData;
import sun.audio.AudioDataStream;
import sun.audio.AudioPlayer;
import sun.audio.ContinuousAudioDataStream;

public class JDK10AudioClip
implements LoopableAudioClip {
    private int sampleRate;
    private byte[] samples;
    private AudioDataStream audioStream;

    public JDK10AudioClip(byte[] samples, int sampleRate) {
        this.samples = samples;
        this.sampleRate = sampleRate;
    }

    public synchronized void play() {
        this.stop();
        byte[] data = new byte[this.samples.length + 24];
        JDK10AudioClip.writeSunAudioHeader(data, this.sampleRate, this.samples.length);
        System.arraycopy(this.samples, 0, data, 24, this.samples.length);
        AudioData audioData = new AudioData(data);
        this.audioStream = new AudioDataStream(audioData);
        AudioPlayer.player.start((InputStream)this.audioStream);
    }

    public synchronized void loop() {
        this.stop();
        byte[] data = new byte[this.samples.length + 24];
        JDK10AudioClip.writeSunAudioHeader(data, this.sampleRate, this.samples.length);
        System.arraycopy(this.samples, 0, data, 24, this.samples.length);
        AudioData audioData = new AudioData(data);
        ContinuousAudioDataStream audioStream = new ContinuousAudioDataStream(audioData);
        AudioPlayer.player.start((InputStream)audioStream);
    }

    public void loop(int count) {
        if (count == 1 || count == 0) {
            this.play();
        } else if (count == -1) {
            this.loop();
        } else {
            this.stop();
            byte[] data = new byte[this.samples.length * count + 24];
            JDK10AudioClip.writeSunAudioHeader(data, this.sampleRate, this.samples.length * count);
            for (int i = 0; i < count; ++i) {
                System.arraycopy(this.samples, 0, data, 24 + i * this.samples.length, this.samples.length);
            }
            AudioData audioData = new AudioData(data);
            ContinuousAudioDataStream audioStream = new ContinuousAudioDataStream(audioData);
            AudioPlayer.player.start((InputStream)audioStream);
        }
    }

    public synchronized void stop() {
        if (this.audioStream != null) {
            AudioPlayer.player.stop((InputStream)this.audioStream);
            this.audioStream = null;
        }
    }

    public static void writeSunAudioHeader(byte[] data, int sampleRate, int datasize) {
        int headersize = 24;
        byte[] header = new byte[]{46, 115, 110, 100, (byte)(headersize >>> 24 & 0xFF), (byte)(headersize >>> 16 & 0xFF), (byte)(headersize >>> 8 & 0xFF), (byte)(headersize & 0xFF), (byte)(datasize >>> 24 & 0xFF), (byte)(datasize >>> 16 & 0xFF), (byte)(datasize >>> 8 & 0xFF), (byte)(datasize & 0xFF), 0, 0, 0, 1, (byte)(sampleRate >>> 24 & 0xFF), (byte)(sampleRate >>> 16 & 0xFF), (byte)(sampleRate >>> 8 & 0xFF), (byte)(sampleRate & 0xFF), 0, 0, 0, 1};
        System.arraycopy(header, 0, data, 0, headersize);
    }
}

