/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.media.ilbm;

import ch.randelshofer.media.ilbm.ColorCycle;

public class CRNGColorCycle
extends ColorCycle {
    private int low;
    private int high;
    private boolean isReverse;
    private boolean isEHB;

    public CRNGColorCycle(int rate, int timeScale, int low, int high, boolean isActive, boolean isReverse, boolean isEHB) {
        super(rate, timeScale, isActive);
        this.low = low;
        this.high = high;
        this.isReverse = isReverse;
        this.isEHB = isEHB;
    }

    public boolean isReverse() {
        return this.isReverse;
    }

    public int getLow() {
        return this.low;
    }

    public int getHigh() {
        return this.high;
    }

    public void doCycle(int[] rgbs, long time) {
        block9: {
            int i;
            int tmp;
            int j;
            int shift;
            block10: {
                int i2;
                int tmp2;
                int j2;
                if (!this.isActive) break block9;
                shift = (int)(time * (long)this.rate / (long)this.timeScale / 1000L % (long)(this.high - this.low + 1));
                if (!this.isReverse) break block10;
                for (j2 = 0; j2 < shift; ++j2) {
                    tmp2 = rgbs[this.low];
                    for (i2 = this.low; i2 < this.high; ++i2) {
                        rgbs[i2] = rgbs[i2 + 1];
                    }
                    rgbs[this.high] = tmp2;
                }
                if (!this.isEHB) break block9;
                for (j2 = 0; j2 < shift; ++j2) {
                    tmp2 = rgbs[this.low + 32];
                    for (i2 = this.low + 32; i2 < this.high + 32; ++i2) {
                        rgbs[i2] = rgbs[i2 + 1];
                    }
                    rgbs[this.high + 32] = tmp2;
                }
                break block9;
            }
            for (j = 0; j < shift; ++j) {
                tmp = rgbs[this.high];
                for (i = this.high; i > this.low; --i) {
                    rgbs[i] = rgbs[i - 1];
                }
                rgbs[this.low] = tmp;
            }
            if (this.isEHB) {
                for (j = 0; j < shift; ++j) {
                    tmp = rgbs[this.high + 32];
                    for (i = this.high + 32; i > this.low + 32; --i) {
                        rgbs[i] = rgbs[i - 1];
                    }
                    rgbs[this.low + 32] = tmp;
                }
            }
        }
    }
}

