/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.media.ilbm;

import ch.randelshofer.media.ilbm.ColorCycle;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageConsumer;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import javax.swing.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ILBMMemoryImageSource
extends MemoryImageSource {
    private int width;
    private int height;
    private ColorModel model;
    private Object pixels;
    private int pixeloffset;
    private int pixelscan;
    private Hashtable properties;
    private ArrayList<ColorCycle> colorCycles = new ArrayList();
    private Timer timer;
    private HashSet<ImageConsumer> consumers = new HashSet();
    private boolean isAnimated;
    private boolean isColorCycling;
    private volatile ColorModel cycledModel;

    public ILBMMemoryImageSource(int w, int h, ColorModel cm, byte[] pix, int off, int scan) {
        super(w, h, cm, pix, off, scan);
        this.initialize(w, h, cm, pix, off, scan, null);
    }

    public ILBMMemoryImageSource(int w, int h, ColorModel cm, byte[] pix, int off, int scan, Hashtable<?, ?> props) {
        super(w, h, cm, pix, off, scan, props);
        this.initialize(w, h, cm, pix, off, scan, props);
    }

    public ILBMMemoryImageSource(int w, int h, ColorModel cm, int[] pix, int off, int scan) {
        super(w, h, cm, pix, off, scan);
        this.initialize(w, h, cm, pix, off, scan, null);
    }

    public ILBMMemoryImageSource(int w, int h, ColorModel cm, int[] pix, int off, int scan, Hashtable<?, ?> props) {
        super(w, h, cm, pix, off, scan, props);
        this.initialize(w, h, cm, pix, off, scan, props);
    }

    private void initialize(int w, int h, ColorModel cm, Object pix, int off, int scan, Hashtable props) {
        this.width = w;
        this.height = h;
        this.model = cm;
        this.pixels = pix;
        this.pixeloffset = off;
        this.pixelscan = scan;
        if (props == null) {
            props = new Hashtable();
        }
        this.properties = props;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public ColorModel getColorModel() {
        return this.model;
    }

    public Hashtable getProperties() {
        return this.properties;
    }

    @Override
    public synchronized void newPixels(byte[] newpix, ColorModel newmodel, int offset, int scansize) {
        this.pixels = newpix;
        this.model = newmodel;
        this.pixeloffset = offset;
        this.pixelscan = scansize;
        super.newPixels(newpix, this.cycledModel == null ? newmodel : this.cycledModel, offset, scansize);
    }

    @Override
    public synchronized void newPixels(int[] newpix, ColorModel newmodel, int offset, int scansize) {
        this.pixels = newpix;
        this.model = newmodel;
        this.pixeloffset = offset;
        this.pixelscan = scansize;
        super.newPixels(newpix, this.cycledModel == null ? newmodel : this.cycledModel, offset, scansize);
    }

    public void addColorCycle(ColorCycle cc) {
        this.colorCycles.add(cc);
    }

    @Override
    public void addConsumer(ImageConsumer ic) {
        super.addConsumer(ic);
        this.consumers.add(ic);
        if (this.isAnimated && this.isColorCycling && this.consumers.size() > 0) {
            this.startAnimationTimer();
        }
    }

    @Override
    public void removeConsumer(ImageConsumer ic) {
        super.removeConsumer(ic);
        this.consumers.remove(ic);
        if (this.isAnimated && this.consumers.size() == 0) {
            this.stopAnimationTimer();
        }
    }

    @Override
    public void setAnimated(boolean b) {
        super.setAnimated(b);
        this.isAnimated = b;
        if (this.isAnimated && this.consumers.size() > 0 && this.isColorCycling) {
            this.startAnimationTimer();
        } else {
            this.stopAnimationTimer();
        }
    }

    public void setColorCyclingEnabled(boolean b) {
        this.isColorCycling = b;
        if (this.isAnimated && this.consumers.size() > 0 && this.isColorCycling) {
            this.startAnimationTimer();
        } else {
            this.stopAnimationTimer();
        }
    }

    public boolean isColorCyclingEnabled() {
        return this.isColorCycling;
    }

    public void startColorCycling() {
        this.setColorCyclingEnabled(true);
    }

    public void stopColorCycling() {
        this.setColorCyclingEnabled(false);
    }

    private synchronized void startAnimationTimer() {
        if (this.timer != null) {
            return;
        }
        if (this.model instanceof IndexColorModel) {
            IndexColorModel icm = (IndexColorModel)this.model;
            final int[] rgbs = new int[icm.getMapSize()];
            icm.getRGBs(rgbs);
            int delay = 1000;
            boolean i = false;
            for (ColorCycle cc : this.colorCycles) {
                int ccDelay;
                if (!cc.isActive() || (ccDelay = 500 * cc.getTimeScale() / cc.getRate()) >= delay) continue;
                delay = Math.max(1, ccDelay);
            }
            this.timer = new Timer(delay, new ActionListener(){
                private int[] previousCycled;
                private int[] cycled;
                long startTime;
                {
                    this.previousCycled = new int[rgbs.length];
                    this.cycled = new int[rgbs.length];
                    this.startTime = System.currentTimeMillis();
                }

                public void actionPerformed(ActionEvent evt) {
                    long now = System.currentTimeMillis();
                    System.arraycopy(rgbs, 0, this.cycled, 0, rgbs.length);
                    for (ColorCycle cc : ILBMMemoryImageSource.this.colorCycles) {
                        cc.doCycle(this.cycled, now - this.startTime);
                    }
                    if (!Arrays.equals(this.previousCycled, this.cycled)) {
                        ILBMMemoryImageSource.super.newPixels((byte[])ILBMMemoryImageSource.this.pixels, ILBMMemoryImageSource.this.cycledModel = new IndexColorModel(8, this.cycled.length, this.cycled, 0, false, -1, 0), ILBMMemoryImageSource.this.pixeloffset, ILBMMemoryImageSource.this.pixelscan);
                    }
                    int[] tmp = this.previousCycled;
                    this.previousCycled = this.cycled;
                    this.cycled = tmp;
                }
            });
            this.timer.setRepeats(true);
            this.timer.start();
        }
    }

    private synchronized void stopAnimationTimer() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
            this.cycledModel = null;
            ILBMMemoryImageSource.super.newPixels((byte[])this.pixels, this.model, this.pixeloffset, this.pixelscan);
        }
    }

    public BufferedImage toBufferedImage() {
        DataBuffer buf = this.pixels instanceof byte[] ? new DataBufferByte((byte[])this.pixels, this.pixelscan * this.height, this.pixeloffset) : new DataBufferInt((int[])this.pixels, this.pixelscan * this.height, this.pixeloffset);
        SampleModel sm = this.model.createCompatibleSampleModel(this.width, this.height);
        WritableRaster raster = Raster.createWritableRaster(sm, buf, new Point());
        return new BufferedImage(this.model, raster, false, this.properties);
    }

    public boolean isAnimated() {
        return this.isAnimated;
    }
}

