/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.animapplet;

import ch.randelshofer.gui.ImagePanel;
import ch.randelshofer.io.SuspendableInputStream;
import ch.randelshofer.media.MovieControl;
import ch.randelshofer.media.anim.ANIMMovieTrack;
import ch.randelshofer.media.anim.ANIMPlayer;
import ch.randelshofer.util.Applets;
import ch.randelshofer.util.StateTracker;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.DirectColorModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class ANIMApplet
extends JApplet
implements Runnable,
PropertyChangeListener {
    private String version = ANIMApplet.class.getPackage().getImplementationVersion();
    private MovieControl controllerPanel;
    private ImagePanel imagePanel;
    private ANIMPlayer player;
    private Thread loaderThread;
    private boolean isPlaying;
    private SuspendableInputStream suspendableInputStream;
    public boolean debug;

    public ANIMApplet() {
        JLabel l = new JLabel("<html><span style=\"font:Dialog;font-size:12\">Loading ANIMApplet " + (this.version == null ? "" : this.version) + "<br>Werner Randelshofer</span>");
        this.add((Component)l, "North");
        l.setBackground(Color.WHITE);
        l.setForeground(Color.BLACK);
        this.getContentPane().setBackground(Color.WHITE);
        ((JComponent)this.getContentPane()).setOpaque(true);
    }

    public void init() {
        this.debug = Applets.getParameter((Applet)this, "debug", false);
        this.getContentPane().setBackground(Applets.getParameter((Applet)this, "boxBgColor", Color.white));
        this.getContentPane().setForeground(Applets.getParameter((Applet)this, "boxFgColor", Color.black));
    }

    public void run() {
        try {
            FilterInputStream in;
            int imageFileSize;
            URLConnection connection;
            URL url;
            String imageSource = Applets.getParameter((Applet)this, "animSource", Applets.getParameter((Applet)this, "imageSource", ""));
            String imageArchive = Applets.getParameter((Applet)this, "animArchive", Applets.getParameter((Applet)this, "imageArchive", (String)null));
            String image = Applets.getParameter((Applet)this, "anim", Applets.getParameter((Applet)this, "image", (String)null));
            if (imageSource.length() > 0 && imageSource.charAt(imageSource.length() - 1) != '/') {
                imageSource = imageSource + '/';
            }
            if (imageArchive != null) {
                ZipEntry zipEntry;
                url = new URL(this.getDocumentBase(), imageSource + imageArchive);
                connection = url.openConnection();
                connection.connect();
                this.suspendableInputStream = new SuspendableInputStream(connection.getInputStream());
                ZipInputStream zipIn = new ZipInputStream(this.suspendableInputStream){

                    public long skip(long n) throws IOException {
                        long total;
                        long len;
                        for (total = 0L; total < n; total += len) {
                            len = super.skip(Math.min(n - total, 512L));
                            if (len != -1L) continue;
                            if (total != 0L) break;
                            total = -1L;
                            break;
                        }
                        return total;
                    }
                };
                while ((zipEntry = zipIn.getNextEntry()) != null && !zipEntry.getName().equals(image)) {
                }
                if (zipEntry == null) {
                    throw new IOException("Couldn't find file \"" + image + "\" in ZIP archive \"" + url + "\"");
                }
                imageFileSize = (int)zipEntry.getSize();
                if (imageFileSize == -1) {
                    System.err.println("ANIMApplet Warning:\n  Unable to show an accurate progress bar while loading the ANIM file.\n  Please recompress the Zip archive with a tool that stores the file size at the beginning of the Zip entries.\n  Zip Archive: " + url);
                    imageFileSize = connection.getContentLength();
                    if (imageFileSize != -1) {
                        imageFileSize *= 2;
                    }
                }
                in = zipIn;
            } else {
                url = new URL(this.getDocumentBase(), imageSource + image);
                connection = url.openConnection();
                connection.connect();
                imageFileSize = connection.getContentLength();
                in = this.suspendableInputStream = new SuspendableInputStream(connection.getInputStream());
            }
            this.player = new ANIMPlayer(in, imageFileSize, Applets.getParameter((Applet)this, "audio", true));
            this.player.setDebug(this.debug);
            if (Applets.getParameter((Applet)this, "renderAsTrueColor", true)) {
                this.player.setPreferredColorModel(DirectColorModel.getRGBdefault());
            }
            this.controllerPanel = (MovieControl)((Object)this.player.getControlPanelComponent());
            this.imagePanel = (ImagePanel)this.player.getVisualComponent();
            String p = Applets.getParameter((Applet)this, "scale", "toFit").toLowerCase();
            if (p.equals("tofit")) {
                this.imagePanel.setImageScalePolicy(1);
            } else if (p.equals("aspect")) {
                this.imagePanel.setImageScalePolicy(2);
            } else {
                this.imagePanel.setImageScalePolicy(0);
                try {
                    double factor = Double.valueOf(p);
                    this.imagePanel.setScaleFactor(factor);
                }
                catch (NumberFormatException e) {
                    this.imagePanel.setMessage("Invalid property: scale=" + p);
                    this.imagePanel.setImageScalePolicy(1);
                }
            }
            StateTracker tracker = new StateTracker(this.player);
            this.player.realize();
            int[] states = new int[]{2, -1};
            tracker.waitForState(states);
            tracker.setStateModel(null);
            this.player.setLoop(Applets.getParameter((Applet)this, "loop", true));
            this.player.setPingPong(Applets.getParameter((Applet)this, "pingPong", false));
            this.player.setPlayWrapupFrames(Applets.getParameter((Applet)this, "playWrapupFrames", false));
            this.player.setColorCyclingEnabled(Applets.getParameter((Applet)this, "colorCycling", true));
            p = this.getParameter("framesPerSecond");
            if (p != null) {
                try {
                    this.player.setFramesPerSecond(Float.valueOf(p).floatValue());
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ANIMApplet.this.getContentPane().removeAll();
                    if (Applets.getParameter((Applet)ANIMApplet.this, "controller", true)) {
                        ANIMApplet.this.add(ANIMApplet.this.controllerPanel.getComponent(), "South");
                    }
                    ANIMApplet.this.add((Component)ANIMApplet.this.imagePanel, "Center");
                    ((JComponent)ANIMApplet.this.getContentPane()).revalidate();
                    ANIMApplet.this.player.addPropertyChangeListener(ANIMApplet.this);
                    if (Applets.getParameter((Applet)ANIMApplet.this, "autoStart", true) && ANIMApplet.this.player.isCached()) {
                        ANIMApplet.this.player.start();
                    }
                    ((JComponent)ANIMApplet.this.getContentPane()).revalidate();
                }
            });
        }
        catch (Throwable e) {
            e.printStackTrace();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    ANIMApplet.this.getContentPane().removeAll();
                    ANIMApplet.this.add((Component)new JLabel("<html><span style=\"font:Dialog;font-size:12\">" + (e.getMessage() == null || e.getMessage().length() == 0 ? e.toString() : e.getMessage())), "North");
                    ((JComponent)ANIMApplet.this.getContentPane()).revalidate();
                }
            });
        }
    }

    public void start() {
        if (this.loaderThread == null) {
            this.loaderThread = new Thread(this);
            try {
                this.loaderThread.setPriority(1);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.loaderThread.start();
        }
        if (this.suspendableInputStream != null) {
            this.suspendableInputStream.resume();
        }
        if (this.isPlaying && this.player != null) {
            this.player.start();
        }
    }

    public void stop() {
        if (this.suspendableInputStream != null) {
            this.suspendableInputStream.suspend();
        }
        if (this.player != null) {
            this.isPlaying = this.player.isActive();
            this.player.stop();
        }
    }

    public void destroy() {
        if (this.suspendableInputStream != null) {
            this.suspendableInputStream.abort();
        }
        try {
            if (this.loaderThread != null) {
                this.loaderThread.interrupt();
                this.loaderThread = null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.player != null) {
            this.player.stop();
            this.player = null;
        }
    }

    public String getAppletInfo() {
        return "ANIMApplet " + this.version + " \u00a9 " + "1999-2009 Werner Randelshofer, Staldenmattweg 2, CH-6405 Immensee, Switzerland";
    }

    public String[][] getParameterInfo() {
        return new String[][]{{"animSource", "URL", "Anim directory."}, {"animArchive", "URL", "Anim zip file."}, {"anim", "URL", "Anim file"}, {"boxMessage", "String", "Text shown in status bar while applet is being loaded."}, {"boxBgColor", "Color", "Background color, e.g. '#ffffff', '0xffffff', 'white', or '255,255,255'. Default depends on browser settings."}, {"boxFgColor", "Color", "Foreground color, e.g. '#000000', '0x000000', 'black', or '0,0,0'. Default depends on browser settings."}, {"renderAsTrueColor", "boolean", "Renders the animation using a 24 bit direct color model if set to 'true'. Default value is 'true'."}, {"image", "URL", "Image shown while applet is being loaded."}, {"scale", "float|'toFit'|'aspect'", "float: scale factor e.g. '2.0'=doubles the size. 'toFit' scales the animation to the bounding box of the view area. 'aspect' scales to fit while maintaining the aspect ratio. Default is 'tofit'."}, {"audio", "boolean", "'true' enables audio playback. Default is 'true'."}, {"framesPerSecond", "float", "Number of frames per second. '0' use animation settings. Default is '0'."}, {"playEveryFrame", "boolean", "'true' plays every frame of the animation. Default is 'false'."}, {"playWrapupFrames", "boolean", "'true' treats wrapup frames like regular frames. Default is 'false'."}, {"controller", "boolean", "'true' shows the controller. Default is 'true'."}, {"autoPlay", "boolean", "'true' starts playing after the animation has been loaded. Default is 'true'."}, {"loop", "boolean", "'true' makes the animation play continuously. Default is 'true'."}, {"pingPong", "boolean", "'true' makes the animation play forward and backwards. Default is 'false'."}, {"info", "boolean", "'true' Displays information about the animation. Default is 'false'"}, {"debug", "boolean", "'true' turns output of debugging info on. Default is 'false'."}};
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("cached")) {
            if (Applets.getParameter((Applet)this, "autoStart", true)) {
                this.player.start();
            }
            if (Applets.getParameter((Applet)this, "info", false)) {
                ANIMMovieTrack track = this.player.getMovieTrack();
                double aspectRatio = (double)track.getXAspect() / (double)track.getYAspect();
                Dimension correctedImageSize = new Dimension(track.getWidth(), track.getHeight());
                if (aspectRatio > 1.0) {
                    correctedImageSize.width = (int)Math.floor((double)track.getWidth() * aspectRatio);
                } else {
                    correctedImageSize.height = (int)Math.ceil((double)track.getHeight() / aspectRatio);
                }
                Dimension size = this.getSize();
                String msg = "Movie\n  Duration: " + (float)this.player.getTotalDuration() / 60.0f + "sec";
                if (this.getParameter("framesPerSecond") != null) {
                    msg = msg + " (" + (float)track.getTotalDuration() / 60.0f + "sec)";
                }
                msg = msg + "\n  Jiffies: " + track.getJiffies();
                msg = msg + "\n  Frame Count: " + track.getFrameCount();
                if (Applets.getParameter((Applet)this, "playWrapupFrames", false)) {
                    msg = msg + " (" + (track.getFrameCount() - 2) + ")";
                }
                if (track.getProperty("copyright") != null) {
                    msg = msg + "\n  Copyright: \"" + track.getProperty("copyright") + "\"";
                }
                if (track.getProperty("author") != null) {
                    msg = msg + "\n  Author: \"" + track.getProperty("author") + "\"";
                }
                if (track.getProperty("annotation") != null) {
                    msg = msg + "\n  Annotation: \"" + track.getProperty("annotation") + "\"";
                }
                msg = msg + "\nImage\n  Screen Mode: " + this.imagePanel.getImage().getProperty("screenMode", this) + "\n  Plane Count: " + track.getNbPlanes() + "\n  Pixel Aspect x:" + track.getXAspect() + " y:" + track.getYAspect() + "\n  Size w:" + size.width + " h:" + size.height + " (w:" + track.getWidth() + " h:" + track.getHeight() + ")" + "\n  Aspect Corrected Size w:" + correctedImageSize.width + " h:" + correctedImageSize.height;
                if (track.getAudioClipCount() > 0) {
                    msg = msg + "\n \nSound\n  Clip Count: " + track.getAudioClipCount();
                }
                msg = msg + "\nANIMApplet " + this.version + "\n  Preferred Size w:" + this.getPreferredSize().width + " h:" + this.getPreferredSize().height;
                this.imagePanel.setMessage(msg);
            }
        }
    }
}

