/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SuspendableInputStream
extends FilterInputStream {
    private static final int ACTIVE = 0;
    private static final int SUSPENDED = 1;
    private static final int ABORTED = 2;
    private volatile int state_ = 0;

    public SuspendableInputStream(InputStream in) {
        super(in);
    }

    public synchronized void suspend() {
        if (this.state_ == 0) {
            this.state_ = 1;
            this.notifyAll();
        }
    }

    public synchronized void resume() {
        if (this.state_ == 1) {
            this.state_ = 0;
            this.notifyAll();
        }
    }

    public synchronized void abort() {
        if (this.state_ != 2) {
            this.state_ = 2;
            this.notifyAll();
        }
    }

    public boolean isSuspended() {
        return this.state_ == 1;
    }

    public boolean isAborted() {
        return this.state_ == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        SuspendableInputStream suspendableInputStream = this;
        synchronized (suspendableInputStream) {
            while (this.state_ == 1) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.state_ == 2) {
            throw new IOException("Aborted");
        }
        return super.read();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b) throws IOException {
        SuspendableInputStream suspendableInputStream = this;
        synchronized (suspendableInputStream) {
            while (this.state_ == 1) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        if (this.state_ == 2) {
            throw new IOException("Aborted");
        }
        return super.read(b);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, int off, int len) throws IOException {
        SuspendableInputStream suspendableInputStream = this;
        synchronized (suspendableInputStream) {
            while (this.state_ == 1) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
        }
        if (this.state_ == 2) {
            throw new IOException("Aborted");
        }
        return super.read(b, off, len);
    }
}

