/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.media;

import ch.randelshofer.gui.image.Images;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JMovieSliderAqua
extends JComponent
implements ChangeListener,
MouseListener,
MouseMotionListener {
    private static final int THUMB_WIDTH = 15;
    private static final int THUMB_HEIGHT = 16;
    private static final int HALF_THUMB_WIDTH = 7;
    private BoundedRangeModel model_ = new DefaultBoundedRangeModel();
    protected int thumbPos_ = 0;
    private int progressPos_ = 0;
    private BoundedRangeModel progressModel_;
    private boolean isPressed;
    private boolean isArmed;
    private static Image trackEastImage;
    private static Image trackCenterImage;
    private static Image trackWestImage;
    private static Image trackEastUnloadedImage;
    private static Image trackCenterUnloadedImage;
    private static Image trackWestUnloadedImage;
    private static Image trackEastDisabledImage;
    private static Image trackCenterDisabledImage;
    private static Image trackWestDisabledImage;
    private static Image trackEastUnloadedDisabledImage;
    private static Image trackCenterUnloadedDisabledImage;
    private static Image trackWestUnloadedDisabledImage;
    private static Image thumbImage;
    private static Image thumbPressedImage;
    private static Image thumbDisabledImage;

    public JMovieSliderAqua() {
        this.model_.addChangeListener(this);
        this.progressModel_ = new DefaultBoundedRangeModel();
        this.progressModel_.setValue(this.progressModel_.getMaximum());
        this.progressModel_.addChangeListener(this);
        this.setBackground(Color.lightGray);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        if (trackEastImage == null) {
            Class<?> c = this.getClass();
            trackEastImage = Images.createImage(c, "images/MovieControl.trackEast.png");
            trackCenterImage = Images.createImage(c, "images/MovieControl.trackCenter.png");
            trackWestImage = Images.createImage(c, "images/MovieControl.trackWest.png");
            trackEastUnloadedImage = Images.createImage(c, "images/MovieControl.trackUnloadedEast.png");
            trackCenterUnloadedImage = Images.createImage(c, "images/MovieControl.trackUnloadedCenter.png");
            trackWestUnloadedImage = Images.createImage(c, "images/MovieControl.trackUnloadedWest.png");
            trackEastDisabledImage = Images.createImage(c, "images/MovieControl.trackEastD.png");
            trackCenterDisabledImage = Images.createImage(c, "images/MovieControl.trackCenterD.png");
            trackWestDisabledImage = Images.createImage(c, "images/MovieControl.trackWestD.png");
            trackEastUnloadedDisabledImage = Images.createImage(c, "images/MovieControl.trackUnloadedEastD.png");
            trackCenterUnloadedDisabledImage = Images.createImage(c, "images/MovieControl.trackUnloadedCenterD.png");
            trackWestUnloadedDisabledImage = Images.createImage(c, "images/MovieControl.trackUnloadedWestD.png");
            thumbImage = Images.createImage(c, "images/MovieControl.thumb.png");
            thumbPressedImage = Images.createImage(c, "images/MovieControl.thumbP.png");
            thumbDisabledImage = Images.createImage(c, "images/MovieControl.thumbD.png");
            MediaTracker tracker = new MediaTracker(this);
            tracker.addImage(trackEastImage, 0);
            tracker.addImage(trackCenterImage, 0);
            tracker.addImage(trackWestImage, 0);
            tracker.addImage(trackEastUnloadedImage, 0);
            tracker.addImage(trackCenterUnloadedImage, 0);
            tracker.addImage(trackWestUnloadedImage, 0);
            tracker.addImage(thumbImage, 0);
            tracker.addImage(thumbPressedImage, 0);
            tracker.checkAll(true);
        }
    }

    public synchronized void setModel(BoundedRangeModel m) {
        if (this.model_ != null) {
            this.model_.removeChangeListener(this);
        }
        BoundedRangeModel boundedRangeModel = this.model_ = m == null ? new DefaultBoundedRangeModel() : m;
        if (this.model_ != null) {
            this.model_.addChangeListener(this);
        }
        this.repaint();
    }

    public Dimension getPreferredSize() {
        return new Dimension(100, 16);
    }

    public Dimension getMinimumSize() {
        return new Dimension(16, 16);
    }

    protected void moveThumb(int mousePosition) {
        int width = this.getSize().width;
        float mouseValue = (float)(mousePosition - 7) / (float)(width - 15);
        this.model_.setValue((int)(mouseValue * (float)(this.model_.getMaximum() - this.model_.getMinimum())));
    }

    protected int computeThumbPos() {
        BoundedRangeModel m = this.model_;
        if (m == null) {
            return 0;
        }
        int width = this.getSize().width - 15;
        float thumbPos = Math.max(0.0f, (float)m.getValue() / (float)(m.getMaximum() - m.getMinimum()));
        return (int)((float)width * thumbPos);
    }

    public synchronized void setProgressModel(BoundedRangeModel brm) {
        if (this.progressModel_ != null) {
            this.progressModel_.removeChangeListener(this);
        }
        BoundedRangeModel boundedRangeModel = this.progressModel_ = brm == null ? new DefaultBoundedRangeModel() : brm;
        if (this.progressModel_ != null) {
            this.progressModel_.addChangeListener(this);
        }
    }

    public BoundedRangeModel getProgressModel() {
        return this.progressModel_;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        this.thumbPos_ = this.computeThumbPos();
        this.progressPos_ = this.computeProgressPos();
        this.paintTrack(g, this.progressPos_);
        this.paintThumb(g, this.thumbPos_);
    }

    private void paintTrack(Graphics g, int progressPos) {
        Dimension s = this.getSize();
        int width = s.width;
        boolean enabled = this.isEnabled();
        Image image = this.progressModel_.getValue() == this.progressModel_.getMinimum() ? (enabled ? trackWestUnloadedImage : trackWestUnloadedDisabledImage) : (enabled ? trackWestImage : trackWestDisabledImage);
        g.drawImage(image, 0, 0, this);
        int trackWidth = width - trackEastImage.getWidth(this) - trackWestImage.getWidth(this);
        int imageWidth = Math.min(trackWidth, progressPos - trackWestImage.getWidth(this));
        if (imageWidth > 0) {
            image = enabled ? trackCenterImage : trackCenterDisabledImage;
            g.drawImage(image, trackWestImage.getWidth(this), 0, imageWidth, image.getHeight(this), this);
        }
        if ((imageWidth = trackWidth - imageWidth) > 0) {
            image = enabled ? trackCenterUnloadedDisabledImage : trackCenterUnloadedDisabledImage;
            g.drawImage(image, width - trackEastImage.getWidth(this) - imageWidth, 0, imageWidth, image.getHeight(this), this);
        }
        image = this.progressModel_.getValue() < this.progressModel_.getMaximum() - this.progressModel_.getExtent() ? (enabled ? trackEastUnloadedImage : trackEastUnloadedDisabledImage) : (enabled ? trackEastImage : trackEastDisabledImage);
        g.drawImage(image, width - image.getWidth(this), 0, this);
    }

    public void paintThumb(Graphics g, int thumbPos) {
        Dimension s = this.getSize();
        int width = s.width;
        int height = s.height;
        Image image = !this.isEnabled() ? thumbDisabledImage : (this.isPressed && this.isArmed ? thumbPressedImage : thumbImage);
        g.drawImage(image, thumbPos, 0, this);
    }

    protected int computeProgressPos() {
        BoundedRangeModel m = this.progressModel_;
        if (m == null) {
            return 0;
        }
        int trackWidth = this.getSize().width - trackEastImage.getWidth(this) - trackWestImage.getWidth(this);
        float thumbPos = Math.max(0.0f, (float)m.getValue() / (float)(m.getMaximum() - m.getMinimum()));
        return (int)((float)trackWidth * thumbPos) + trackWestImage.getWidth(this);
    }

    public void stateChanged(ChangeEvent event) {
        BoundedRangeModel progress = this.progressModel_;
        if (progress != null && event.getSource() == progress) {
            if (this.computeProgressPos() != this.progressPos_) {
                this.repaint();
            }
        } else if (this.computeThumbPos() != this.thumbPos_) {
            this.repaint();
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.isArmed = true;
        this.repaint();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.isArmed = false;
        this.repaint();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.isPressed = true;
        this.moveThumb(mouseEvent.getX());
        this.repaint();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.isPressed = false;
        this.moveThumb(mouseEvent.getX());
        this.repaint();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.moveThumb(mouseEvent.getX());
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

