/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.media.iff;

import ch.randelshofer.media.iff.IFFParser;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class IFFChunk {
    private int id_;
    private int type_;
    private long size_;
    private long scan_;
    private byte[] data_;
    private Hashtable propertyChunks_;
    private Vector collectionChunks_;

    public IFFChunk(int type, int id) {
        this.id_ = id;
        this.type_ = type;
        this.size_ = -1L;
        this.scan_ = -1L;
    }

    public IFFChunk(int type, int id, long size, long scan) {
        this.id_ = id;
        this.type_ = type;
        this.size_ = size;
        this.scan_ = scan;
    }

    public IFFChunk(int type, int id, long size, long scan, IFFChunk propGroup) {
        this.id_ = id;
        this.type_ = type;
        this.size_ = size;
        this.scan_ = scan;
        if (propGroup != null) {
            if (propGroup.propertyChunks_ != null) {
                this.propertyChunks_ = (Hashtable)propGroup.propertyChunks_.clone();
            }
            if (propGroup.collectionChunks_ != null) {
                this.collectionChunks_ = (Vector)propGroup.collectionChunks_.clone();
            }
        }
    }

    public int getID() {
        return this.id_;
    }

    public int getType() {
        return this.type_;
    }

    public long getSize() {
        return this.size_;
    }

    public long getScan() {
        return this.scan_;
    }

    public void putPropertyChunk(IFFChunk chunk) {
        if (this.propertyChunks_ == null) {
            this.propertyChunks_ = new Hashtable();
        }
        this.propertyChunks_.put(chunk, chunk);
    }

    public IFFChunk getPropertyChunk(int id) {
        if (this.propertyChunks_ == null) {
            return null;
        }
        IFFChunk chunk = new IFFChunk(this.type_, id);
        return (IFFChunk)this.propertyChunks_.get(chunk);
    }

    public Enumeration propertyChunks() {
        if (this.propertyChunks_ == null) {
            this.propertyChunks_ = new Hashtable();
        }
        return this.propertyChunks_.keys();
    }

    public void addCollectionChunk(IFFChunk chunk) {
        if (this.collectionChunks_ == null) {
            this.collectionChunks_ = new Vector();
        }
        this.collectionChunks_.addElement(chunk);
    }

    public IFFChunk[] getCollectionChunks(int id) {
        if (this.collectionChunks_ == null) {
            return new IFFChunk[0];
        }
        Enumeration enm = this.collectionChunks_.elements();
        int i = 0;
        while (enm.hasMoreElements()) {
            IFFChunk chunk = (IFFChunk)enm.nextElement();
            if (chunk.id_ != id) continue;
            ++i;
        }
        IFFChunk[] array = new IFFChunk[i];
        i = 0;
        enm = this.collectionChunks_.elements();
        while (enm.hasMoreElements()) {
            IFFChunk chunk = (IFFChunk)enm.nextElement();
            if (chunk.id_ != id) continue;
            array[i++] = chunk;
        }
        return array;
    }

    public Enumeration collectionChunks() {
        if (this.collectionChunks_ == null) {
            this.collectionChunks_ = new Vector();
        }
        return this.collectionChunks_.elements();
    }

    public void setData(byte[] data) {
        this.data_ = data;
    }

    public byte[] getData() {
        return this.data_;
    }

    public boolean equals(Object another) {
        if (another instanceof IFFChunk) {
            IFFChunk that = (IFFChunk)another;
            return that.id_ == this.id_ && that.type_ == this.type_;
        }
        return false;
    }

    public int hashCode() {
        return this.id_;
    }

    public String toString() {
        return super.toString() + "{" + IFFParser.idToString(this.getType()) + "," + IFFParser.idToString(this.getID()) + "}";
    }
}

