/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.util;

import java.util.Vector;

public abstract class EventLoop {
    private Thread eventProcessor;
    private int threadPriority;
    private final Vector eventQueue = new Vector();
    private boolean isCoalesce;
    private volatile boolean isAlive = true;

    public EventLoop() {
        this(5);
    }

    public EventLoop(int priority) {
        this.threadPriority = priority;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void collectEvent(Object event) {
        Vector vector = this.eventQueue;
        synchronized (vector) {
            if (!this.isCoalesce || !this.eventQueue.contains(event)) {
                this.eventQueue.addElement(event);
                if (this.isAlive) {
                    this.startProcessor();
                }
            }
        }
    }

    public void setCoalesce(boolean b) {
        this.isCoalesce = b;
    }

    public boolean isCoalesce() {
        return this.isCoalesce;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Vector vector = this.eventQueue;
        synchronized (vector) {
            this.isAlive = true;
            this.startProcessor();
        }
    }

    public void stop() {
        this.isAlive = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Vector vector = this.eventQueue;
        synchronized (vector) {
            this.eventQueue.removeAllElements();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startProcessor() {
        Vector vector = this.eventQueue;
        synchronized (vector) {
            if (this.eventProcessor == null) {
                this.eventProcessor = new Thread(this + " Event Processor"){

                    public void run() {
                        EventLoop.this.processEvents();
                    }
                };
                try {
                    this.eventProcessor.setDaemon(false);
                }
                catch (SecurityException e) {
                    // empty catch block
                }
                try {
                    this.eventProcessor.setPriority(this.threadPriority);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                this.eventProcessor.start();
            }
        }
    }

    protected abstract void processEvent(Object var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processEvents() {
        while (this.isAlive) {
            Object event;
            Vector vector = this.eventQueue;
            synchronized (vector) {
                if (this.eventQueue.isEmpty()) {
                    this.eventProcessor = null;
                    return;
                }
                event = this.eventQueue.elementAt(0);
                this.eventQueue.removeElementAt(0);
            }
            try {
                this.processEvent(event);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

