/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.util;

import ch.randelshofer.util.StateEvent;
import ch.randelshofer.util.StateListener;
import ch.randelshofer.util.StateModel;

public class StateTracker
implements StateListener {
    private StateModel model_;
    private int[] targetStates_;
    private int targetStateIndex_;

    public StateTracker(StateModel model) {
        this.setStateModel(model);
    }

    public void setStateModel(StateModel model) {
        if (this.model_ != null) {
            this.model_.removeStateListener(this);
        }
        this.model_ = model;
        if (this.model_ != null) {
            this.model_.addStateListener(this);
        }
    }

    public void waitForState(int state) {
        int[] statelist = new int[]{state};
        this.waitForState(statelist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitForState(int[] states) {
        StateTracker stateTracker = this;
        synchronized (stateTracker) {
            this.targetStates_ = states;
            this.targetStateIndex_ = -1;
            int state = this.model_.getState();
            for (int i = 0; i < this.targetStates_.length; ++i) {
                if (state != this.targetStates_[i]) continue;
                return this.targetStates_[i];
            }
            while (this.targetStateIndex_ == -1) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
        }
        return this.targetStates_[this.targetStateIndex_];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(StateEvent event) {
        StateTracker stateTracker = this;
        synchronized (stateTracker) {
            if (this.targetStates_ != null && this.targetStateIndex_ == -1) {
                int state = event.getNewState();
                for (int i = 0; i < this.targetStates_.length; ++i) {
                    if (state != this.targetStates_[i]) continue;
                    this.targetStateIndex_ = i;
                    this.notifyAll();
                    break;
                }
            }
        }
    }
}

