
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

/*
 * @(#)ANIMApplet.java  1.0  27 December 2004
 *
 * Copyright (c) 2004 Werner Randelshofer
 * Staldenmattweg 2, Immensee, CH-6405, Switzerland.
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of
 * Werner Randelshofer. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Werner Randelshofer.
 */

/**
 * ANIMApplet.
 *
 * @author  Werner Randelshofer
 * @version 1.0  27 December 2004  Created.
 */
public class ANIMApplet extends ch.randelshofer.animapplet.ANIMApplet {
    private String[] args;
    
    /** Creates a new instance. */
    public ANIMApplet() {
    }

    /** Gets an applet parameter. If the parameter is not available, returns
     * a command line argument.
     *
     * @param name
     * @return
     */
    @Override
    public String getParameter(String name) {
        try {
            return super.getParameter(name);
        } catch (NullPointerException e) {
            for (int i=0;i<args.length-1;i++) {
                if (args[i].equals("-"+name)) {
                    return args[i]+1;
                }
            }
            return null;
        }
    }
    @Override
    public URL getDocumentBase() {
        try {
            return super.getDocumentBase();
        } catch (NullPointerException e) {
            try {
                return new File(System.getProperty("user.home")).toURI().toURL();
            } catch (MalformedURLException ex) {
                InternalError ie= new InternalError("Can't create URL from user.home directory");
                ie.initCause(ex);
                throw ie;
            }
        }
    }

    public static void main(String[] args) {
        final ANIMApplet applet = new ANIMApplet();
        applet.args=args;
        applet.init();
        SwingUtilities.invokeLater(new Runnable() {

            public void run() {
                JFrame f = new JFrame(applet.getAppletInfo());
                f.getContentPane().add(applet);
                f.setSize(400, 400);
                f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
                f.setVisible(true);
                applet.start();
            }
        });
    }

}
