/*
 * @(#)ANIMKeyFrame.java  1.0  1999-10-19
 *
 * Copyright (c) 1999 Werner Randelshofer
 * Hausmatt 10, CH-6405 Immensee, Switzerland
 * All rights reserved.
 *
 * This software is the confidential and proprietary information of 
 * Werner Randelshofer. ("Confidential Information").  You shall not
 * disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Werner Randelshofer.
 */
package ch.randelshofer.media.anim;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.DirectColorModel;
import java.util.Hashtable;
import ch.randelshofer.gui.image.Bitmap;

/**
 * @author  Werner Randelshofer, Hausmatt 10, CH-6405 Immensee, Switzerland
 * @version  1.0  1999-10-19
 */
public class ANIMKeyFrame
extends ANIMFrame
  {
  private byte[] data_;
  private boolean isCompressed_;

  public ANIMKeyFrame()
    { }
  
  public void setData(byte[] data) { data_ = data; }
  public void setCompressed(boolean isCompressed) { isCompressed_ = isCompressed; }

  public void decode(Bitmap bitmap, ANIMMovieTrack track)
    {
    if (isCompressed_)
      {
      unpackByteRun1(data_,bitmap.getBitmap());    
      }
    else
      {
      System.arraycopy(data_,0,bitmap.getBitmap(),0,data_.length);
      }
    }

  public static int unpackByteRun1(byte[] in, byte[] out)
    {
    int iOut = 0;
     int iIn = 0;
    int command = 0;
    int finalIndex = in.length;
    byte copyByte;

    try
      {
      while (iOut < out.length)
        { 
        command = in[iIn++];
        if (command >= 0)
          {
          for (;command >= 0;command--)
            { out[iOut++] = in[iIn++]; }
          }
        else
          {
          if (command != -128)
            {
            copyByte = in[iIn++];
            for (;command < 1;command++)
              { out[iOut++] = copyByte; }
            }
          }
        }
      }
    catch (IndexOutOfBoundsException e)
      {
      System.out.println("ILBMDecoder.unpackByteRun1(): " + e);
      System.out.println("  Plane-Index: " + iOut + " Plane size:" + out.length); 
      System.out.println("  Buffer-Index: " + iIn + " Buffer size:" + in.length); 
      System.out.println("  Command: " + command); 
      }
    return iOut;
    }
  }
