/*
 * @(#)IFFChunk.java  1.1  2006-07-20
 *
 * Copyright (c) 1999-2006 Werner Randelshofer
 * Staldenmattweg 2, CH-6405 Immensee, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by Werner Randelshofer. 
 * You may not use, copy or modify this software, except in  
 * accordance with the license agreement you entered into with  
 * Werner Randelshofer. For details see accompanying license terms
 */
package ch.randelshofer.media.iff;

import java.util.*;
/**
 * IFF Chunks form the building blocks of an IFF file.
 * This class is made for reading purposes only. See MutableIFFChunk
 * for writing purposes.
 *
 * @author  Werner Randelshofer, Staldenmattweg 2, CH-6405 Immensee, Switzerland
 * @version 1.1 2006-07-20 Reworked for Java 1.5.
 * <br>1.0  1999-10-19
 */
public class IFFChunk {
    private int id_;
    private int type_;
    private long size_;
    private long scan_;
    private byte[] data_;
    private Hashtable propertyChunks_;
    private Vector collectionChunks_;
    
    public IFFChunk(int type, int id) {
        id_ = id;
        type_ = type;
        size_ = -1;
        scan_ = -1;
    }
    public IFFChunk(int type, int id, long size, long scan) {
        id_ = id;
        type_ = type;
        size_ = size;
        scan_ = scan;
    }
    public IFFChunk(int type, int id, long size, long scan, IFFChunk propGroup) {
        id_ = id;
        type_ = type;
        size_ = size;
        scan_ = scan;
        if (propGroup != null) {
            if (propGroup.propertyChunks_ != null) {
                propertyChunks_ = (Hashtable)propGroup.propertyChunks_.clone(); }
            if (propGroup.collectionChunks_ != null) {
                collectionChunks_ = (Vector)propGroup.collectionChunks_.clone(); }
        }
    }
    
    /**
     * @return  ID of chunk.
     */
    public int getID() {
        return id_; }
    
    /**
     * @return  Type of chunk.
     */
    public int getType() {
        return type_; }
    
    /**
     * @return  Size of chunk.
     */
    public long getSize() {
        return size_; }
    
    /**
     * @return  Scan position of chunk within the file.
     */
    public long getScan() {
        return scan_; }
    
    public void putPropertyChunk(IFFChunk chunk) {
        if (propertyChunks_ == null) {
            propertyChunks_ = new Hashtable(); }
        propertyChunks_.put(chunk,chunk);
    }
    public IFFChunk getPropertyChunk(int id) {
        if (propertyChunks_ == null) {
            return null; }
        IFFChunk chunk = new IFFChunk(type_, id);
        return (IFFChunk)propertyChunks_.get(chunk);
    }
    public Enumeration propertyChunks() {
        if (propertyChunks_ == null) {
            propertyChunks_ = new Hashtable(); }
        return propertyChunks_.keys();
    }
    public void addCollectionChunk(IFFChunk chunk) {
        if (collectionChunks_ == null) {
            collectionChunks_ = new Vector(); }
        collectionChunks_.addElement(chunk);
    }
    public IFFChunk[] getCollectionChunks(int id) {
        if (collectionChunks_ == null) {
            return new IFFChunk[0]; }
        Enumeration enm = collectionChunks_.elements();
        int i = 0;
        while ( enm.hasMoreElements() ) {
            IFFChunk chunk = (IFFChunk)enm.nextElement();
            if (chunk.id_ == id) {
                i++; }
        }
        IFFChunk[] array = new IFFChunk[i];
        i = 0;
        enm = collectionChunks_.elements();
        while ( enm.hasMoreElements() ) {
            IFFChunk chunk = (IFFChunk)enm.nextElement();
            if (chunk.id_ == id) {
                array[i++] = chunk; }
        }
        return array;
    }
    public Enumeration collectionChunks() {
        if (collectionChunks_ == null) {
            collectionChunks_ = new Vector(); }
        return collectionChunks_.elements();
    }
    
    /**
     * Sets the data.
     * Note: The array will not be cloned.
     */
    public void setData(byte[] data) {
        data_ = data; }
    /**
     * Gets the data.
     * Note: The array will not be cloned.
     */
    public byte[] getData() {
        return data_; }
    
    public boolean equals(Object another) {
        if (another instanceof IFFChunk) {
            IFFChunk that = (IFFChunk) another;
            return (that.id_ == this.id_ && that.type_ == this.type_);
        }
        return false;
    }
    
    public int hashCode() {
        return id_; }
    
    public String toString() {
        return super.toString()+"{"+IFFParser.idToString(getType())+","+IFFParser.idToString(getID())+"}";
    }
}
