/*
 * @(#)ColorCycle.java  1.0  2010-01-22
 * 
 * Copyright (c) 2010 Werner Randelshofer
 * Hausmatt 10, Immensee, CH-6405, Switzerland.
 * All rights reserved.
 * 
 * The copyright of this software is owned by Werner Randelshofer. 
 * You may not use, copy or modify this software, except in  
 * accordance with the license agreement you entered into with  
 * Werner Randelshofer. For details see accompanying license terms.
 */
package ch.randelshofer.media.ilbm;

/**
 * Base class for color cycling in an IFF ILBM image.
 *
 * @author Werner Randelshofer
 * @version 1.0 2010-01-22 Created.
 */
public abstract class ColorCycle implements Cloneable {

    /** Cycle rate. */
    protected int rate;
    /** Time scale of the cycle rate. Dividing the rate by the time scale yields
     * the rate per second.
     */
    protected int timeScale;
    /** Whether the color cycle is active. */
    protected boolean isActive;

    public ColorCycle(int rate, int timeScale, boolean isActive) {
        this.rate = rate;
        this.timeScale = timeScale;
        this.isActive = isActive;
    }

    public boolean isActive() {
        return isActive;
    }
    public int getRate() {
        return rate;
    }

    public int getTimeScale() {
        return timeScale;
    }


    public abstract void doCycle(int[] rgbs, long time);

    @Override
    protected Object clone() {
        try {
            return super.clone();
        } catch (CloneNotSupportedException ex) {
            InternalError error = new InternalError();
            error.initCause(ex);
            throw error;
        }
    }
}
