/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.media.iff;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class MC68000InputStream
extends FilterInputStream {
    private long scan_;
    private long mark_;

    public MC68000InputStream(InputStream in) {
        super(in);
    }

    public int readUBYTE() throws IOException {
        int b0 = this.in.read();
        if (b0 == -1) {
            throw new EOFException();
        }
        ++this.scan_;
        return b0 & 0xFF;
    }

    public short readWORD() throws IOException {
        int b0 = this.in.read();
        int b1 = this.in.read();
        if (b1 == -1) {
            throw new EOFException();
        }
        this.scan_ += 2L;
        return (short)((b0 & 0xFF) << 8 | b1 & 0xFF);
    }

    public int readUWORD() throws IOException {
        return this.readWORD() & 0xFFFF;
    }

    public int readLONG() throws IOException {
        int b0 = this.in.read();
        int b1 = this.in.read();
        int b2 = this.in.read();
        int b3 = this.in.read();
        if (b3 == -1) {
            throw new EOFException();
        }
        this.scan_ += 4L;
        return (b0 & 0xFF) << 24 | (b1 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b3 & 0xFF;
    }

    public long readULONG() throws IOException {
        return (long)this.readLONG() & 0xFFFFFFFFFFFFFFFFL;
    }

    public void align() throws IOException {
        if (this.scan_ % 2L == 1L) {
            this.in.skip(1L);
            ++this.scan_;
        }
    }

    public long getScan() {
        return this.scan_;
    }

    public int read() throws IOException {
        int data = this.in.read();
        ++this.scan_;
        return data;
    }

    public int readFully(byte[] b, int offset, int length) throws IOException {
        return this.read(b, offset, length);
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        int count;
        for (count = 0; count < length; count += this.in.read(b, offset + count, length - count)) {
        }
        this.scan_ += (long)count;
        return count;
    }

    public void mark(int readlimit) {
        this.in.mark(readlimit);
        this.mark_ = this.scan_;
    }

    public void reset() throws IOException {
        this.in.reset();
        this.scan_ = this.mark_;
    }

    public long skip(long n) throws IOException {
        long skipped = this.in.skip(n);
        this.scan_ += skipped;
        return skipped;
    }

    public void skipFully(long n) throws IOException {
        int total = 0;
        int cur = 0;
        while ((long)total < n && (cur = (int)this.in.skip(n - (long)total)) > 0) {
            total += cur;
        }
        if (cur == 0) {
            throw new EOFException();
        }
        this.scan_ += (long)total;
    }

    public static int unpackByteRun1(byte[] in, byte[] out) throws IOException {
        int iOut = 0;
        int iIn = 0;
        int n = 0;
        try {
            while (iOut < out.length) {
                if ((n = in[iIn++]) >= 0) {
                    System.arraycopy(in, iIn, out, iOut, ++n);
                    iOut += n;
                    iIn += n;
                    continue;
                }
                if (n == -128) continue;
                byte copyByte = in[iIn++];
                while (n < 1) {
                    out[iOut++] = copyByte;
                    ++n;
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.out.println("PBMDecoder.unpackByteRun1(): " + e);
            System.out.println("  Plane-Index: " + iOut + " Plane size:" + out.length);
            System.out.println("  Buffer-Index: " + iIn + " Buffer size:" + in.length);
            System.out.println("  Command: " + n);
        }
        return iOut;
    }
}

