/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.media;

import ch.randelshofer.media.Player;
import ch.randelshofer.media.StateEvent;
import ch.randelshofer.media.StateListener;
import ch.randelshofer.media.concurrent.SequentialDispatcher;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public abstract class AbstractPlayer
implements Player,
Runnable {
    private int state = 0;
    private int targetState = 0;
    protected EventListenerList listenerList = new EventListenerList();
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    protected SequentialDispatcher dispatcher = new SequentialDispatcher();

    public int getState() {
        return this.state;
    }

    public int getTargetState() {
        return this.targetState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTargetState(int state) {
        AbstractPlayer abstractPlayer = this;
        synchronized (abstractPlayer) {
            if (this.targetState != -1) {
                this.targetState = state;
                this.notifyAll();
                this.dispatcher.dispatch(this);
            }
        }
    }

    public void realize() {
        switch (this.getState()) {
            case -1: {
                throw new IllegalStateException("Realize closed player.");
            }
            case 5: {
                throw new IllegalStateException("Realize started player.");
            }
        }
        this.setTargetState(2);
    }

    public void prefetch() {
        switch (this.getState()) {
            case -1: {
                throw new IllegalStateException("Prefetch closed player.");
            }
            case 5: {
                throw new IllegalStateException("Prefetch started player.");
            }
        }
        this.setTargetState(4);
    }

    public void deallocate() {
        switch (this.getState()) {
            case -1: {
                throw new IllegalStateException("Deallocate closed player.");
            }
            case 1: {
                this.setTargetState(0);
                break;
            }
            case 3: {
                this.setTargetState(2);
                break;
            }
            case 4: {
                this.setTargetState(2);
                break;
            }
            case 5: {
                throw new IllegalStateException("Deallocate started player.");
            }
        }
    }

    public void start() {
        switch (this.getState()) {
            case -1: {
                throw new IllegalStateException("Can't start closed player.");
            }
        }
        this.setTargetState(5);
    }

    public void stop() {
        switch (this.getState()) {
            case -1: {
                break;
            }
            case 5: {
                this.setTargetState(4);
            }
        }
    }

    public void close() {
        this.setTargetState(-1);
    }

    public void addStateListener(StateListener l) {
        this.listenerList.add(StateListener.class, l);
    }

    public void removeStateListener(StateListener l) {
        this.listenerList.remove(StateListener.class, l);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    protected void fireStateChanged(int newState) {
        StateEvent stateEvent = null;
        ChangeEvent changeEvent = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] == StateListener.class) {
                if (stateEvent == null) {
                    stateEvent = new StateEvent(this, newState);
                }
                ((StateListener)listeners[i + 1]).stateChanged(stateEvent);
            }
            if (listeners[i] != ChangeListener.class) continue;
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(changeEvent);
        }
    }

    protected void fireStateChanged() {
        Object stateEvent = null;
        ChangeEvent changeEvent = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ChangeListener.class) continue;
            if (changeEvent == null) {
                changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(changeEvent);
        }
    }

    public void run() {
        while (this.state != this.targetState) {
            this.state = this.targetState > this.state ? ++this.state : this.targetState;
            this.fireStateChanged(this.state);
            switch (this.state) {
                case -1: {
                    this.doClosed();
                    break;
                }
                case 0: {
                    this.doUnrealized();
                    break;
                }
                case 1: {
                    this.doRealizing();
                    break;
                }
                case 2: {
                    this.doRealized();
                    break;
                }
                case 3: {
                    this.doPrefetching();
                    break;
                }
                case 4: {
                    this.doPrefetched();
                    break;
                }
                case 5: {
                    this.doStarted();
                    this.setTargetState(4);
                }
            }
        }
    }

    protected abstract void doClosed();

    protected abstract void doUnrealized();

    protected abstract void doRealizing();

    protected abstract void doRealized();

    protected abstract void doPrefetching();

    protected abstract void doPrefetched();

    protected abstract void doStarted();

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    public boolean isActive() {
        return this.getTargetState() == 5;
    }
}

