/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.media;

import ch.randelshofer.media.StateEvent;
import ch.randelshofer.media.StateListener;
import ch.randelshofer.media.StateModel;

public class StateTracker
implements StateListener {
    private StateModel model_;
    private int[] targetStates_;

    public StateTracker(StateModel model) {
        this.setStateModel(model);
    }

    public void setStateModel(StateModel model) {
        if (this.model_ != null) {
            this.model_.removeStateListener(this);
        }
        this.model_ = model;
        if (this.model_ != null) {
            this.model_.addStateListener(this);
        }
    }

    public void waitForState(int state) {
        int[] statelist = new int[]{state};
        this.waitForState(statelist);
    }

    public int waitForState(int[] states) {
        StateTracker stateTracker = this;
        synchronized (stateTracker) {
            this.targetStates_ = states;
            while (true) {
                int state = this.model_.getState();
                for (int i = 0; i < this.targetStates_.length; ++i) {
                    if (state != this.targetStates_[i]) continue;
                    return this.targetStates_[i];
                }
                try {
                    this.wait();
                }
                catch (InterruptedException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stateChanged(StateEvent event) {
        StateTracker stateTracker = this;
        synchronized (stateTracker) {
            if (this.targetStates_ != null) {
                int state = event.getNewState();
                for (int i = 0; i < this.targetStates_.length; ++i) {
                    if (state != this.targetStates_[i]) continue;
                    this.notifyAll();
                    break;
                }
            }
        }
    }
}

