/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.media.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;

public class ImagePanel
extends JComponent {
    private static final RenderingHints RENDER_SPEED;
    public static final int IGNORE_PIXEL_ASPECT = 0;
    public static final int ROUNDED_PIXEL_ASPECT = 1;
    public static final int EXACT_PIXEL_ASPECT = 2;
    public static final int ANAMORPH_PIXEL_ASPECT = 3;
    public static final int SCALE_TO_IMAGE_SIZE = 0;
    public static final int SCALE_TO_VIEW_SIZE = 1;
    public static final int SCALE_TO_IMAGE_ASPECT = 2;
    private Image image;
    private double scaleFactor = 1.0;
    private double aspectRatioX = 1.0;
    private double aspectRatioY = 1.0;
    private int imageScalePolicy = 1;
    private int pixelAspectPolicy = 2;
    private String message;
    private BufferedImage texture;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private RenderingHints renderingHints = RENDER_SPEED;

    public void paintComponent(Graphics gr) {
        Graphics2D g = (Graphics2D)gr;
        Dimension size = this.getSize();
        Rectangle clipRect = g.getClipBounds();
        g.setRenderingHints(this.renderingHints);
        g.setColor(this.getBackground());
        g.fillRect(clipRect.x, clipRect.y, clipRect.width, clipRect.height);
        if (this.image != null && this.image.getWidth(this) != -1) {
            int h;
            int w;
            int y;
            int x;
            int iw = this.image.getWidth(this);
            int ih = this.image.getHeight(this);
            double xAspect = this.getPixelAspectX();
            double yAspect = this.getPixelAspectY();
            switch (this.imageScalePolicy) {
                case 1: {
                    double factor = Math.min((double)size.width / (double)iw, (double)size.height / (double)ih);
                    x = 0;
                    y = 0;
                    w = size.width;
                    h = size.height;
                    break;
                }
                case 2: {
                    double factor = Math.min((double)size.width / ((double)iw * xAspect), (double)size.height / ((double)ih * yAspect));
                    this.setScaleFactor(factor, false);
                    w = (int)Math.ceil((double)iw * xAspect * factor);
                    h = (int)Math.ceil((double)ih * yAspect * factor);
                    x = (size.width - w) / 2;
                    y = (size.height - h) / 2;
                    if (size.width > w) {
                        g.setColor(this.getForeground());
                        g.drawLine(x - 1, 0, x - 1, size.height - 1);
                        g.drawLine(x + w, 0, x + w, size.height - 1);
                        break;
                    }
                    if (size.height <= h) break;
                    g.setColor(this.getForeground());
                    g.drawLine(0, y - 1, size.width - 1, y - 1);
                    g.drawLine(0, y + h, size.width - 1, y + h);
                    break;
                }
                default: {
                    w = (int)((double)iw * xAspect * this.getScaleFactor());
                    h = (int)((double)ih * yAspect * this.getScaleFactor());
                    x = (size.width - w) / 2;
                    y = (size.height - h) / 2;
                    g.setColor(this.getForeground());
                    g.drawRect(x - 1, y - 1, w + 1, h + 1);
                }
            }
            if (this.texture != null) {
                g.setPaint(new TexturePaint(this.texture, new Rectangle(x, y, this.texture.getWidth(), this.texture.getHeight())));
                g.fillRect(x, y, w, h);
                g.drawImage(this.image, x, y, w, h, this);
            } else {
                g.drawImage(this.image, x, y, w, h, this.getBackground(), this);
            }
        }
        if (this.message != null) {
            int y = g.getFontMetrics().getMaxAscent();
            for (String msg : this.message.split("\n")) {
                g.setColor(this.getBackground());
                g.drawString(msg, 1, y + 1);
                g.drawString(msg, 1, y - 1);
                g.drawString(msg, 0, y);
                g.drawString(msg, 2, y);
                g.setColor(this.getForeground());
                g.drawString(msg, 1, y);
                y += g.getFontMetrics().getMaxAscent();
            }
        }
    }

    public synchronized void setPixelAspectPolicy(int policy) {
        int old = this.pixelAspectPolicy;
        if (old != policy) {
            if (policy != 0 && policy != 1 && policy != 2) {
                throw new IllegalArgumentException("Invalid policy:" + policy);
            }
            this.pixelAspectPolicy = policy;
            this.propertyChangeSupport.firePropertyChange("pixelAspectPolicy", new Integer(old), new Integer(policy));
            this.invalidate();
            Container parent = this.getParent();
            if (parent != null) {
                ((Component)parent).validate();
            }
            this.repaint();
        }
    }

    public int getPixelAspectPolicy() {
        return this.pixelAspectPolicy;
    }

    public synchronized void setImageScalePolicy(int policy) {
        int old = this.imageScalePolicy;
        if (old != policy) {
            if (policy != 0 && policy != 1 && policy != 2) {
                throw new IllegalArgumentException("Invalid policy:" + policy);
            }
            this.imageScalePolicy = policy;
            this.propertyChangeSupport.firePropertyChange("imageScalePolicy", new Integer(old), new Integer(policy));
            this.invalidate();
            Container parent = this.getParent();
            if (parent != null) {
                ((Component)parent).validate();
            }
            this.repaint();
        }
    }

    public int getImageScalePolicy() {
        return this.imageScalePolicy;
    }

    public double getPixelAspectX() {
        if (this.image == null) {
            return 0.0;
        }
        Object property = this.image.getProperty("aspect", this);
        if (property == null) {
            return 1.0;
        }
        double ratio = property == null || property == Image.UndefinedProperty ? 1.0 : (Double)property;
        switch (this.pixelAspectPolicy) {
            case 0: {
                return 1.0;
            }
            case 2: {
                return ratio >= 1.0 ? ratio : 1.0;
            }
            case 1: {
                return ratio >= 1.0 ? Math.floor(ratio + 0.5) : 1.0;
            }
        }
        throw new InternalError("Invalid pixel aspect policy: " + this.pixelAspectPolicy);
    }

    public double getPixelAspectY() {
        if (this.image == null) {
            return 0.0;
        }
        Object property = this.image.getProperty("aspect", this);
        if (property == null) {
            return 1.0;
        }
        double ratio = property == null || property == Image.UndefinedProperty ? 1.0 : (Double)property;
        switch (this.pixelAspectPolicy) {
            case 0: {
                return 1.0;
            }
            case 2: {
                return ratio < 1.0 ? 1.0 / ratio : 1.0;
            }
            case 1: {
                return ratio < 1.0 ? Math.floor(1.0 / ratio + 0.5) : 1.0;
            }
        }
        throw new InternalError("Invalid pixel aspect policy: " + this.pixelAspectPolicy);
    }

    public Dimension getPreferredImageSize() {
        if (this.image == null) {
            return new Dimension(0, 0);
        }
        if (this.image.getWidth(this) == -1) {
            try {
                MediaTracker tracker = new MediaTracker(this);
                tracker.addImage(this.image, 0);
                tracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return new Dimension((int)Math.ceil((double)this.image.getWidth(this) * this.getPixelAspectX()), (int)Math.ceil((double)this.image.getHeight(this) * this.getPixelAspectY()));
    }

    public Dimension getScaledImageSize() {
        if (this.image == null) {
            return new Dimension(0, 0);
        }
        if (this.image.getWidth(this) == -1) {
            try {
                MediaTracker tracker = new MediaTracker(this);
                tracker.addImage(this.image, 0);
                tracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return new Dimension((int)Math.ceil((double)this.image.getWidth(this) * this.getPixelAspectX() * this.getAspectRatioX() * this.getScaleFactor()), (int)Math.ceil((double)this.image.getHeight(this) * this.getPixelAspectY() * this.getAspectRatioY() * this.getScaleFactor()));
    }

    public void setImage(Image image) {
        Image old = this.image;
        this.image = image;
        this.invalidate();
        Container parent = this.getParent();
        if (parent != null) {
            ((Component)parent).validate();
        }
        this.repaint();
        this.propertyChangeSupport.firePropertyChange("image", old, image);
    }

    public Image getImage() {
        return this.image;
    }

    public void setTexture(BufferedImage newValue) {
        BufferedImage old = this.texture;
        this.texture = newValue;
        this.propertyChangeSupport.firePropertyChange("texture", old, newValue);
    }

    public BufferedImage getTexture() {
        return this.texture;
    }

    public void setScaleFactor(double scaleFactor) {
        this.setScaleFactor(scaleFactor, true);
    }

    private synchronized void setScaleFactor(double scaleFactor, boolean repaint) {
        double old = this.scaleFactor;
        this.scaleFactor = scaleFactor;
        if (scaleFactor != old) {
            this.propertyChangeSupport.firePropertyChange("scaleFactor", new Double(old), new Double(scaleFactor));
            if (repaint) {
                Container parent = this.getParent();
                if (parent != null) {
                    ((Component)parent).invalidate();
                    ((Component)parent).validate();
                }
                this.repaint();
            }
        }
    }

    public synchronized double getScaleFactor() {
        return this.scaleFactor;
    }

    public void setRenderingHints(RenderingHints newValue) {
        this.setRenderingHints(newValue, true);
    }

    private synchronized void setRenderingHints(RenderingHints newValue, boolean repaint) {
        RenderingHints old = this.renderingHints;
        this.renderingHints = newValue;
        if (newValue != old) {
            this.propertyChangeSupport.firePropertyChange("renderingHints", old, newValue);
            if (repaint) {
                Container parent = this.getParent();
                if (parent != null) {
                    ((Component)parent).invalidate();
                    ((Component)parent).validate();
                }
                this.repaint();
            }
        }
    }

    public synchronized RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    public void setAspectRatio(double ratioX, double ratioY) {
        if (this.aspectRatioX != ratioX || this.aspectRatioY != ratioY) {
            this.setAspectRatio0(ratioX, ratioY);
            Container parent = this.getParent();
            if (parent != null) {
                ((Component)parent).invalidate();
                ((Component)parent).validate();
            }
            this.repaint();
        }
    }

    protected void setAspectRatio0(double ratioX, double ratioY) {
        double oldX = this.aspectRatioX;
        double oldY = this.aspectRatioY;
        this.aspectRatioX = ratioX;
        this.aspectRatioY = ratioY;
        this.propertyChangeSupport.firePropertyChange("aspectRatioX", new Double(oldX), new Double(ratioX));
        this.propertyChangeSupport.firePropertyChange("aspectRatioY", new Double(oldY), new Double(ratioY));
    }

    public double getAspectRatioX() {
        return this.aspectRatioX;
    }

    public double getAspectRatioY() {
        return this.aspectRatioY;
    }

    public Dimension getPreferredSize() {
        if (this.image == null) {
            return new Dimension(50, 15);
        }
        return this.getScaledImageSize();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void setMessage(String message) {
        String old = this.message;
        this.message = message;
        this.propertyChangeSupport.firePropertyChange("message", old, message);
        this.repaint();
    }

    public boolean imageUpdate(Image img, int flags, int x, int y, int w, int h) {
        if (flags == 8) {
            return true;
        }
        return super.imageUpdate(img, flags, x, y, w, h);
    }

    static {
        RenderingHints rh = new RenderingHints(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        rh.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        rh.put(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        rh.put(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        rh.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        rh.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        rh.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        rh.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        rh.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        RENDER_SPEED = rh;
    }
}

