/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.util;

import ch.randelshofer.util.ArrayUtil;
import java.applet.Applet;
import java.awt.Color;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class Applets {
    private static boolean debug = false;
    private static HashMap<String, String> fallback;
    private static final Hashtable htmlColors;
    private static final Hashtable javaColors;

    private Applets() {
    }

    public static void setDebug(boolean newValue) {
        debug = newValue;
    }

    public static void setMainArgs(Applet applet, String[] args) {
        fallback = new HashMap();
        HashMap<String, String[]> info = new HashMap<String, String[]>();
        for (String[] pinf : applet.getParameterInfo()) {
            info.put(pinf[0], pinf);
        }
        boolean helpNeeded = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-help")) {
                helpNeeded = true;
                continue;
            }
            if (i < args.length - 1 && args[i].startsWith("-")) {
                if (!info.containsKey(args[i].substring(1))) continue;
                fallback.put(args[i].substring(1), args[i + 1]);
                ++i;
                continue;
            }
            System.err.println("Illegal parameter: " + args[i]);
        }
        if (helpNeeded) {
            System.out.println(applet.getAppletInfo());
            System.out.println("\nSupported Parameters:");
            for (String[] pinf : applet.getParameterInfo()) {
                System.out.println(pinf[0] + "\t" + pinf[1] + "\t" + pinf[2]);
            }
        }
    }

    public static Color getParameter(Applet applet, String name, Color defaultValue) {
        String value = Applets.getParameter(applet, name);
        if (value != null) {
            if (htmlColors.contains(value = value.toLowerCase())) {
                return (Color)htmlColors.get(value);
            }
            if (javaColors.contains(value)) {
                return (Color)javaColors.get(value);
            }
            int[] ints = Applets.getParameters(applet, name, new int[0]);
            switch (ints.length) {
                case 1: {
                    return new Color(ints[0]);
                }
                case 3: {
                    return new Color(ints[0], ints[1], ints[2]);
                }
            }
        }
        return defaultValue;
    }

    public static String getParameter(Applet applet, String name, String defaultValue) {
        String value = Applets.getParameter(applet, name);
        String string = value = value != null ? value : defaultValue;
        if (debug) {
            System.out.println("Applets.getParameter(" + name + "):" + value);
        }
        return value;
    }

    public static String[] getParameters(Applet applet, String name, String[] defaultValue) {
        String param = Applets.getParameter(applet, name);
        if (param != null) {
            StringTokenizer scanner = new StringTokenizer(param, ", ");
            String[] values = new String[scanner.countTokens()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = scanner.nextToken();
            }
            if (debug) {
                System.out.println("Applets.getParameter(" + name + "):" + Arrays.asList(values));
            }
            return values;
        }
        if (debug) {
            System.out.println("Applets.getParameter(" + name + "):" + (defaultValue == null ? null : Arrays.asList(defaultValue)));
        }
        return defaultValue;
    }

    public static String getParameter(Applet applet, String name) {
        try {
            return applet.getParameter(name);
        }
        catch (NullPointerException e) {
            if (fallback != null) {
                return fallback.get(name);
            }
            return null;
        }
    }

    public static int getParameter(Applet applet, String name, int defaultValue) {
        String value = Applets.getParameter(applet, name);
        if (value != null) {
            try {
                int intValue = Applets.decode(value);
                if (debug) {
                    System.out.println("Applets.getParameter(" + name + "):" + intValue);
                }
                return intValue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (debug) {
            System.out.println("Applets.getParameter(" + name + "):" + defaultValue);
        }
        return defaultValue;
    }

    public static boolean getParameter(Applet applet, String name, boolean defaultValue) {
        String value = Applets.getParameter(applet, name);
        if (value != null) {
            boolean booleanValue = Boolean.valueOf(value);
            if (debug) {
                System.out.println("Applets.getParameter(" + name + "):" + booleanValue);
            }
            return booleanValue;
        }
        if (debug) {
            System.out.println("Applets.getParameter(" + name + "):" + defaultValue);
        }
        return defaultValue;
    }

    public static int[] getParameters(Applet applet, String name, int[] defaultValue) {
        String value = Applets.getParameter(applet, name);
        if (value != null) {
            try {
                StringTokenizer scanner = new StringTokenizer(value, ", ");
                int[] values = new int[scanner.countTokens()];
                for (int i = 0; i < values.length; ++i) {
                    values[i] = Applets.decode(scanner.nextToken());
                }
                if (debug) {
                    System.out.println("Applets.getParameter(" + name + "):" + ArrayUtil.asList(values));
                }
                return values;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (debug) {
            System.out.println("Applets.getParameter(" + name + "):" + (defaultValue == null ? null : ArrayUtil.asList(defaultValue)));
        }
        return defaultValue;
    }

    public static double getParameter(Applet applet, String name, double defaultValue) {
        String value = Applets.getParameter(applet, name);
        if (value != null) {
            try {
                double doubleValue = Double.valueOf(value);
                if (debug) {
                    System.out.println("Applets.getParameter(" + name + "):" + doubleValue);
                }
                return doubleValue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (debug) {
            System.out.println("Applets.getParameter(" + name + "):" + defaultValue);
        }
        return defaultValue;
    }

    public static Hashtable getIndexedKeyValueParameters(Applet applet, String name, Hashtable defaultValue) {
        String param = Applets.getParameter(applet, name);
        if (param != null) {
            Hashtable<String, String> map = new Hashtable<String, String>();
            StringTokenizer scanner = new StringTokenizer(param, ", ");
            int count = scanner.countTokens();
            for (int i = 0; i < count; ++i) {
                String value;
                String key;
                String entry = scanner.nextToken();
                int pos = entry.indexOf(61);
                if (pos < 1) {
                    key = null;
                    value = entry;
                } else {
                    key = entry.substring(0, pos);
                    value = entry.substring(pos + 1);
                }
                String generatedKey = Integer.toString(i);
                if (key != null) {
                    map.put(key, value);
                }
                if (map.contains(generatedKey)) continue;
                map.put(generatedKey, value);
            }
            if (debug) {
                System.out.println("Applets.getParameter(" + name + "):" + map);
            }
            return map;
        }
        if (debug) {
            System.out.println("Applets.getParameter(" + name + "):" + defaultValue);
        }
        return defaultValue;
    }

    public static Integer decode(String nm) throws NumberFormatException {
        Integer result;
        int radix = 10;
        int index = 0;
        boolean negative = false;
        if (nm.startsWith("-")) {
            negative = true;
            ++index;
        }
        if (nm.startsWith("0x", index) || nm.startsWith("0X", index)) {
            index += 2;
            radix = 16;
        } else if (nm.startsWith("#", index)) {
            ++index;
            radix = 16;
        } else if (nm.startsWith("0", index) && nm.length() > 1 + index) {
            ++index;
            radix = 8;
        }
        if (nm.startsWith("-", index)) {
            throw new NumberFormatException("Negative sign in wrong position");
        }
        try {
            result = Integer.valueOf(nm.substring(index), radix);
            result = negative ? new Integer(-result.intValue()) : result;
        }
        catch (NumberFormatException e) {
            String constant = negative ? new String("-" + nm.substring(index)) : nm.substring(index);
            result = Integer.valueOf(constant, radix);
        }
        return result;
    }

    static {
        htmlColors = new Hashtable();
        htmlColors.put("black", new Color(0));
        htmlColors.put("green", new Color(32768));
        htmlColors.put("silver", new Color(0xC0C0C0));
        htmlColors.put("lime", new Color(65280));
        htmlColors.put("gray", new Color(0x808080));
        htmlColors.put("olive", new Color(0x808000));
        htmlColors.put("white", new Color(0xFFFFFF));
        htmlColors.put("yellow", new Color(0xFFFF00));
        htmlColors.put("maroon", new Color(0x800000));
        htmlColors.put("navy", new Color(128));
        htmlColors.put("red", new Color(0xFF0000));
        htmlColors.put("blue", new Color(255));
        htmlColors.put("purple", new Color(0x800080));
        htmlColors.put("teal", new Color(32896));
        htmlColors.put("fuchsia", new Color(0xFF00FF));
        htmlColors.put("aqua", new Color(65535));
        javaColors = new Hashtable();
        javaColors.put("white", Color.white);
        javaColors.put("lightgray", Color.lightGray);
        javaColors.put("gray", Color.gray);
        javaColors.put("darkgray", Color.darkGray);
        javaColors.put("black", Color.black);
        javaColors.put("red", Color.red);
        javaColors.put("pink", Color.pink);
        javaColors.put("orange", Color.orange);
        javaColors.put("yellow", Color.yellow);
        javaColors.put("green", Color.green);
        javaColors.put("magenta", Color.magenta);
        javaColors.put("cyan", Color.cyan);
        javaColors.put("blue", Color.blue);
    }
}

