/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package ch.randelshofer.media;

/**
 * {@code AbstractCodec}.
 *
 * @author Werner Randelshofer
 * @version 1.0 2011-03-12 Created.
 */
public abstract class AbstractCodec implements Codec {

    protected Format[] supportedInputFormats;
    protected Format[] supportedOutputFormats;
    protected Format inputFormat;
    protected Format outputFormat;
    protected float quality = 1;

    public AbstractCodec(Format[] supportedInputFormats, Format[] supportedOutputFormats) {
        this.supportedInputFormats = supportedInputFormats;
        this.supportedOutputFormats = supportedOutputFormats;
    }

    @Override
    public Format[] getSupportedInputFormats() {
        return supportedInputFormats.clone();
    }

    @Override
    public Format[] getSupportedOutputFormats() {
        return supportedOutputFormats.clone();
    }

    @Override
    public Format setInputFormat(Format f) {
        for (Format sf : getSupportedInputFormats()) {
            if (sf.matches(f)) {
                this.inputFormat = f;
                return sf;
            }
        }
        this.inputFormat=null;
        return null;
    }

    @Override
    public Format setOutputFormat(Format f) {
        for (Format sf : getSupportedOutputFormats()) {
            if (sf.matches(f)) {
                this.outputFormat = f;
                return sf;
            }
        }
        this.outputFormat=null;
        return null;
    }

    @Override
    public void setQuality(float newValue) {
        quality = newValue;
    }

    @Override
    public float getQuality() {
        return quality;
    }
}
